/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras.channel.merge;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.extras.ReturnCodes;
import org.wildfly.prospero.extras.shared.CommandWithHelp;
import picocli.CommandLine;

@CommandLine.Command(name="merge-repositories", sortOptions=false)
public class ChannelMergeCommand
extends CommandWithHelp {
    @CommandLine.Option(names={"--manifest-url"}, required=true, order=1)
    URL manifestUrl;
    @CommandLine.Option(names={"--channel"}, split=",", required=true, order=2)
    List<Path> inputChannelPaths;
    @CommandLine.Option(names={"--name"}, required=false, order=3)
    String name;
    @CommandLine.Option(names={"--description"}, required=false, order=4)
    String description;

    @Override
    public Integer call() throws Exception {
        Stream<Channel> channels = this.inputChannelPaths.stream().map(ChannelMergeCommand::read).flatMap(Collection::stream);
        Channel channel = this.merge(channels, this.manifestUrl, this.name, this.description);
        System.out.println(ChannelMapper.toYaml(channel));
        return ReturnCodes.SUCCESS;
    }

    Channel merge(Stream<Channel> channels, URL url, String name, String description) {
        Channel.Builder channelBuilder = new Channel.Builder().setManifestUrl(url);
        if (name != null) {
            channelBuilder.setName(name);
        }
        if (description != null) {
            channelBuilder.setDescription(description);
        }
        channels.map(Channel::getRepositories).flatMap(Collection::stream).distinct().sorted(Comparator.comparing(Repository::getId)).forEach(r -> channelBuilder.addRepository(r.getId(), r.getUrl()));
        return channelBuilder.build();
    }

    private static List<Channel> read(Path path) {
        try {
            return ChannelMapper.fromString(Files.readString(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

