/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras.channel.query;

import java.nio.file.Path;
import java.util.List;
import org.eclipse.aether.RepositorySystem;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.prospero.extras.ReturnCodes;
import org.wildfly.prospero.extras.shared.CommandWithHelp;
import org.wildfly.prospero.wfchannel.MavenSessionManager;
import picocli.CommandLine;

@CommandLine.Command(name="query-version")
public class QueryVersionCommand
extends CommandWithHelp {
    @CommandLine.Option(names={"--channel"}, required=false)
    private Path channelFile;
    @CommandLine.Option(names={"--groupId"})
    private String groupId;
    @CommandLine.Option(names={"--artifactId"})
    private String artifactId;

    @Override
    public Integer call() throws Exception {
        MavenSessionManager msm = new MavenSessionManager();
        RepositorySystem system = msm.newRepositorySystem();
        VersionResolverFactory factory = new VersionResolverFactory(system, msm.newRepositorySystemSession(system));
        ChannelSession ses = new ChannelSession(List.of(ChannelMapper.from(this.channelFile.toUri().toURL())), factory);
        System.out.println(ses.findLatestMavenArtifactVersion(this.groupId, this.artifactId, null, null, null));
        return ReturnCodes.SUCCESS;
    }
}

