/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras.repository.create;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.jboss.logging.Logger;

class CoordUtils {
    private static final Logger LOG = Logger.getLogger(CoordUtils.class);

    CoordUtils() {
    }

    static DefaultArtifact fromLocalPath(String path) {
        Pattern filenamePattern;
        Matcher matcher;
        int index = path.lastIndexOf(47);
        if (index < 0) {
            throw new RuntimeException("Invalid path " + path + ". Unable to convert to maven coordinate.");
        }
        String filename = path.substring(index + 1);
        String rest = path.substring(0, index);
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Found filename %s and remaining path is %s", (Object)filename, (Object)rest);
        }
        if ((index = rest.lastIndexOf(47)) < 0) {
            throw new RuntimeException("Invalid path " + path + ". Unable to convert to maven coordinate.");
        }
        String version = rest.substring(index + 1);
        rest = path.substring(0, index);
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Found version %s and remaining path is %s", (Object)version, (Object)rest);
        }
        if (!(matcher = (filenamePattern = Pattern.compile("(.*)-" + version + "-?(.*)\\.(.*)$")).matcher(filename)).matches()) {
            throw new RuntimeException("Unable to parse filename " + filename);
        }
        String artifactId = matcher.group(1);
        String classifier = matcher.group(2);
        String extension = matcher.group(3);
        if (rest.startsWith("/")) {
            rest = rest.substring(1);
        }
        if (rest.endsWith("/")) {
            rest = rest.substring(0, rest.length() - 1);
        }
        String groupId = rest.replace("/" + artifactId.replace('.', '/'), "").replace('/', '.');
        if (LOG.isDebugEnabled()) {
            LOG.debug("groupId " + groupId);
            LOG.debug("artifactId " + artifactId);
            LOG.debug("classifier " + classifier);
            LOG.debug("extension " + extension);
        }
        return new DefaultArtifact(groupId, artifactId, classifier, extension, version);
    }
}

