/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel.version;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.wildfly.channel.version.VersionMatcher;

public class VersionPatternMatcher
implements VersionMatcher {
    private final Pattern pattern;

    public VersionPatternMatcher(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public Optional<String> matches(Set<String> samples) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String sample : samples) {
            if (!this.pattern.matcher(sample).matches()) continue;
            matches.add(sample);
        }
        if (matches.isEmpty()) {
            return Optional.empty();
        }
        matches.sort(COMPARATOR);
        return Optional.of((String)matches.get(matches.size() - 1));
    }
}

