/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class SubscribeNewServerAction {
    private final MavenSessionManager mavenSessionManager;
    private final Console console;

    public SubscribeNewServerAction(MavenOptions mvnOptions, Console console) throws ProvisioningException {
        this.console = console;
        this.mavenSessionManager = new MavenSessionManager(mvnOptions);
    }

    public GenerateResult generateServerMetadata(List<Channel> channels, FeaturePackLocation loc) throws IOException, ProvisioningException, OperationException {
        Path tempDir = Files.createTempDirectory("tmp-prov-", new FileAttribute[0]);
        boolean manifestCoordDefined = channels.stream().anyMatch(c -> c.getManifestCoordinate() != null);
        tempDir.toFile().deleteOnExit();
        try (GalleonEnvironment galleonEnv = GalleonEnvironment.builder(tempDir, channels, this.mavenSessionManager).setArtifactDirectResolve(!manifestCoordDefined).setConsole(this.console).build();){
            FeaturePackConfig.Builder configBuilder = FeaturePackConfig.builder(loc).includePackage("docs.examples.configs");
            ProvisioningConfig provisioningConfig = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(configBuilder.build())).build();
            try {
                GalleonUtils.executeGalleon(options -> galleonEnv.getProvisioningManager().provision(provisioningConfig, (Map<String, String>)options), this.mavenSessionManager.getProvisioningRepo().toAbsolutePath());
            }
            catch (UnresolvedMavenArtifactException e) {
                throw new ArtifactResolutionException(ProsperoLogger.ROOT_LOGGER.unableToResolve(), e, e.getUnresolvedArtifacts(), e.getAttemptedRepositories(), this.mavenSessionManager.isOffline());
            }
            GenerateResult generateResult = new GenerateResult(tempDir, channels, galleonEnv.getChannelSession().getRecordedChannel(), manifestCoordDefined);
            return generateResult;
        }
    }

    public static class GenerateResult {
        private final List<Channel> channels;
        private final Path provisionDir;
        private final ChannelManifest manifest;
        private final boolean manifestCoordDefined;

        GenerateResult(Path provisionDir, List<Channel> channels, ChannelManifest manifest, boolean manifestCoordDefined) {
            this.provisionDir = provisionDir;
            this.channels = channels;
            this.manifest = manifest;
            this.manifestCoordDefined = manifestCoordDefined;
        }

        public List<Channel> getChannels() {
            return this.channels;
        }

        public Path getProvisionDir() {
            return this.provisionDir;
        }

        public ChannelManifest getManifest() {
            return this.manifest;
        }

        public boolean isManifestCoordDefined() {
            return this.manifestCoordDefined;
        }
    }
}

