/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras.channel.query;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.aether.RepositorySystem;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.VersionResult;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.prospero.extras.ReturnCodes;
import org.wildfly.prospero.extras.shared.CommandWithHelp;
import org.wildfly.prospero.wfchannel.MavenSessionManager;
import picocli.CommandLine;

@CommandLine.Command(name="query-version")
public class QueryVersionCommand
extends CommandWithHelp {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(JSON_FACTORY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    @CommandLine.Option(names={"--channel"}, required=false)
    private Path channelFile;
    @CommandLine.Option(names={"--groupId"})
    private String groupId;
    @CommandLine.Option(names={"--artifactId"})
    private String artifactId;
    @CommandLine.Option(names={"--json"})
    private boolean displayJson;

    @Override
    public Integer call() throws Exception {
        MavenSessionManager msm = new MavenSessionManager();
        RepositorySystem system = msm.newRepositorySystem();
        VersionResolverFactory factory = new VersionResolverFactory(system, msm.newRepositorySystemSession(system));
        ChannelSession ses = new ChannelSession(List.of(ChannelMapper.from(this.channelFile.toUri().toURL())), factory);
        VersionResult version = ses.findLatestMavenArtifactVersion(this.groupId, this.artifactId, null, null, null);
        if (version == null) {
            System.err.printf("No version of artifact %s:%s found in the channel.%n", this.groupId, this.artifactId);
            return ReturnCodes.ERROR;
        }
        if (this.displayJson) {
            System.out.println(OBJECT_MAPPER.writeValueAsString(new JsonVersionResult(version)));
        } else {
            System.out.println(version.getVersion());
        }
        return ReturnCodes.SUCCESS;
    }

    class JsonVersionResult {
        private final String version;
        private final String channelName;

        JsonVersionResult(VersionResult result) {
            this.version = result.getVersion();
            this.channelName = result.getChannelName().orElse(null);
        }

        public String getVersion() {
            return this.version;
        }

        public String getChannelName() {
            return this.channelName;
        }
    }
}

