/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras;

import org.wildfly.prospero.extras.MainCommand;
import org.wildfly.prospero.extras.bundle.create.CreateBundleCommand;
import org.wildfly.prospero.extras.channel.ChannelCommands;
import org.wildfly.prospero.extras.channel.merge.ChannelMergeCommand;
import org.wildfly.prospero.extras.channel.query.QueryVersionCommand;
import org.wildfly.prospero.extras.manifest.diff.ManifestsDiffCommand;
import org.wildfly.prospero.extras.manifest.download.DownloadDiffCommand;
import org.wildfly.prospero.extras.manifest.from.ManifestFromCommand;
import org.wildfly.prospero.extras.manifest.merge.ManifestMergeCommand;
import org.wildfly.prospero.extras.manifest.subtract.ManifestSubtractCommand;
import org.wildfly.prospero.extras.repoository.RepositoryCommands;
import org.wildfly.prospero.extras.repository.create.DownloadArtifactListCommand;
import org.wildfly.prospero.extras.repository.create.DownloadRepositoryCommand;
import org.wildfly.prospero.extras.repository.create.RepositoryDownloadCommands;
import picocli.CommandLine;

public class Main {
    public static void main(String[] args) throws Exception {
        CommandLine commandLine = Main.createCommandLine();
        int exitCode = commandLine.execute(args);
        System.exit(exitCode);
    }

    private static CommandLine createCommandLine() {
        CommandLine commandLine = new CommandLine(new MainCommand());
        commandLine.addSubcommand(new CreateBundleCommand());
        commandLine.addSubcommand(new ManifestsDiffCommand());
        commandLine.addSubcommand(new DownloadDiffCommand());
        commandLine.addSubcommand(new ManifestMergeCommand());
        commandLine.addSubcommand(new ManifestSubtractCommand());
        commandLine.addSubcommand(new ManifestFromCommand());
        commandLine.addSubcommand(new DownloadRepositoryCommand());
        commandLine.addSubcommand(new DownloadArtifactListCommand());
        ChannelCommands channelSubcommand = new ChannelCommands(commandLine);
        commandLine.addSubcommand(channelSubcommand);
        channelSubcommand.addSubCommand(new QueryVersionCommand());
        channelSubcommand.addSubCommand(new ChannelMergeCommand());
        RepositoryCommands repositoryCommands = new RepositoryCommands(commandLine);
        commandLine.addSubcommand(repositoryCommands);
        RepositoryDownloadCommands repoDownloadCommands = new RepositoryDownloadCommands(repositoryCommands.getCtx());
        repositoryCommands.addSubCommand(repoDownloadCommands);
        repoDownloadCommands.addSubCommand(new DownloadArtifactListCommand());
        repoDownloadCommands.addSubCommand(new DownloadRepositoryCommand());
        commandLine.setUsageHelpAutoWidth(true);
        return commandLine;
    }
}

