/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras.repository.create;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.prospero.extras.ReturnCodes;
import org.wildfly.prospero.extras.repository.create.MavenDownloader;
import org.wildfly.prospero.extras.shared.CommandWithHelp;
import picocli.CommandLine;

@CommandLine.Command(name="from-list")
public class DownloadArtifactListCommand
extends CommandWithHelp {
    @CommandLine.Option(names={"--out"}, required=true)
    private Path repositoryPath;
    @CommandLine.Option(names={"--artifact-list"}, required=true)
    private Path artifactList;
    @CommandLine.Option(names={"--repositories"}, required=true, split=",")
    private List<String> repositoriesArg;

    @Override
    public Integer call() throws Exception {
        List<String> gavLines = Files.readAllLines(this.artifactList);
        Set<Artifact> artifacts = gavLines.stream().map(String::trim).filter(s -> !s.isEmpty()).map(l -> l.split(":")).map(a -> {
            String version;
            String classifier;
            String groupId = a[0];
            String artifactId = a[1];
            String extension = a[2];
            if (((String[])a).length == 6) {
                classifier = a[3];
                version = a[4];
            } else {
                String scope;
                classifier = null;
                version = a[3];
                if (!(((String[])a).length != 5 || (scope = a[4]).equals("compile") || scope.equals("provided") || scope.equals("runtime"))) {
                    throw new RuntimeException("Unexpected line: " + String.join((CharSequence)":", a));
                }
            }
            return new DefaultArtifact(groupId, artifactId, classifier, extension, version);
        }).collect(Collectors.toSet());
        AtomicInteger counter = new AtomicInteger(0);
        List<RemoteRepository> repositories = this.repositoriesArg.stream().map(a -> {
            String url;
            Object id;
            if (a.contains("::")) {
                id = a.split("::")[0].trim();
                url = a.split("::")[1].trim();
            } else {
                id = "repo-" + counter.getAndIncrement();
                url = a.trim();
            }
            return new RemoteRepository.Builder((String)id, "default", url).build();
        }).collect(Collectors.toList());
        new MavenDownloader(repositories).downloadAndDeploy(artifacts, this.repositoryPath, true, true);
        return ReturnCodes.SUCCESS;
    }
}

