/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras.repository.create;

import java.io.File;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.version.Version;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.version.VersionMatcher;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class MavenDownloader {
    private final RepositorySystem mvnSystem;
    private final DefaultRepositorySystemSession mvnSession;
    private final List<RemoteRepository> repositories;

    public MavenDownloader(List<RemoteRepository> repositories) throws ProvisioningException {
        this.repositories = repositories;
        MavenSessionManager msm = new MavenSessionManager(MavenOptions.DEFAULT_OPTIONS);
        this.mvnSystem = msm.newRepositorySystem();
        this.mvnSession = msm.newRepositorySystemSession(this.mvnSystem).setTransferListener(new AbstractTransferListener(){

            @Override
            public void transferStarted(TransferEvent event) throws TransferCancelledException {
                System.out.println("Downloading " + event.getResource().getResourceName());
            }
        });
    }

    public Artifact downloadManifest(ChannelManifestCoordinate coord) throws VersionRangeResolutionException, ArtifactResolutionException {
        String version;
        VersionRangeRequest req = new VersionRangeRequest();
        req.setRepositories(this.repositories);
        if (coord.getMaven().getVersion() == null) {
            req.setArtifact(new DefaultArtifact(coord.getGroupId(), coord.getArtifactId(), "manifest", "yaml", "[0,)"));
            VersionRangeResult result = this.mvnSystem.resolveVersionRange(this.mvnSession, req);
            Optional<String> latestVersion = VersionMatcher.getLatestVersion(result.getVersions().stream().map(Version::toString).collect(Collectors.toSet()));
            if (latestVersion.isEmpty()) {
                throw new RuntimeException("Could not find latest version " + coord);
            }
            version = latestVersion.get();
        } else {
            version = coord.getVersion();
        }
        ArtifactRequest artifactRequest = new ArtifactRequest();
        DefaultArtifact fpArtifact = new DefaultArtifact(coord.getGroupId(), coord.getArtifactId(), "manifest", "yaml", version);
        artifactRequest.setArtifact(fpArtifact);
        artifactRequest.setRepositories(this.repositories);
        ArtifactResult artifactResult = this.mvnSystem.resolveArtifact(this.mvnSession, artifactRequest);
        if (!artifactResult.isResolved()) {
            throw new RuntimeException("Unable to resolve artifact " + fpArtifact + " from repositories.");
        }
        return artifactResult.getArtifact();
    }

    File download(String groupId, String artifactId, String classifier, String extension, String version) throws ArtifactResolutionException {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        DefaultArtifact fpArtifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version);
        artifactRequest.setArtifact(fpArtifact);
        artifactRequest.setRepositories(this.repositories);
        ArtifactResult artifactResult = this.mvnSystem.resolveArtifact(this.mvnSession, artifactRequest);
        if (!artifactResult.isResolved()) {
            throw new RuntimeException("Unable to resolve artifact " + fpArtifact + " from repositories.");
        }
        return artifactResult.getArtifact().getFile();
    }

    void downloadAndDeploy(Set<Artifact> artifactSet, Path outputPath, boolean includeSources, boolean includePoms) throws ArtifactResolutionException, MalformedURLException, DeploymentException {
        List<Artifact> res;
        List requests = artifactSet.stream().flatMap(a -> {
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
            artifacts.add((Artifact)a);
            if (includePoms) {
                DefaultArtifact pomArtifact = new DefaultArtifact(a.getGroupId(), a.getArtifactId(), "", "pom", a.getVersion());
                artifacts.add(pomArtifact);
            }
            if (includeSources && a.getClassifier() != null && a.getExtension().equals("jar")) {
                DefaultArtifact sourcesArtifact = new DefaultArtifact(a.getGroupId(), a.getArtifactId(), "sources", a.getExtension(), a.getVersion());
                artifacts.add(sourcesArtifact);
                DefaultArtifact testSourcesArtifact = new DefaultArtifact(a.getGroupId(), a.getArtifactId(), "test-sources", a.getExtension(), a.getVersion());
                artifacts.add(testSourcesArtifact);
            }
            return artifacts.stream().map(ar -> new ArtifactRequest((Artifact)ar, this.repositories, null));
        }).collect(Collectors.toList());
        try {
            res = this.mvnSystem.resolveArtifacts(this.mvnSession, requests).stream().map(ArtifactResult::getArtifact).collect(Collectors.toList());
        }
        catch (ArtifactResolutionException e) {
            ArrayList resolved = new ArrayList();
            for (ArtifactResult result : e.getResults()) {
                if (!result.isResolved()) {
                    if ("sources".equals(result.getRequest().getArtifact().getClassifier())) {
                        System.out.println("WARNING: Unable to resolve sources jar: " + result.getRequest().getArtifact());
                        continue;
                    }
                    if ("test-sources".equals(result.getRequest().getArtifact().getClassifier())) {
                        System.out.println("WARNING: Unable to resolve sources jar: " + result.getRequest().getArtifact());
                        continue;
                    }
                    System.err.println("Unable to resolve: " + result.getRequest().getArtifact());
                    throw e;
                }
                resolved.add(result.getArtifact());
            }
            res = resolved;
        }
        DeployRequest deployRequest = new DeployRequest();
        deployRequest.setRepository(new RemoteRepository.Builder("output", "default", outputPath.toUri().toURL().toExternalForm()).build());
        res.forEach(deployRequest::addArtifact);
        this.mvnSystem.deploy(this.mvnSession, deployRequest);
    }
}

