/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.util.HashUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.logging.Logger;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.metadata.ManifestVersionRecord;

public class ArtifactCache {
    private static final Logger LOG = Logger.getLogger(ArtifactCache.class);
    static final String CACHE_LINE_SEPARATOR = "::";
    static final String CACHE_FILENAME = "artifacts.txt";
    public static final Path CACHE_FOLDER = Path.of(".installation", ".cache");
    private final Path cacheDir;
    private final Path installationDir;
    private final Map<String, Path> paths = new TreeMap<String, Path>();
    private final Map<String, String> hashes = new TreeMap<String, String>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final HashMap<Path, ArtifactCache> instances = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtifactCache getInstance(Path installationDir) throws IOException {
        HashMap<Path, ArtifactCache> hashMap = instances;
        synchronized (hashMap) {
            if (!instances.containsKey(installationDir.toAbsolutePath())) {
                instances.put(installationDir.toAbsolutePath(), new ArtifactCache(installationDir));
            }
            return instances.get(installationDir.toAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanInstancesCache() {
        HashMap<Path, ArtifactCache> hashMap = instances;
        synchronized (hashMap) {
            instances.clear();
        }
    }

    private ArtifactCache(Path installationDir) throws IOException {
        this.installationDir = installationDir;
        this.cacheDir = installationDir.resolve(CACHE_FOLDER);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<File> getArtifact(String groupId, String artifactId, String extension, String classifier, String version) {
        String key = ArtifactCache.asKey(groupId, artifactId, extension, classifier, version);
        try {
            this.lock.readLock().lock();
            if (this.paths.containsKey(key)) {
                Path path;
                block9: {
                    path = this.paths.get(key);
                    try {
                        String hash = HashUtils.hashFile(path);
                        if (hash.equals(this.hashes.get(key))) break block9;
                        LOG.debug("Hashes don't match for " + key);
                        Optional<File> optional = Optional.empty();
                        return optional;
                    }
                    catch (IOException e) {
                        LOG.debug((Object)("Unable to calculate cached artifact hash " + key), e);
                        Optional<File> optional = Optional.empty();
                        return optional;
                    }
                }
                Optional<File> optional = Optional.of(path.toFile());
                return optional;
            }
            Optional<File> optional = Optional.empty();
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(MavenArtifact artifact, Path pathToArtifact) throws IOException {
        try {
            this.lock.writeLock().lock();
            Path cacheList = this.cacheDir.resolve(CACHE_FILENAME);
            String hash = HashUtils.hashFile(artifact.getFile().toPath());
            this.init();
            this.paths.put(ArtifactCache.asKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion()), pathToArtifact);
            this.hashes.put(ArtifactCache.asKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion()), hash);
            if (Files.exists(cacheList, new LinkOption[0])) {
                Files.delete(cacheList);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(cacheList, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);){
                for (String key : this.paths.keySet()) {
                    Path relativePath = this.installationDir.relativize(this.paths.get(key));
                    String recordedPath = relativePath.toString().replace(File.separatorChar, '/');
                    String cacheLine = key + CACHE_LINE_SEPARATOR + this.hashes.get(key) + CACHE_LINE_SEPARATOR + recordedPath + "\n";
                    writer.write(cacheLine);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void cache(MavenArtifact artifact) throws IOException {
        IoUtils.copy(artifact.getFile().toPath(), this.cacheDir.resolve(artifact.getFile().getName()), false);
        this.record(artifact, this.cacheDir.resolve(artifact.getFile().getName()));
    }

    public void cache(ManifestVersionRecord manifestRecord, LocalRepositoryManager localRepositoryManager) throws IOException {
        Objects.requireNonNull(manifestRecord);
        Objects.requireNonNull(localRepositoryManager);
        for (ManifestVersionRecord.MavenManifest manifest : manifestRecord.getMavenManifests()) {
            File cachedManifest;
            MavenArtifact record = this.mapToFile(manifestRecord, localRepositoryManager, manifest.getGroupId(), manifest.getArtifactId());
            if (record == null || !record.getVersion().equals(manifest.getVersion())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Adding manifest %s to the cache", (Object)record);
            }
            if (!(cachedManifest = record.getFile()).exists()) continue;
            this.cache(record);
        }
    }

    private MavenArtifact mapToFile(ManifestVersionRecord manifestRecord, LocalRepositoryManager localRepositoryManager, String groupId, String artifactId) {
        Optional<String> version = manifestRecord.getMavenManifests().stream().filter(m -> m.getGroupId().equals(groupId) && m.getArtifactId().equals(artifactId)).map(ManifestVersionRecord.MavenManifest::getVersion).findFirst();
        return version.map(v -> localRepositoryManager.getPathForLocalArtifact(new DefaultArtifact(groupId, artifactId, "manifest", "yaml", (String)v))).map(p -> localRepositoryManager.getRepository().getBasedir().toPath().resolve((String)p).toFile()).map(f -> new MavenArtifact(groupId, artifactId, "yaml", "manifest", (String)version.get(), (File)f)).orElse(null);
    }

    private void init() throws IOException {
        Path artifactLog = this.cacheDir.resolve(CACHE_FILENAME);
        if (Files.exists(artifactLog, new LinkOption[0])) {
            int row;
            List<String> lines = Files.readAllLines(artifactLog);
            try {
                for (row = 0; row < lines.size(); ++row) {
                    String[] splitLine = lines.get(row).split(CACHE_LINE_SEPARATOR);
                    if (splitLine.length < 3) {
                        throw new IOException("Not enough segments, expected format is <GAV>::<hash>::<path>");
                    }
                    String gav = splitLine[0];
                    String hash = splitLine[1];
                    Path path = Paths.get(splitLine[2], new String[0]);
                    org.jboss.galleon.universe.maven.MavenArtifact mavenArtifact = org.jboss.galleon.universe.maven.MavenArtifact.fromString(gav);
                    String key = ArtifactCache.asKey(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getExtension(), mavenArtifact.getClassifier(), mavenArtifact.getVersion());
                    this.paths.put(key, this.installationDir.resolve(path));
                    this.hashes.put(key, hash);
                }
            }
            catch (IOException | MavenUniverseException e) {
                throw ProsperoLogger.ROOT_LOGGER.unableToReadArtifactCache(row + 1, lines.get(row), e);
            }
        }
    }

    private static String asKey(String groupId, String artifactId, String extension, String classifier, String version) {
        StringBuilder buf = new StringBuilder();
        buf.append(groupId).append(':').append(artifactId);
        if (version == null) {
            return buf.toString();
        }
        if (extension != null) {
            buf.append(':').append(extension);
        }
        if (classifier != null && !classifier.isEmpty()) {
            buf.append(':').append(classifier);
        }
        return buf.append(':').append(version).toString();
    }
}

