/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.DiscriminatorContext;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonType;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.utils.SetView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AllOfValidator.class);
    private final List<JsonSchema> schemas;

    public AllOfValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ALL_OF, validationContext);
        if (!schemaNode.isArray()) {
            JsonType nodeType = TypeFactory.getValueNodeType(schemaNode, this.validationContext.getConfig());
            throw new JsonSchemaException(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(schemaNode)).instanceLocation(schemaLocation.getFragment())).messageKey("type")).arguments(nodeType.toString(), "array")).build());
        }
        int size = schemaNode.size();
        this.schemas = new ArrayList<JsonSchema>(size);
        for (int i = 0; i < size; ++i) {
            this.schemas.add(validationContext.newSchema(schemaLocation.append(i), evaluationPath.append(i), schemaNode.get(i), parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        return this.validate(executionContext, node, rootNode, instanceLocation, false);
    }

    protected Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean walk) {
        AllOfValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        Set<ValidationMessage> childSchemaErrors = null;
        for (JsonSchema schema : this.schemas) {
            Set<ValidationMessage> localErrors = null;
            localErrors = !walk ? schema.validate(executionContext, node, rootNode, instanceLocation) : schema.walk(executionContext, node, rootNode, instanceLocation, true);
            if (localErrors != null && !localErrors.isEmpty()) {
                if (childSchemaErrors == null) {
                    childSchemaErrors = new SetView<ValidationMessage>();
                }
                ((SetView)childSchemaErrors).union(localErrors);
            }
            if (!this.validationContext.getConfig().isDiscriminatorKeywordEnabled()) continue;
            Iterator<JsonNode> arrayElements = this.schemaNode.elements();
            while (arrayElements.hasNext()) {
                ObjectNode discriminator;
                DiscriminatorContext currentDiscriminatorContext;
                ObjectNode allOfEntry = (ObjectNode)arrayElements.next();
                JsonNode $ref = allOfEntry.get("$ref");
                if (null == $ref || null == (currentDiscriminatorContext = executionContext.getCurrentDiscriminatorContext()) || null == (discriminator = currentDiscriminatorContext.getDiscriminatorForPath(allOfEntry.get("$ref").asText()))) continue;
                AllOfValidator.registerAndMergeDiscriminator(currentDiscriminatorContext, discriminator, this.parentSchema, instanceLocation);
                String discriminatorPropertyName = discriminator.get("propertyName").asText();
                JsonNode discriminatorNode = node.get(discriminatorPropertyName);
                String discriminatorPropertyValue = discriminatorNode == null ? null : discriminatorNode.textValue();
                JsonSchema jsonSchema = this.parentSchema;
                AllOfValidator.checkDiscriminatorMatch(currentDiscriminatorContext, discriminator, discriminatorPropertyValue, jsonSchema);
            }
        }
        return childSchemaErrors != null ? childSchemaErrors : Collections.emptySet();
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(executionContext, node, rootNode, instanceLocation, true);
        }
        for (JsonSchema schema : this.schemas) {
            schema.walk(executionContext, node, rootNode, instanceLocation, false);
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas);
    }
}

