/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras.manifest.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.jboss.logging.Logger;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.Stream;
import org.wildfly.installationmanager.ArtifactChange;
import org.wildfly.prospero.extras.ReturnCodes;
import org.wildfly.prospero.extras.bundle.create.CreateBundleCommand;
import org.wildfly.prospero.extras.converters.ManifestConverter;
import picocli.CommandLine;

@CommandLine.Command(name="manifest-diff")
public class ManifestsDiffCommand
implements Callable<Integer> {
    private static final Logger LOG = Logger.getLogger(CreateBundleCommand.class);
    @CommandLine.Parameters(index="0", converter={ManifestConverter.class})
    private ChannelManifest manifestOne;
    @CommandLine.Parameters(index="1", converter={ManifestConverter.class})
    private ChannelManifest manifestTwo;

    @Override
    public Integer call() throws Exception {
        List<ArtifactChange> changes = ManifestsDiffCommand.manifestDiff(this.manifestOne, this.manifestTwo);
        System.out.println();
        changes.forEach(c -> {
            switch (c.getStatus()) {
                case REMOVED: {
                    System.out.printf("%s%n", c.getArtifactName());
                    System.out.printf(" - %s:%n", c.getOldVersion());
                    break;
                }
                case INSTALLED: {
                    System.out.printf("%s%n", c.getArtifactName());
                    System.out.printf(" + %s%n", c.getNewVersion());
                    break;
                }
                case UPDATED: {
                    System.out.printf("%s:%n", c.getArtifactName());
                    System.out.printf(" - %s%n", c.getOldVersion());
                    System.out.printf(" + %s%n", c.getNewVersion());
                }
            }
        });
        return ReturnCodes.SUCCESS;
    }

    public static List<ArtifactChange> manifestDiff(ChannelManifest manifestOne, ChannelManifest manifestTwo) {
        Objects.requireNonNull(manifestOne);
        Objects.requireNonNull(manifestTwo);
        Map<String, String> versionMapOne = ManifestsDiffCommand.streamToMap(manifestOne);
        Map<String, String> versionMapTwo = ManifestsDiffCommand.streamToMap(manifestTwo);
        for (String key : versionMapTwo.keySet()) {
            if (versionMapOne.containsKey(key)) continue;
            versionMapOne.put(key, null);
        }
        ArrayList<ArtifactChange> changes = new ArrayList<ArtifactChange>();
        for (String key : versionMapOne.keySet()) {
            String versionOne = versionMapOne.get(key);
            String versionTwo = versionMapTwo.get(key);
            if (!versionMapTwo.containsKey(key)) {
                changes.add(new ArtifactChange(versionOne, null, key, ArtifactChange.Status.REMOVED));
                continue;
            }
            if (versionMapOne.get(key) == null) {
                changes.add(new ArtifactChange(null, versionTwo, key, ArtifactChange.Status.INSTALLED));
                continue;
            }
            if (versionTwo.equals(versionOne)) continue;
            changes.add(new ArtifactChange(versionOne, versionTwo, key, ArtifactChange.Status.UPDATED));
        }
        return changes;
    }

    private static Map<String, String> streamToMap(ChannelManifest manifestOne) {
        Collection<Stream> streamsOne = manifestOne.getStreams();
        TreeMap<String, String> versionMapOne = new TreeMap<String, String>();
        for (Stream stream : streamsOne) {
            String spec = String.format("%s:%s", stream.getGroupId(), stream.getArtifactId());
            versionMapOne.put(spec, stream.getVersion() == null ? stream.getVersionPattern().toString() : stream.getVersion());
        }
        return versionMapOne;
    }
}

