/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras.manifest.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelManifestMapper;
import org.wildfly.installationmanager.ArtifactChange;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.extras.converters.ManifestConverter;
import org.wildfly.prospero.extras.converters.RepositoriesConverter;
import org.wildfly.prospero.extras.manifest.diff.ManifestsDiffCommand;
import org.wildfly.prospero.wfchannel.MavenSessionManager;
import picocli.CommandLine;

@CommandLine.Command(name="download-diff")
public class DownloadDiffCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--base"}, converter={ManifestConverter.class}, required=true)
    private ChannelManifest baseManifest;
    @CommandLine.Option(names={"--update"}, converter={ManifestConverter.class}, required=true)
    private ChannelManifest updatedManifest;
    @CommandLine.Option(names={"--update-gav"}, required=false)
    private String updatedManifestGav;
    @CommandLine.Option(names={"--repositories"}, converter={RepositoriesConverter.class})
    private List<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
    @CommandLine.Option(names={"--out"})
    private Path outputPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Integer call() throws Exception {
        List<ArtifactChange> artifactChanges = ManifestsDiffCommand.manifestDiff(this.baseManifest, this.updatedManifest);
        ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();
        for (ArtifactChange c : artifactChanges) {
            if (c.getStatus() == ArtifactChange.Status.REMOVED) continue;
            String groupId = c.getArtifactName().split(":")[0];
            String artifactId = c.getArtifactName().split(":")[1];
            String version = c.getNewVersion();
            if (artifactId.equals("hal-console") || artifactId.equals("wildfly-ee-galleon-pack")) continue;
            String extension = "jar";
            String classifier = null;
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version, null);
            ArtifactRequest artifactRequest = new ArtifactRequest(artifact, this.repositories, null);
            requests.add(artifactRequest);
        }
        System.out.println("Downloading artifacts");
        MavenSessionManager mavenSessionManager = new MavenSessionManager(MavenOptions.DEFAULT_OPTIONS);
        RepositorySystem system = mavenSessionManager.newRepositorySystem();
        DefaultRepositorySystemSession session = mavenSessionManager.newRepositorySystemSession(system);
        Path tempFile = null;
        try {
            List<ArtifactResult> artifactResults = system.resolveArtifacts(session, requests);
            System.out.println("Downloaded + " + artifactResults.size() + " + artifacts");
            System.out.println();
            System.out.println("Creating local repository " + this.outputPath);
            DeployRequest req = new DeployRequest();
            artifactResults.stream().map(ArtifactResult::getArtifact).forEach(req::addArtifact);
            if (this.updatedManifestGav != null) {
                String[] splitGav = this.updatedManifestGav.split(":");
                String groupId = splitGav[0];
                String artifactId = splitGav[1];
                String version = splitGav[2];
                tempFile = Files.createTempFile("manifest", "yaml", new FileAttribute[0]);
                Files.writeString(tempFile, (CharSequence)ChannelManifestMapper.toYaml(this.updatedManifest), new OpenOption[0]);
                req.addArtifact(new DefaultArtifact(groupId, artifactId, "manifest", "yaml", version, null, tempFile.toFile()));
            }
            Path tempDirectory = Files.createTempDirectory("prospero-repo", new FileAttribute[0]);
            try {
                req.setRepository(new RemoteRepository.Builder("out", "default", tempDirectory.toUri().toURL().toExternalForm()).build());
                system.deploy(session, req);
                DownloadDiffCommand.createArchive(tempDirectory, this.outputPath);
            }
            finally {
                FileUtils.deleteQuietly(tempDirectory.toFile());
            }
            System.out.println();
            System.out.println("Done");
            if (tempFile == null) return 0;
        }
        catch (ArtifactResolutionException e) {
            System.out.println("Unable to find following artifacts:");
            e.getResults().stream().filter(r -> !r.isResolved()).map(ArtifactResult::getRequest).forEach(r -> System.out.println(" * " + r.getArtifact()));
            Integer n = -1;
            return n;
        }
        finally {
            if (tempFile != null) {
                Files.delete(tempFile);
            }
        }
        Files.delete(tempFile);
        return 0;
    }

    public static Path createArchive(final Path artifacts, Path archive) throws IOException {
        Objects.requireNonNull(artifacts);
        Objects.requireNonNull(archive);
        try (final ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(archive.toFile()));){
            Files.walkFileTree(artifacts, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String entry = artifacts.relativize(dir).toString().replace(File.separatorChar, '/');
                    zos.putNextEntry(new ZipEntry(entry + "/"));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String entry = artifacts.relativize(file).toString().replace(File.separatorChar, '/');
                    zos.putNextEntry(new ZipEntry(entry));
                    try (FileInputStream fis = new FileInputStream(file.toFile());){
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return null;
    }
}

