/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras.manifest.merge;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelManifestMapper;
import org.wildfly.channel.Stream;
import org.wildfly.prospero.extras.ReturnCodes;
import org.wildfly.prospero.extras.manifest.ManifestUtils;
import org.wildfly.prospero.extras.manifest.merge.VersionMergeStrategy;
import picocli.CommandLine;

@CommandLine.Command(name="manifest-merge")
public class ManifestMergeCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0")
    Path manifestOne;
    @CommandLine.Parameters(index="1")
    Path manifestTwo;
    @CommandLine.Option(names={"--mode"}, defaultValue="LATEST")
    VersionMergeStrategy.Strategies mergeStrategy;
    @CommandLine.Option(names={"--name"}, defaultValue="merged-manifest")
    String mergedManifestName;
    @CommandLine.Option(names={"--id"})
    String mergedManifestId;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true)
    boolean help;

    @Override
    public Integer call() throws Exception {
        ChannelManifest manifestOne = ChannelManifestMapper.from(this.manifestOne.toUri().toURL());
        ChannelManifest manifestTwo = ChannelManifestMapper.from(this.manifestTwo.toUri().toURL());
        ChannelManifest mergedManifest = ManifestMergeCommand.merge(manifestOne, manifestTwo, this.mergeStrategy, this.mergedManifestName, this.mergedManifestId);
        System.out.println(ChannelManifestMapper.toYaml(mergedManifest));
        return ReturnCodes.SUCCESS;
    }

    public static ChannelManifest merge(ChannelManifest manifestOne, ChannelManifest manifestTwo, VersionMergeStrategy mergeStrategy, String mergedManifestName, String mergedManifestId) {
        Objects.requireNonNull(manifestOne);
        Objects.requireNonNull(manifestTwo);
        Objects.requireNonNull(mergeStrategy);
        Collection<Stream> streamsOne = manifestOne.getStreams();
        Collection<Stream> streamsTwo = manifestTwo.getStreams();
        Map<String, Stream> presentKeys = streamsOne.stream().collect(Collectors.toMap(s -> s.getGroupId() + ":" + s.getArtifactId(), s -> s));
        TreeSet<Stream> merged = new TreeSet<Stream>(streamsOne);
        for (Stream s2 : streamsTwo) {
            String key = s2.getGroupId() + ":" + s2.getArtifactId();
            String versionTwo = s2.getVersion();
            String versionOne = !presentKeys.containsKey(key) ? null : presentKeys.get(key).getVersion();
            String version = mergeStrategy.merge(versionOne, versionTwo);
            Stream streamOne = presentKeys.get(key);
            if (version == null) {
                if (streamOne == null) continue;
                merged.remove(streamOne);
                continue;
            }
            if (version.equals(versionOne)) continue;
            if (streamOne != null) {
                merged.remove(presentKeys.get(key));
            }
            merged.add(s2);
        }
        Optional<String> schemaVersion = ManifestUtils.getLatestSchemaVersion(manifestOne, manifestTwo);
        ChannelManifest.Builder builder = new ChannelManifest.Builder().setSchemaVersion(schemaVersion.orElse("1.1.0")).setName(mergedManifestName).addStreams(merged.toArray(new Stream[0])).setId(mergedManifestId);
        return builder.build();
    }
}

