/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras.repository.create;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.logging.Logger;
import org.wildfly.channel.Stream;
import org.wildfly.prospero.extras.repository.create.DownloadRepositoryCommand;
import org.wildfly.prospero.extras.repository.create.FeaturePackUtils;

class ChannelFeaturePackResolver {
    private static final Logger LOG = Logger.getLogger(DownloadRepositoryCommand.class);
    private static AtomicInteger counter = new AtomicInteger(0);
    protected static final int DETECTION_PARALLERLISM = Integer.getInteger("wildfly.prospero.fp.detect_threads", 20);

    ChannelFeaturePackResolver() {
    }

    List<String> findFeaturePacks(Collection<Stream> streams, List<RemoteRepository> repositories) throws IOException {
        HashSet<String> featurePacks = new HashSet<String>();
        ExecutorService executorService = null;
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            executorService = Executors.newWorkStealingPool(DETECTION_PARALLERLISM);
            ArrayList<CompletableFuture<String>> allTasks = new ArrayList<CompletableFuture<String>>();
            for (Stream stream : streams) {
                CompletableFuture<String> cf = new CompletableFuture<String>();
                executorService.submit(new UrlCheck(repositories, client, stream, cf));
                allTasks.add(cf);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Waiting to finish " + allTasks.size() + " tasks");
            }
            CompletableFuture.allOf(allTasks.toArray(new CompletableFuture[0])).join();
            for (CompletableFuture completableFuture : allTasks) {
                String value = (String)completableFuture.get();
                if (value == null) continue;
                featurePacks.add(value);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("All tasks complete");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (executorService != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Shutting down the executor");
                }
                System.out.println("Shutting down the executor");
                executorService.shutdownNow();
            }
        }
        return new ArrayList<String>(featurePacks);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getExistingZipUrl(CloseableHttpClient client, String baseUrl, Stream s) {
        String url = baseUrl + "/" + s.getGroupId().replaceAll("\\.", "/") + "/" + s.getArtifactId() + "/" + s.getVersion() + "/" + s.getArtifactId() + "-" + s.getVersion() + ".zip";
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking " + s + " for feature packs. Trying " + url);
        }
        HttpHead httpHead = new HttpHead(url);
        try (CloseableHttpResponse res = client.execute(httpHead);){
            if (res.getStatusLine().getStatusCode() != 200) return null;
            String string = url;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private Path downloadZip(String zipUrl) throws IOException {
        Path tempFile = Files.createTempFile("candidate", "zip", new FileAttribute[0]);
        try (CloseableHttpClient client = HttpClients.custom().setRedirectStrategy(new LaxRedirectStrategy()).build();){
            HttpGet get = new HttpGet(zipUrl);
            client.execute((HttpUriRequest)get, httpResponse -> {
                FileUtils.copyInputStreamToFile(httpResponse.getEntity().getContent(), tempFile.toFile());
                return tempFile.toFile();
            });
        }
        return tempFile;
    }

    private class UrlCheck
    implements Runnable {
        private final List<RemoteRepository> repositories;
        private final CloseableHttpClient client;
        private final Stream stream;
        private final CompletableFuture<String> cf;

        UrlCheck(List<RemoteRepository> repositories, CloseableHttpClient client, Stream stream, CompletableFuture<String> cf) {
            this.repositories = repositories;
            this.client = client;
            this.stream = stream;
            this.cf = cf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String zipUrl = null;
            String fpGa = null;
            for (RemoteRepository repo : this.repositories) {
                String baseUrl;
                if (!repo.getUrl().startsWith("file") && (zipUrl = ChannelFeaturePackResolver.this.getExistingZipUrl(this.client, baseUrl = repo.getUrl(), this.stream)) != null) break;
            }
            if (zipUrl != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found possible zip: " + zipUrl + ". Downloading to verify.");
                }
                Path tempFile = null;
                try {
                    tempFile = ChannelFeaturePackResolver.this.downloadZip(zipUrl);
                    if (FeaturePackUtils.isFeaturePack(tempFile)) {
                        LOG.debug("Found feature pack " + this.stream);
                        fpGa = this.stream.getGroupId() + ":" + this.stream.getArtifactId();
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("Unable to process a zip file: " + zipUrl + " Ignoring the file"), e);
                    this.cf.completeExceptionally(e);
                }
                finally {
                    if (tempFile != null) {
                        try {
                            Files.delete(tempFile);
                        }
                        catch (IOException e) {
                            LOG.error((Object)("Unable to remove temporary download: " + tempFile), e);
                        }
                    }
                }
            }
            this.cf.complete(fpGa);
        }
    }
}

