/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras.repository.create;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.Stream;

class FeaturePackUtils {
    FeaturePackUtils() {
    }

    static boolean isFeaturePack(Path file) throws IOException {
        try (ZipFile archive = new ZipFile(file.toFile());){
            Enumeration<? extends ZipEntry> entries = archive.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().equals("feature-pack.xml")) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static HashSet<Artifact> getArtifactsFromFeaturePackZip(File zipFile, ChannelManifest manifest) throws IOException {
        HashSet<Artifact> res = new HashSet<Artifact>();
        try (ZipFile archive = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> entries = archive.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().equals("resources/wildfly/artifact-versions.properties")) continue;
                InputStream stream = archive.getInputStream(entry);
                try {
                    List<String> artifacts = IOUtils.readLines(stream, StandardCharsets.UTF_8);
                    for (String artifact : artifacts) {
                        String gav = artifact.split("=")[1];
                        DefaultArtifact mavenArtifact = FeaturePackUtils.fromModulesGav(gav);
                        if (mavenArtifact == null) {
                            System.out.println("Ignoring artifact definition" + gav);
                            continue;
                        }
                        Optional<Stream> version = manifest.findStreamFor(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId());
                        if (!version.isPresent()) continue;
                        res.add(mavenArtifact.setVersion(version.get().getVersion()));
                    }
                    return res;
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                    return res;
                }
            }
        }
    }

    static DefaultArtifact fromModulesGav(String coordStr) {
        if ((coordStr = FeaturePackUtils.evaluatePropertiesToDefaults(coordStr)) == null) {
            return null;
        }
        String extension = "jar";
        String[] parts = coordStr.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Unexpected artifact coordinates format: " + coordStr);
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = null;
        String classifier = null;
        if (parts.length > 2) {
            if (!parts[2].isEmpty()) {
                version = parts[2];
            }
            if (parts.length > 3) {
                if (!parts[3].isEmpty()) {
                    classifier = parts[3];
                }
                if (parts.length > 4) {
                    if (!parts[4].isEmpty()) {
                        extension = parts[4];
                    }
                    if (parts.length > 5) {
                        throw new IllegalArgumentException("Unexpected artifact coordinates format: " + coordStr);
                    }
                }
            }
        }
        return new DefaultArtifact(groupId, artifactId, classifier, extension, version);
    }

    private static String evaluatePropertiesToDefaults(String gav) {
        Pattern PATTERN = Pattern.compile("\\$\\{.*?\\}");
        Matcher matcher = PATTERN.matcher(gav);
        while (matcher.find()) {
            String group = matcher.group(0);
            String content = group.substring(2, group.length() - 1);
            int separatorIndex = content.indexOf(58);
            if (separatorIndex < 0) {
                return null;
            }
            gav = gav.replace(group, content.substring(separatorIndex + 1));
        }
        return gav;
    }
}

