/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.util.HashUtils;
import org.jboss.logging.Logger;
import org.wildfly.channel.Channel;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ArtifactCache;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class GalleonFeaturePackAnalyzer {
    private static final Logger LOG = Logger.getLogger(GalleonFeaturePackAnalyzer.class.getName());
    private final List<Channel> channels;
    private final MavenSessionManager mavenSessionManager;

    public GalleonFeaturePackAnalyzer(List<Channel> channels, MavenSessionManager mavenSessionManager) {
        this.channels = channels;
        this.mavenSessionManager = mavenSessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheGalleonArtifacts(Path installedDir, GalleonProvisioningConfig provisioningConfig) throws Exception {
        Path tempInstallationPath = Files.createTempDirectory("temp", new FileAttribute[0]);
        HashSet<String> fps = new HashSet<String>();
        try (GalleonEnvironment galleonEnv = this.galleonEnvWithFpMapper(tempInstallationPath, installedDir, fps, provisioningConfig);){
            ArtifactCache artifactCache = ArtifactCache.getInstance(installedDir);
            try (Provisioning pm = galleonEnv.getProvisioning();){
                Set<String> pluginGavs = pm.getOrderedFeaturePackPluginLocations(provisioningConfig);
                for (String pluginGav : pluginGavs) {
                    String[] pluginLoc = pluginGav.split(":");
                    MavenArtifact jar = galleonEnv.getChannelSession().resolveMavenArtifact(pluginLoc[0], pluginLoc[1], "jar", null, null);
                    artifactCache.cache(jar);
                }
            }
            for (String fp : this.getFeaturePacks(installedDir, provisioningConfig)) {
                String[] fpLoc = fp.split(":");
                MavenArtifact mavenArtifact = galleonEnv.getChannelSession().resolveMavenArtifact(fpLoc[0], fpLoc[1], "zip", null, null);
                artifactCache.cache(mavenArtifact);
            }
            try {
                MavenArtifact mavenArtifact = galleonEnv.getChannelSession().resolveMavenArtifact("org.wildfly.galleon-plugins", "wildfly-config-gen", "jar", null, null);
                artifactCache.cache(mavenArtifact);
            }
            catch (UnresolvedMavenArtifactException e) {
                LOG.isDebugEnabled();
                LOG.debug((Object)"Unable to find wildfly-config-get artifact", e);
            }
            this.updateHashes(installedDir);
        }
        finally {
            FileUtils.deleteQuietly(tempInstallationPath.toFile());
        }
    }

    private void updateHashes(Path installedDir) throws IOException {
        Path hashesFile = installedDir.resolve(".galleon").resolve("hashes").resolve(ArtifactCache.CACHE_FOLDER).resolve("hashes");
        Path cachesDir = installedDir.resolve(ArtifactCache.CACHE_FOLDER);
        StringBuilder sb = new StringBuilder();
        for (File file : cachesDir.toFile().listFiles()) {
            sb.append(file.getName()).append(System.lineSeparator());
            sb.append(HashUtils.bytesToHexString(HashUtils.hashPath(file.toPath()))).append(System.lineSeparator());
        }
        Files.writeString(hashesFile, (CharSequence)sb.toString(), new OpenOption[0]);
    }

    public Set<String> getFeaturePacks(Path installedDir, GalleonProvisioningConfig provisioningConfig) throws IOException, ProvisioningException, OperationException {
        Path tempInstallationPath = Files.createTempDirectory("temp", new FileAttribute[0]);
        HashSet<String> fps = new HashSet<String>();
        try {
            GalleonEnvironment galleonEnv = this.galleonEnvWithFpMapper(tempInstallationPath, installedDir, fps, provisioningConfig);
            try {
                galleonEnv.getProvisioning().getProvisioningRuntime(provisioningConfig).close();
                HashSet<String> hashSet = fps;
                if (galleonEnv != null) {
                    galleonEnv.close();
                }
                return hashSet;
            }
            catch (Throwable throwable) {
                if (galleonEnv != null) {
                    try {
                        galleonEnv.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            FileUtils.deleteQuietly(tempInstallationPath.toFile());
        }
    }

    private GalleonEnvironment galleonEnvWithFpMapper(Path tempInstallationPath, Path sourcePath, Set<String> fps, GalleonProvisioningConfig provisioningConfig) throws ProvisioningException, OperationException {
        GalleonEnvironment galleonEnv = GalleonEnvironment.builder(tempInstallationPath, this.channels, this.mavenSessionManager, false).setConsole(null).setSourceServerPath(sourcePath).setProvisioningConfig(provisioningConfig).setResolvedFpTracker(fps::add).build();
        return galleonEnv;
    }
}

