/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras.repository.create;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.logging.Logger;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.Stream;
import org.wildfly.prospero.extras.ChannelOperations;
import org.wildfly.prospero.extras.ReturnCodes;
import org.wildfly.prospero.extras.repository.create.ChannelFeaturePackResolver;
import org.wildfly.prospero.extras.repository.create.CoordUtils;
import org.wildfly.prospero.extras.repository.create.FeaturePackUtils;
import org.wildfly.prospero.extras.repository.create.MavenDownloader;
import org.wildfly.prospero.extras.shared.CommandWithHelp;
import picocli.CommandLine;

@CommandLine.Command(name="from-channel")
public class DownloadRepositoryCommand
extends CommandWithHelp {
    private static final Logger LOG = Logger.getLogger(DownloadRepositoryCommand.class);
    @CommandLine.Option(names={"--out"}, required=true)
    private Path repositoryPath;
    @CommandLine.Option(names={"--channel"}, required=true)
    private Path channelFile;
    @CommandLine.Option(names={"--feature-packs"}, split=",")
    private final List<String> featurePacks = new ArrayList<String>();
    @CommandLine.Option(names={"--fp-mapper"})
    private FpMapperValues fpMapper = FpMapperValues.ZIP;
    @CommandLine.Option(names={"--include-sources"})
    private boolean includeSources = false;
    @CommandLine.Option(names={"--include-poms"})
    private boolean includePoms = false;
    @CommandLine.Option(names={"--artifact-list"})
    private boolean artifactList = false;
    private final ChannelFeaturePackResolver channelFeaturePackResolver = new ChannelFeaturePackResolver();
    private Set<Artifact> artifactSet;

    @Override
    public Integer call() throws Exception {
        Channel channel = ChannelMapper.from((URL)this.channelFile.toUri().toURL());
        List<RemoteRepository> repositories = channel.getRepositories().stream().map(r -> new RemoteRepository.Builder(r.getId(), "default", r.getUrl()).build()).collect(Collectors.toList());
        MavenDownloader downloader = new MavenDownloader(repositories);
        this.artifactSet = new HashSet<Artifact>();
        ChannelOperations.ChannelManifestDownload manifestDownload = ChannelOperations.getChannelManifest(channel, downloader);
        if (channel.getManifestCoordinate().getUrl() == null) {
            this.artifactSet.add(manifestDownload.manifestArtifact);
        }
        ChannelManifest manifest = manifestDownload.manifest;
        if (this.featurePacks.isEmpty()) {
            System.out.println("Detecting feature packs");
            this.featurePacks.addAll(this.channelFeaturePackResolver.findFeaturePacks(manifest.getStreams(), repositories));
            if (this.featurePacks.isEmpty()) {
                throw new RuntimeException("Unable to find any feature packs in the channel.");
            }
        } else {
            System.out.println("Using defined feature packs");
        }
        System.out.println("Resolving dependencies for:");
        for (String fp : this.featurePacks) {
            System.out.println("  * " + fp);
        }
        this.artifactSet.addAll(this.detectArtifactsInFeaturePacks(manifest, downloader));
        System.out.println("Downloading");
        downloader.downloadAndDeploy(this.artifactSet, this.repositoryPath, this.includeSources, this.includePoms);
        Set downloaded = this.artifactSet.stream().map(a -> a.getGroupId() + ":" + a.getArtifactId()).collect(Collectors.toSet());
        Set<String> requested = manifest.getStreams().stream().map(s -> s.getGroupId() + ":" + s.getArtifactId()).collect(Collectors.toSet());
        requested.removeAll(downloaded);
        if (!requested.isEmpty()) {
            System.out.println("WARNING: Following streams defined in the manifest were not resolved:");
            requested.forEach(ga -> System.out.println("  * " + ga));
        }
        if (this.includePoms) {
            final Stack<Path> poms = new Stack<Path>();
            HashSet<Artifact> pomArtifacts = new HashSet<Artifact>();
            Files.walkFileTree(this.repositoryPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.getFileName().toString().endsWith(".pom")) {
                        return FileVisitResult.CONTINUE;
                    }
                    poms.push(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
            while (!poms.isEmpty()) {
                Path file = (Path)poms.pop();
                try {
                    Model model = new MavenXpp3Reader().read((InputStream)new FileInputStream(file.toFile()));
                    Parent parentModel = model.getParent();
                    if (parentModel == null) continue;
                    String groupId = parentModel.getGroupId();
                    String artifactId = parentModel.getArtifactId();
                    String version = parentModel.getVersion();
                    System.out.printf("Resolving pom: %s:%s:%s%n", groupId, artifactId, version);
                    Path parent = downloader.download(groupId, artifactId, null, "pom", version).toPath();
                    poms.push(parent);
                    pomArtifacts.add((Artifact)new DefaultArtifact(groupId, artifactId, null, "pom", version, null, parent.toFile()));
                }
                catch (XmlPullParserException e) {
                    throw new RuntimeException(e);
                }
            }
            downloader.downloadAndDeploy(pomArtifacts, this.repositoryPath, false, false);
            if (this.artifactList) {
                TreeSet gavs = new TreeSet();
                this.artifactSet.stream().forEach(a -> gavs.add(String.format("%s:%s:%s:%s:%s", a.getGroupId(), a.getArtifactId(), a.getExtension(), a.getVersion(), "compile")));
                pomArtifacts.stream().forEach(a -> gavs.add(String.format("%s:%s:%s:%s:%s", a.getGroupId(), a.getArtifactId(), a.getExtension(), a.getVersion(), "compile")));
                try (PrintWriter pw = new PrintWriter(new FileWriter("artifact-list"));){
                    gavs.forEach(pw::println);
                }
            }
        }
        return ReturnCodes.SUCCESS;
    }

    private Set<Artifact> detectArtifactsInFeaturePacks(ChannelManifest manifest, MavenDownloader downloader) throws ProvisioningException, ArtifactResolutionException, IOException {
        HashSet<Artifact> artifactSet = new HashSet<Artifact>();
        for (String featurePackGA : this.featurePacks) {
            Optional fpStream = manifest.findStreamFor(featurePackGA.split(":")[0], featurePackGA.split(":")[1]);
            if (fpStream.isEmpty()) {
                throw new RuntimeException("The feature pack " + featurePackGA + " cannot be found in the channel.");
            }
            if (this.fpMapper == FpMapperValues.ZIP) {
                File zipFile = downloader.download(featurePackGA.split(":")[0], featurePackGA.split(":")[1], null, "zip", ((Stream)fpStream.get()).getVersion());
                artifactSet.addAll(FeaturePackUtils.getArtifactsFromFeaturePackZip(zipFile, manifest));
                artifactSet.add((Artifact)DownloadRepositoryCommand.zipMavenArtifact(featurePackGA, fpStream));
                continue;
            }
            File artifactListFile = downloader.download(featurePackGA.split(":")[0], featurePackGA.split(":")[1], "artifact-list", "txt", ((Stream)fpStream.get()).getVersion());
            FileUtils.readLines((File)artifactListFile, (Charset)StandardCharsets.UTF_8).stream().map(l -> l.split(",")[1]).map(CoordUtils::fromLocalPath).map(a -> manifest.findStreamFor(a.getGroupId(), a.getArtifactId()).map(s -> a.setVersion(s.getVersion()))).filter(Optional::isPresent).map(Optional::get).forEach(artifactSet::add);
            artifactSet.add((Artifact)DownloadRepositoryCommand.zipMavenArtifact(featurePackGA, fpStream));
        }
        return artifactSet;
    }

    private static DefaultArtifact zipMavenArtifact(String featurePackGA, Optional<Stream> fpStream) {
        return new DefaultArtifact(featurePackGA.split(":")[0], featurePackGA.split(":")[1], null, "zip", fpStream.get().getVersion());
    }

    static enum FpMapperValues {
        ZIP,
        OFFLINER;

    }
}

