/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.kitchensink_ear.controller;

import javax.annotation.PostConstruct;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Produces;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.as.quickstarts.kitchensink_ear.model.Member;
import org.jboss.as.quickstarts.kitchensink_ear.service.MemberRegistration;

@Model
public class MemberController {
    @Inject
    private FacesContext facesContext;
    @Inject
    private MemberRegistration memberRegistration;
    private Member newMember;

    @Produces
    @Named
    public Member getNewMember() {
        return this.newMember;
    }

    public void register() throws Exception {
        try {
            this.memberRegistration.register(this.newMember);
            this.facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Registered!", "Registration successful"));
            this.initNewMember();
        }
        catch (Exception e) {
            String errorMessage = this.getRootErrorMessage(e);
            FacesMessage m = new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, "Registration Unsuccessful");
            this.facesContext.addMessage(null, m);
        }
    }

    @PostConstruct
    public void initNewMember() {
        this.newMember = new Member();
    }

    private String getRootErrorMessage(Exception e) {
        String errorMessage = "Registration failed. See server log for more information";
        if (e == null) {
            return errorMessage;
        }
        for (Throwable t = e; t != null; t = t.getCause()) {
            errorMessage = t.getLocalizedMessage();
        }
        return errorMessage;
    }
}

