/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.threadracing;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.quickstarts.threadracing.Race;
import org.jboss.as.quickstarts.threadracing.RaceBroadcaster;
import org.jboss.as.quickstarts.threadracing.Racer;
import org.jboss.as.quickstarts.threadracing.results.ChampionshipStandings;
import org.jboss.as.quickstarts.threadracing.results.RaceResult;
import org.jboss.as.quickstarts.threadracing.results.RaceResults;

public class Race {
    private CyclicBarrier startBarrier;
    private CountDownLatch endCountDownLatch;
    private AtomicInteger donePosition;
    private AtomicInteger abortedPosition;
    private RaceResult result;
    private final Map<String, String> environment;
    private final RaceBroadcaster broadcaster;
    private final RaceResults results;
    private final Racer racer1;
    private final Racer racer2;
    private final Racer racer3;
    private final Racer racer4;

    public Race(Racer racer1, Racer racer2, Racer racer3, Racer racer4, Map<String, String> environment, RaceBroadcaster broadcaster, RaceResults results) {
        this.racer1 = racer1;
        this.racer2 = racer2;
        this.racer3 = racer3;
        this.racer4 = racer4;
        this.environment = environment;
        this.broadcaster = broadcaster;
        this.results = results;
    }

    public synchronized void run() throws Exception {
        this.reset();
        this.broadcaster.start();
        this.registerRacers();
        this.startEngines();
        this.startRace();
        this.awaitEnd();
        this.processResult();
    }

    private void reset() {
        this.startBarrier = new CyclicBarrier(5);
        this.endCountDownLatch = new CountDownLatch(4);
        this.donePosition = new AtomicInteger(1);
        this.abortedPosition = new AtomicInteger(4);
        this.result = new RaceResult();
    }

    private void registerRacers() {
        this.racer1.setRegistration(new Registration(this, this.racer1, 1, null));
        this.racer2.setRegistration(new Registration(this, this.racer2, 2, null));
        this.racer3.setRegistration(new Registration(this, this.racer3, 3, null));
        this.racer4.setRegistration(new Registration(this, this.racer4, 4, null));
    }

    private void startEngines() {
        this.broadcaster.startYourEngines();
        this.racer1.startEngine();
        this.racer2.startEngine();
        this.racer3.startEngine();
        this.racer4.startEngine();
    }

    private void startRace() throws Exception {
        this.broadcaster.readySetGo();
        this.startBarrier.await(30L, TimeUnit.SECONDS);
    }

    private void awaitEnd() throws Exception {
        this.endCountDownLatch.await(90L, TimeUnit.SECONDS);
        this.broadcaster.raceEnd();
    }

    private void processResult() {
        this.results.add(this.result);
        this.broadcaster.raceResult(this.result);
        this.broadcaster.championshipStandings(new ChampionshipStandings().addAll(this.results).getEntryList());
    }

    static /* synthetic */ CyclicBarrier access$100(Race x0) {
        return x0.startBarrier;
    }

    static /* synthetic */ AtomicInteger access$200(Race x0) {
        return x0.donePosition;
    }

    static /* synthetic */ RaceResult access$300(Race x0) {
        return x0.result;
    }

    static /* synthetic */ CountDownLatch access$400(Race x0) {
        return x0.endCountDownLatch;
    }

    static /* synthetic */ AtomicInteger access$500(Race x0) {
        return x0.abortedPosition;
    }

    static /* synthetic */ Map access$600(Race x0) {
        return x0.environment;
    }

    static /* synthetic */ RaceBroadcaster access$700(Race x0) {
        return x0.broadcaster;
    }
}

