/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.threadracing;

import java.util.UUID;
import javax.annotation.Resource;
import javax.enterprise.concurrent.ManagedThreadFactory;
import javax.inject.Inject;
import org.jboss.as.quickstarts.threadracing.Race;
import org.jboss.as.quickstarts.threadracing.Racer;
import org.jboss.as.quickstarts.threadracing.stage.batch.BatchRaceStage;
import org.jboss.as.quickstarts.threadracing.stage.concurrency.EEConcurrencyRaceStage;
import org.jboss.as.quickstarts.threadracing.stage.jaxrs.JAXRSRaceStage;
import org.jboss.as.quickstarts.threadracing.stage.jms.JMSRaceStage;
import org.jboss.as.quickstarts.threadracing.stage.json.JSONRaceStage;

public class Racer {
    @Resource
    private ManagedThreadFactory managedThreadFactory;
    @Inject
    private BatchRaceStage batchRaceStage;
    @Inject
    private EEConcurrencyRaceStage eeConcurrencyRaceStage;
    @Inject
    private JAXRSRaceStage jaxrsRaceStageRen;
    @Inject
    private JMSRaceStage jmsRaceStage;
    @Inject
    private JSONRaceStage jsonRaceStageRen;
    private Race.Registration registration;
    private final String name;

    public Racer() {
        this("Racer" + UUID.randomUUID());
    }

    public Racer(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setRegistration(Race.Registration registration) {
        this.registration = registration;
    }

    public void startEngine() {
        1 raceTask = new /* Unavailable Anonymous Inner Class!! */;
        this.managedThreadFactory.newThread((Runnable)raceTask).start();
    }

    private void runRaceStages() throws Exception {
        this.batchRaceStage.run(this.registration);
        this.registration.broadcast("completed the Batch 1.0 stage.");
        this.eeConcurrencyRaceStage.run(this.registration);
        this.registration.broadcast("completed the EE Concurrency 1.0 stage.");
        this.jaxrsRaceStageRen.run(this.registration);
        this.registration.broadcast("completed the JAX-RS 2.0 stage.");
        this.jmsRaceStage.run(this.registration);
        this.registration.broadcast("completed the JMS 2.0 stage.");
        this.jsonRaceStageRen.run(this.registration);
        this.registration.broadcast("completed the JSON 1.0 stage.");
    }

    static /* synthetic */ Race.Registration access$000(Racer x0) {
        return x0.registration;
    }

    static /* synthetic */ void access$100(Racer x0) throws Exception {
        x0.runRaceStages();
    }
}

