/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.threadracing;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.jboss.as.quickstarts.threadracing.Race;
import org.jboss.as.quickstarts.threadracing.RaceBroadcaster;
import org.jboss.as.quickstarts.threadracing.Racer;
import org.jboss.as.quickstarts.threadracing.WebSocketRace;
import org.jboss.as.quickstarts.threadracing.WebSocketRaceBroadcaster;
import org.jboss.as.quickstarts.threadracing.legends.JimmieThronson;
import org.jboss.as.quickstarts.threadracing.legends.MichaelThrumacher;
import org.jboss.as.quickstarts.threadracing.legends.SebastienThroeb;
import org.jboss.as.quickstarts.threadracing.legends.ValentinoThrossi;
import org.jboss.as.quickstarts.threadracing.results.RaceResults;

@ServerEndpoint(value="/race", configurator=ServerEndpointConfigurator.class)
public class WebSocketRace {
    public static final String PATH = "/race";
    @Inject
    private JimmieThronson racer1;
    @Inject
    private MichaelThrumacher racer2;
    @Inject
    private SebastienThroeb racer3;
    @Inject
    private ValentinoThrossi racer4;
    @Inject
    private RaceResults raceResults;

    @OnOpen
    public void onOpen(Session session) {
        try {
            new Race((Racer)this.racer1, (Racer)this.racer2, (Racer)this.racer3, (Racer)this.racer4, this.buildRaceEnvironment(session), (RaceBroadcaster)new WebSocketRaceBroadcaster(session), this.raceResults).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                session.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Map<String, String> buildRaceEnvironment(Session session) {
        String requestURI;
        HashMap<String, String> environment = new HashMap<String, String>();
        String host = (String)session.getUserProperties().get("Host");
        if (host != null) {
            String[] hostSplit = host.split(":");
            environment.put("SERVER_NAME", hostSplit[0]);
            environment.put("SERVER_PORT", hostSplit.length > 1 ? hostSplit[1] : "80");
        }
        String rootPath = (requestURI = session.getRequestURI().toString()).equals(PATH) ? "" : requestURI.substring(0, requestURI.length() - PATH.length());
        environment.put("ROOT_PATH", rootPath);
        return environment;
    }
}

