/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.threadracing.stage.jms;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.JMSContext;
import javax.jms.JMSDestinationDefinition;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;

@JMSDestinationDefinition(name="java:global/threadRacing/stages/jms/requestQueue", interfaceName="javax.jms.Queue", destinationName="JMSThreadRacingQueue")
@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationLookup", propertyValue="java:global/threadRacing/stages/jms/requestQueue"), @ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue")})
public class JMSRaceStageMessageListener
implements MessageListener {
    public static final String REQUEST_QUEUE = "java:global/threadRacing/stages/jms/requestQueue";
    @Inject
    private JMSContext jmsContext;

    public void onMessage(Message message) {
        try {
            this.jmsContext.createProducer().send(message.getJMSReplyTo(), ((TextMessage)message).getText());
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

