/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.auth.provider.AggregateSecurityRealm;
import org.wildfly.security.auth.server.SecurityRealm;

public class AggregateRealmService
implements Service<SecurityRealm> {
    private volatile SecurityRealm securityRealm;
    private final InjectedValue<SecurityRealm> authenticationRealm = new InjectedValue();
    private final InjectedValue<SecurityRealm> authorizationRealm = new InjectedValue();

    public void start(StartContext context) throws StartException {
        SecurityRealm authenticationRealm = (SecurityRealm)this.authenticationRealm.getValue();
        SecurityRealm authorizationRealm = (SecurityRealm)this.authorizationRealm.getValue();
        this.securityRealm = new AggregateSecurityRealm(authenticationRealm, authorizationRealm);
    }

    public void stop(StopContext context) {
        this.securityRealm = null;
    }

    public SecurityRealm getValue() throws IllegalStateException, IllegalArgumentException {
        return this.securityRealm;
    }

    Injector<SecurityRealm> getAuthenticationRealmInjector() {
        return this.authenticationRealm;
    }

    Injector<SecurityRealm> getAuthorizationRealmInjector() {
        return this.authenticationRealm;
    }
}

