/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.CustomComponentService;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;

class CustomComponentDefinition<T>
extends SimpleResourceDefinition {
    static final SimpleMapAttributeDefinition CONFIGURATION = ((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("configuration", ModelType.STRING, true).setAttributeMarshaller(new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if ((resourceModel = resourceModel.get(attribute.getName())).isDefined()) {
                writer.writeStartElement(attribute.getName());
                for (ModelNode property : resourceModel.asList()) {
                    writer.writeEmptyElement("property");
                    writer.writeAttribute("key", property.asProperty().getName());
                    writer.writeAttribute("value", property.asProperty().getValue().asString());
                }
                writer.writeEndElement();
            }
        }
    })).build();
    private final Class<T> serviceType;
    private final RuntimeCapability<Void> runtimeCapability;
    private final String pathKey;
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ClassLoadingAttributeDefinitions.MODULE, ClassLoadingAttributeDefinitions.SLOT, ClassLoadingAttributeDefinitions.CLASS_NAME, CONFIGURATION};

    CustomComponentDefinition(Class<T> serviceType, RuntimeCapability<Void> runtimeCapability, String pathKey) {
        super(CustomComponentDefinition.addAddRemoveHandlers(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey)).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES), runtimeCapability, serviceType));
        this.serviceType = serviceType;
        this.runtimeCapability = runtimeCapability;
        this.pathKey = pathKey;
    }

    private static <T> SimpleResourceDefinition.Parameters addAddRemoveHandlers(SimpleResourceDefinition.Parameters parameters, RuntimeCapability<Void> runtimeCapability, Class<T> serviceType) {
        ComponentAddHandler add = new ComponentAddHandler(runtimeCapability, serviceType);
        ComponentRemoveHandler<T> remove = new ComponentRemoveHandler<T>(add, runtimeCapability, serviceType);
        parameters.setAddHandler(add);
        parameters.setRemoveHandler(remove);
        return parameters;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteAttributeHandler<T> writeHandler = new WriteAttributeHandler<T>(this.serviceType, this.runtimeCapability, this.pathKey);
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, writeHandler);
        }
    }

    private static class WriteAttributeHandler<T>
    extends RestartParentWriteAttributeHandler {
        private final RuntimeCapability<?> runtimeCapability;
        private final Class<T> serviceType;

        WriteAttributeHandler(Class<T> serviceType, RuntimeCapability<?> runtimeCapability, String pathKey) {
            super(pathKey, ATTRIBUTES);
            this.serviceType = serviceType;
            this.runtimeCapability = runtimeCapability;
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return this.runtimeCapability.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(this.serviceType);
        }
    }

    private static class ComponentRemoveHandler<T>
    extends ServiceRemoveStepHandler {
        private final RuntimeCapability<Void> runtimeCapability;
        private final Class<T> serviceType;

        public ComponentRemoveHandler(AbstractAddStepHandler addOperation, RuntimeCapability<Void> runtimeCapability, Class<T> serviceType) {
            super(addOperation, new RuntimeCapability[]{runtimeCapability});
            this.runtimeCapability = runtimeCapability;
            this.serviceType = serviceType;
        }

        protected ServiceName serviceName(String name) {
            RuntimeCapability dynamicCapability = this.runtimeCapability.fromBaseCapability(name);
            return dynamicCapability.getCapabilityServiceName(this.serviceType);
        }
    }

    private static class ComponentAddHandler<T>
    extends AbstractAddStepHandler {
        private final RuntimeCapability<Void> runtimeCapability;
        private final Class<T> serviceType;

        private ComponentAddHandler(RuntimeCapability<Void> runtimeCapability, Class<T> serviceType) {
            super(runtimeCapability, ATTRIBUTES);
            this.runtimeCapability = runtimeCapability;
            this.serviceType = serviceType;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            HashMap<String, String> configurationMap;
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = this.runtimeCapability.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName componentName = runtimeCapability.getCapabilityServiceName(this.serviceType);
            String module = ElytronExtension.asStringIfDefined(context, ClassLoadingAttributeDefinitions.MODULE, model);
            String slot = ElytronExtension.asStringIfDefined(context, ClassLoadingAttributeDefinitions.SLOT, model);
            String className = ClassLoadingAttributeDefinitions.CLASS_NAME.resolveModelAttribute(context, model).asString();
            ModelNode configuration = CONFIGURATION.resolveModelAttribute(context, model);
            if (configuration.isDefined()) {
                configurationMap = new HashMap<String, String>();
                configuration.asPropertyList().forEach(p -> configurationMap.put(p.getName(), p.getValue().asString()));
            } else {
                configurationMap = null;
            }
            CustomComponentService<T> customComponentService = new CustomComponentService<T>(this.serviceType, module, slot, className, configurationMap);
            ServiceBuilder serviceBuilder = serviceTarget.addService(componentName, customComponentService);
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }
}

