/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.PrivilegedActionException;
import java.util.Map;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.Configurable;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

class CustomComponentService<T>
implements Service<T> {
    private final Class<T> type;
    private final String module;
    private final String slot;
    private final String className;
    private final Map<String, String> configuration;
    private T component;

    CustomComponentService(Class<T> type, String module, String slot, String className, Map<String, String> configuration) {
        this.type = type;
        this.module = module;
        this.slot = slot;
        this.className = className;
        this.configuration = configuration;
    }

    public void start(StartContext context) throws StartException {
        try {
            ClassLoader classLoader = SecurityActions.doPrivileged(() -> ClassLoadingAttributeDefinitions.resolveClassLoader(this.module, this.slot));
            Class<T> typeClazz = classLoader.loadClass(this.className).asSubclass(this.type);
            T component = typeClazz.newInstance();
            if (this.configuration != null) {
                if (!(component instanceof Configurable)) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.componentNotConfigurable(component.getClass().getName());
                }
                Configurable configurableComponent = (Configurable)component;
                configurableComponent.initialize(this.configuration);
            }
            this.component = component;
        }
        catch (PrivilegedActionException e) {
            throw new StartException(e.getCause());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        this.component = null;
    }

    public T getValue() throws IllegalStateException, IllegalArgumentException {
        return this.component;
    }
}

