/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.TrivialService;

class EmptyResourceDefinition
extends SimpleResourceDefinition {
    private EmptyResourceDefinition(String pathKey, OperationStepHandler add, OperationStepHandler remove) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey)).setAddHandler(add).setRemoveHandler(remove).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
    }

    static <T> ResourceDefinition create(Class<T> valueType, String pathKey, RuntimeCapability<?> runtimeCapability, TrivialService.ValueSupplier<T> valueSupplier) {
        ResourceAddHandler add = new ResourceAddHandler(valueType, runtimeCapability, valueSupplier);
        ResourceRemoveHandler<T> remove = new ResourceRemoveHandler<T>(add, valueType, runtimeCapability);
        return new EmptyResourceDefinition(pathKey, (OperationStepHandler)add, (OperationStepHandler)remove);
    }

    private static class ResourceRemoveHandler<T>
    extends ServiceRemoveStepHandler {
        private final Class<T> valueType;
        private final RuntimeCapability<?> runtimeCapability;

        public ResourceRemoveHandler(AbstractAddStepHandler addOperation, Class<T> valueType, RuntimeCapability<?> runtimeCapability) {
            super(addOperation, new RuntimeCapability[]{runtimeCapability});
            this.valueType = valueType;
            this.runtimeCapability = runtimeCapability;
        }

        protected ServiceName serviceName(String name) {
            return this.runtimeCapability.fromBaseCapability(name).getCapabilityServiceName(this.valueType);
        }
    }

    private static class ResourceAddHandler<T>
    extends AbstractAddStepHandler {
        private final Class<T> valueType;
        private final RuntimeCapability<?> runtimeCapability;
        private final TrivialService.ValueSupplier<T> valueSupplier;

        private ResourceAddHandler(Class<T> valueType, RuntimeCapability<?> runtimeCapability, TrivialService.ValueSupplier<T> valueSupplier) {
            super(runtimeCapability, new AttributeDefinition[0]);
            this.valueType = valueType;
            this.runtimeCapability = runtimeCapability;
            this.valueSupplier = valueSupplier;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = this.runtimeCapability.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName componentName = runtimeCapability.getCapabilityServiceName(this.valueType);
            TrivialService<T> componentService = new TrivialService<T>(this.valueSupplier);
            ServiceBuilder componentBuilder = serviceTarget.addService(componentName, componentService);
            ElytronDefinition.commonDependencies(componentBuilder).setInitialMode(ServiceController.Mode.LAZY).install();
        }
    }
}

