/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.DelegatingResource;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.msc.service.ServiceController;

class KeyStoreResource
extends DelegatingResource {
    private ServiceController<KeyStore> keyStoreServiceController;

    public KeyStoreResource(Resource delegate) {
        super(delegate);
    }

    public void setKeyStoreServiceController(ServiceController<KeyStore> keyStoreServiceController) {
        this.keyStoreServiceController = keyStoreServiceController;
    }

    public Set<String> getChildTypes() {
        if (this.containsAliases()) {
            return Collections.singleton("alias");
        }
        return Collections.emptySet();
    }

    public boolean hasChildren(String childType) {
        return "alias".equals(childType) && this.containsAliases();
    }

    public boolean hasChild(PathElement element) {
        try {
            KeyStore keyStore;
            return "alias".equals(element.getKey()) && (keyStore = KeyStoreResource.getKeyStore(this.keyStoreServiceController)) != null && keyStore.containsAlias(element.getValue());
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    public Resource getChild(PathElement element) {
        try {
            KeyStore keyStore;
            if ("alias".equals(element.getKey()) && (keyStore = KeyStoreResource.getKeyStore(this.keyStoreServiceController)) != null && keyStore.containsAlias(element.getValue())) {
                return PlaceholderResource.INSTANCE;
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return null;
    }

    public Resource requireChild(PathElement element) {
        Resource resource = this.getChild(element);
        if (resource == null) {
            throw new Resource.NoSuchResourceException(element);
        }
        return resource;
    }

    public Set<String> getChildrenNames(String childType) {
        try {
            KeyStore keyStore;
            if ("alias".equals(childType) && (keyStore = KeyStoreResource.getKeyStore(this.keyStoreServiceController)) != null && keyStore.size() > 0) {
                Enumeration<String> aliases = keyStore.aliases();
                LinkedHashSet<String> children = new LinkedHashSet<String>(keyStore.size());
                while (aliases.hasMoreElements()) {
                    children.add(aliases.nextElement());
                }
                return children;
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        try {
            KeyStore keyStore;
            if ("alias".equals(childType) && (keyStore = KeyStoreResource.getKeyStore(this.keyStoreServiceController)) != null && keyStore.size() > 0) {
                Enumeration<String> aliases = keyStore.aliases();
                LinkedHashSet<Resource.ResourceEntry> children = new LinkedHashSet<Resource.ResourceEntry>(keyStore.size());
                while (aliases.hasMoreElements()) {
                    children.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry("alias", aliases.nextElement()));
                }
                return children;
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    public Resource navigate(PathAddress address) {
        return Resource.Tools.navigate((Resource)this, (PathAddress)address);
    }

    public Resource clone() {
        KeyStoreResource keyStoreResource = new KeyStoreResource(super.clone());
        keyStoreResource.setKeyStoreServiceController(this.keyStoreServiceController);
        return keyStoreResource;
    }

    private boolean containsAliases() {
        try {
            KeyStore keyStore = KeyStoreResource.getKeyStore(this.keyStoreServiceController);
            return keyStore != null && keyStore.size() > 0;
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    static KeyStore getKeyStore(ServiceController<KeyStore> keyStoreServiceController) {
        if (keyStoreServiceController == null || keyStoreServiceController.getState() != ServiceController.State.UP) {
            return null;
        }
        return (KeyStore)keyStoreServiceController.getValue();
    }
}

