/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.provider.LegacyPropertiesSecurityRealm;
import org.wildfly.security.auth.server.SecurityRealm;

class PropertiesRealmService
implements Service<SecurityRealm> {
    private final String usersPath;
    private final String usersRelativeTo;
    private final String groupsPath;
    private final String groupsRelativeTo;
    private final boolean plainText;
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private final List<PathManager.Callback.Handle> callbackHandles = new ArrayList<PathManager.Callback.Handle>();
    private volatile SecurityRealm securityRealm;

    PropertiesRealmService(String usersPath, String usersRelativeTo, String groupsPath, String groupsRelativeTo, boolean plainText) {
        this.usersPath = usersPath;
        this.usersRelativeTo = usersRelativeTo;
        this.groupsPath = groupsPath;
        this.groupsRelativeTo = groupsRelativeTo;
        this.plainText = plainText;
    }

    public void start(StartContext context) throws StartException {
        File usersFile = this.resolveFileLocation(this.usersPath, this.usersRelativeTo);
        File groupsFile = this.groupsPath != null ? this.resolveFileLocation(this.groupsPath, this.groupsRelativeTo) : null;
        try (FileInputStream usersInputStream = new FileInputStream(usersFile);
             FileInputStream groupsInputStream = groupsFile != null ? new FileInputStream(groupsFile) : null;){
            this.securityRealm = LegacyPropertiesSecurityRealm.builder().setPasswordsStream((InputStream)usersInputStream).setGroupsStream((InputStream)groupsInputStream).setPlainText(this.plainText).build();
        }
        catch (IOException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToLoadPropertiesFiles(e);
        }
    }

    private File resolveFileLocation(String path, String relativeTo) {
        File resolvedPath;
        if (relativeTo != null) {
            PathManager pathManager = (PathManager)this.pathManager.getValue();
            resolvedPath = new File(pathManager.resolveRelativePathEntry(path, relativeTo));
            PathManager.Callback.Handle callbackHandle = pathManager.registerCallback(relativeTo, new PathManager.Callback(){

                public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                    if (!eventContext.isResourceServiceRestartAllowed()) {
                        eventContext.reloadRequired();
                    }
                }

                public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                }
            }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED});
            this.callbackHandles.add(callbackHandle);
        } else {
            resolvedPath = new File(path);
        }
        return resolvedPath;
    }

    public void stop(StopContext context) {
        this.securityRealm = null;
        Iterator<PathManager.Callback.Handle> it = this.callbackHandles.iterator();
        while (it.hasNext()) {
            PathManager.Callback.Handle handle = it.next();
            handle.remove();
            it.remove();
        }
    }

    Injector<PathManager> getPathManagerInjector() {
        return this.pathManager;
    }

    public SecurityRealm getValue() throws IllegalStateException, IllegalArgumentException {
        return this.securityRealm;
    }
}

