/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.regex.Pattern;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

class RegexAttributeDefinitions {
    static final SimpleAttributeDefinition PATTERN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pattern", ModelType.STRING, false).setAllowExpression(true)).setValidator((ParameterValidator)new RexExValidator())).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

    RegexAttributeDefinitions() {
    }

    private static class RexExValidator
    extends StringLengthValidator {
        private RexExValidator() {
            super(1, false, false);
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            String pattern = value.asString();
            try {
                Pattern.compile(pattern);
            }
            catch (IllegalArgumentException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.invalidRegularExpression(pattern, e);
            }
        }
    }
}

