/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Collections;
import java.util.Map;
import javax.security.sasl.SaslServerFactory;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.DelegatingResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

class SaslFactoryRuntimeResource
extends DelegatingResourceDefinition {
    private static final Map<String, ?> EMPTY_MAP = Collections.emptyMap();
    private final FactoryFunction saslServerFactory;
    private static final StringListAttributeDefinition AVAILABLE_MECHANISMS = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("available-mechanisms").setStorageRuntime()).build();

    private SaslFactoryRuntimeResource(ResourceDefinition delegate, FactoryFunction saslServerFactory) {
        this.saslServerFactory = saslServerFactory;
        this.setDelegate(delegate);
    }

    static ResourceDefinition wrap(ResourceDefinition delegate, FactoryFunction saslServerFactory) {
        return new SaslFactoryRuntimeResource(delegate, saslServerFactory);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)AVAILABLE_MECHANISMS, (OperationStepHandler)new AvailableMechanismsHandler());
    }

    @FunctionalInterface
    static interface FactoryFunction {
        public SaslServerFactory get(OperationContext var1) throws OperationFailedException;
    }

    private class AvailableMechanismsHandler
    extends AbstractRuntimeOnlyHandler {
        private AvailableMechanismsHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            SaslServerFactory saslServerFactory = SaslFactoryRuntimeResource.this.saslServerFactory.get(context);
            if (saslServerFactory != null) {
                String[] mechanisms = saslServerFactory.getMechanismNames(EMPTY_MAP);
                ModelNode mechanismList = new ModelNode();
                for (String current : mechanisms) {
                    mechanismList.add(current);
                }
                context.getResult().set(mechanismList);
            }
        }
    }
}

