/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.function.Function;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.DelegatingResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.Assert;

class AvailableMechanismsRuntimeResource
extends DelegatingResourceDefinition {
    private final Function<OperationContext, String[]> availableMechanismsFunction;
    private static final StringListAttributeDefinition AVAILABLE_MECHANISMS = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("available-mechanisms").setStorageRuntime()).build();

    private AvailableMechanismsRuntimeResource(ResourceDefinition delegate, Function<OperationContext, String[]> availableMechanismsFunction) {
        this.availableMechanismsFunction = (Function)Assert.checkNotNullParam((String)"availableMechanismsFunction", availableMechanismsFunction);
        this.setDelegate(delegate);
    }

    static ResourceDefinition wrap(ResourceDefinition delegate, Function<OperationContext, String[]> availableMechanismsFunction) {
        return new AvailableMechanismsRuntimeResource(delegate, availableMechanismsFunction);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)AVAILABLE_MECHANISMS, (OperationStepHandler)new AvailableMechanismsHandler());
    }

    private class AvailableMechanismsHandler
    extends AbstractRuntimeOnlyHandler {
        private AvailableMechanismsHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String[] mechanisms = (String[])AvailableMechanismsRuntimeResource.this.availableMechanismsFunction.apply(context);
            ModelNode mechanismList = new ModelNode();
            if (mechanisms != null) {
                for (String current : mechanisms) {
                    mechanismList.add(current);
                }
            }
            context.getResult().set(mechanismList);
        }
    }
}

