/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.DomainService;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.IdentityResourceDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.RoleMapper;

class DomainDefinition
extends SimpleResourceDefinition {
    private static final ServiceUtil<SecurityRealm> REALM_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, null, SecurityRealm.class);
    static final SimpleAttributeDefinition DEFAULT_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-realm", ModelType.STRING, false).setAllowExpression(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PRE_REALM_NAME_REWRITER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pre-realm-name-rewriter", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.name-rewriter", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition POST_REALM_NAME_REWRITER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("post-realm-name-rewriter", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.name-rewriter", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition PRINCIPAL_DECODER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal-decoder", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.principal-decoder", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition PERMISSION_MAPPER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("permission-mapper", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.permission-mapper", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition REALM_MAPPER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm-mapper", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.realm-mapper", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition ROLE_MAPPER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("role-mapper", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.role-mapper", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition REALM_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm", ModelType.STRING, false).setXmlName("name")).setMinSize(1)).setCapabilityReference("org.wildfly.security.security-realm", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition REALM_NAME_REWRITER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name-rewriter", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.name-rewriter", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition REALM_ROLE_DECODER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("role-decoder", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.role-decoder", "org.wildfly.security.security-domain", true)).build();
    static final ObjectTypeAttributeDefinition REALM = new ObjectTypeAttributeDefinition.Builder("realm", new AttributeDefinition[]{REALM_NAME, REALM_NAME_REWRITER, REALM_ROLE_DECODER, ROLE_MAPPER}).setAllowNull(false).build();
    static final ObjectListAttributeDefinition REALMS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("realms", REALM).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final StringListAttributeDefinition TRUSTED_SECURITY_DOMAINS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("trusted-security-domains").setAllowNull(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.security.security-domain", true)).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PRE_REALM_NAME_REWRITER, POST_REALM_NAME_REWRITER, PRINCIPAL_DECODER, REALM_MAPPER, ROLE_MAPPER, PERMISSION_MAPPER, DEFAULT_REALM, REALMS, TRUSTED_SECURITY_DOMAINS};
    private static final DomainAddHandler ADD = new DomainAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY);
    private static final WriteAttributeHandler WRITE = new WriteAttributeHandler("security-domain");

    DomainDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"security-domain"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("security-domain")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)WRITE);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        this.registerIdentityManagementOperations(resourceRegistration);
    }

    private void registerIdentityManagementOperations(ManagementResourceRegistration resourceRegistration) {
        IdentityResourceDefinition.ReadSecurityDomainIdentityHandler.register(resourceRegistration, this.getResourceDescriptionResolver());
        IdentityResourceDefinition.AuthenticatorOperationHandler.register(resourceRegistration, this.getResourceDescriptionResolver());
    }

    private static ServiceController<SecurityDomain> installService(OperationContext context, ServiceName domainName, ModelNode model) throws OperationFailedException {
        String runtimeCapability;
        ServiceTarget serviceTarget = context.getServiceTarget();
        String simpleName = domainName.getSimpleName();
        String defaultRealm = DEFAULT_REALM.resolveModelAttribute(context, model).asString();
        List realms = REALMS.resolveModelAttribute(context, model).asList();
        List trustedSecurityDomains = TRUSTED_SECURITY_DOMAINS.unwrap((ExpressionResolver)context, model);
        String preRealmNameRewriter = ElytronExtension.asStringIfDefined(context, PRE_REALM_NAME_REWRITER, model);
        String postRealmNameRewriter = ElytronExtension.asStringIfDefined(context, POST_REALM_NAME_REWRITER, model);
        String principalDecoder = ElytronExtension.asStringIfDefined(context, PRINCIPAL_DECODER, model);
        String permissionMapper = ElytronExtension.asStringIfDefined(context, PERMISSION_MAPPER, model);
        String realmMapper = ElytronExtension.asStringIfDefined(context, REALM_MAPPER, model);
        String roleMapper = ElytronExtension.asStringIfDefined(context, ROLE_MAPPER, model);
        DomainService domain = new DomainService(simpleName, defaultRealm, trustedSecurityDomains);
        ServiceBuilder domainBuilder = serviceTarget.addService(domainName, (Service)domain).setInitialMode(ServiceController.Mode.ACTIVE);
        if (preRealmNameRewriter != null) {
            DomainDefinition.injectNameRewriter(preRealmNameRewriter, context, (ServiceBuilder<SecurityDomain>)domainBuilder, domain.createPreRealmNameRewriterInjector(preRealmNameRewriter));
        }
        if (postRealmNameRewriter != null) {
            DomainDefinition.injectNameRewriter(postRealmNameRewriter, context, (ServiceBuilder<SecurityDomain>)domainBuilder, domain.createPostRealmNameRewriterInjector(postRealmNameRewriter));
        }
        if (principalDecoder != null) {
            runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.principal-decoder", (String)principalDecoder);
            ServiceName principalDecoderServiceName = context.getCapabilityServiceName(runtimeCapability, PrincipalDecoder.class);
            domainBuilder.addDependency(principalDecoderServiceName, PrincipalDecoder.class, domain.getPrincipalDecoderInjector());
        }
        if (permissionMapper != null) {
            runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.permission-mapper", (String)permissionMapper);
            ServiceName permissionMapperServiceName = context.getCapabilityServiceName(runtimeCapability, PermissionMapper.class);
            domainBuilder.addDependency(permissionMapperServiceName, PermissionMapper.class, domain.getPermissionMapperInjector());
        }
        if (realmMapper != null) {
            runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.realm-mapper", (String)realmMapper);
            ServiceName realmMapperServiceName = context.getCapabilityServiceName(runtimeCapability, RealmMapper.class);
            domainBuilder.addDependency(realmMapperServiceName, RealmMapper.class, domain.getRealmMapperInjector());
        }
        if (roleMapper != null) {
            DomainDefinition.injectRoleMapper(roleMapper, context, (ServiceBuilder<SecurityDomain>)domainBuilder, domain.createDomainRoleMapperInjector(roleMapper));
        }
        for (ModelNode current : realms) {
            String realmRoleDecoder;
            String realmRoleMapper;
            String realmName = REALM_NAME.resolveModelAttribute(context, current).asString();
            String runtimeCapability2 = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.security-realm", (String)realmName);
            ServiceName realmServiceName = context.getCapabilityServiceName(runtimeCapability2, SecurityRealm.class);
            DomainService.RealmDependency realmDependency = domain.createRealmDependency(realmName);
            REALM_SERVICE_UTIL.addInjection(domainBuilder, realmDependency.getSecurityRealmInjector(), realmServiceName);
            String nameRewriter = ElytronExtension.asStringIfDefined(context, REALM_NAME_REWRITER, current);
            if (nameRewriter != null) {
                Injector<NameRewriter> nameRewriterInjector = realmDependency.getNameRewriterInjector(nameRewriter);
                DomainDefinition.injectNameRewriter(nameRewriter, context, (ServiceBuilder<SecurityDomain>)domainBuilder, nameRewriterInjector);
            }
            if ((realmRoleMapper = ElytronExtension.asStringIfDefined(context, ROLE_MAPPER, current)) != null) {
                DomainDefinition.injectRoleMapper(realmRoleMapper, context, (ServiceBuilder<SecurityDomain>)domainBuilder, realmDependency.getRoleMapperInjector(realmRoleMapper));
            }
            if ((realmRoleDecoder = ElytronExtension.asStringIfDefined(context, REALM_ROLE_DECODER, current)) == null) continue;
            DomainDefinition.injectRoleDecoder(realmRoleDecoder, context, (ServiceBuilder<SecurityDomain>)domainBuilder, realmDependency.getRoleDecoderInjector(realmRoleDecoder));
        }
        ElytronDefinition.commonDependencies(domainBuilder);
        return domainBuilder.install();
    }

    private static void injectNameRewriter(String nameRewriter, OperationContext context, ServiceBuilder<SecurityDomain> domainBuilder, Injector<NameRewriter> injector) {
        if (nameRewriter == null) {
            return;
        }
        if (injector == null) {
            return;
        }
        String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.name-rewriter", (String)nameRewriter);
        ServiceName nameRewriterServiceName = context.getCapabilityServiceName(runtimeCapability, NameRewriter.class);
        domainBuilder.addDependency(nameRewriterServiceName, NameRewriter.class, injector);
    }

    private static void injectRoleMapper(String roleMapper, OperationContext context, ServiceBuilder<SecurityDomain> domainBuilder, Injector<RoleMapper> injector) {
        if (roleMapper == null) {
            return;
        }
        if (injector == null) {
            return;
        }
        String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.role-mapper", (String)roleMapper);
        ServiceName roleMapperServiceName = context.getCapabilityServiceName(runtimeCapability, RoleMapper.class);
        domainBuilder.addDependency(roleMapperServiceName, RoleMapper.class, injector);
    }

    private static void injectRoleDecoder(String roleDecoder, OperationContext context, ServiceBuilder<SecurityDomain> domainBuilder, Injector<RoleDecoder> injector) {
        if (roleDecoder == null) {
            return;
        }
        if (injector == null) {
            return;
        }
        String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.role-decoder", (String)roleDecoder);
        ServiceName roleDecoderServiceName = context.getCapabilityServiceName(runtimeCapability, RoleDecoder.class);
        domainBuilder.addDependency(roleDecoderServiceName, RoleDecoder.class, injector);
    }

    private static void validateDefaultRealmInRealms(OperationContext context, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        String defaultRealm = DEFAULT_REALM.resolveModelAttribute(context, model).asString();
        List realms = REALMS.resolveModelAttribute(context, model).asList();
        for (ModelNode realm : realms) {
            String realmName = REALM_NAME.resolveModelAttribute(context, realm).asString();
            if (!defaultRealm.equals(realmName)) continue;
            return;
        }
        StringBuilder realmsStringBuilder = new StringBuilder();
        for (ModelNode realm : realms) {
            if (realmsStringBuilder.length() != 0) {
                realmsStringBuilder.append(", ");
            }
            realmsStringBuilder.append(realm.get("realm").asString());
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.defaultRealmNotReferenced(defaultRealm, realmsStringBuilder.toString());
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        public WriteAttributeHandler(String parentKeyName) {
            super(parentKeyName, ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(SecurityDomain.class);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            DomainDefinition.installService(context, this.getParentServiceName(parentAddress), parentModel);
        }

        protected void validateUpdatedModel(OperationContext context, Resource resource) throws OperationFailedException {
            DomainDefinition.validateDefaultRealmInRealms(context, resource);
        }
    }

    private static class DomainAddHandler
    extends BaseAddHandler {
        private DomainAddHandler() {
            super(Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            DomainDefinition.validateDefaultRealmInRealms(context, resource);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName domainName = runtimeCapability.getCapabilityServiceName(SecurityDomain.class);
            DomainDefinition.installService(context, domainName, model);
        }
    }
}

