/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.regex.Pattern;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.RegexAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.util.RegexNameRewriter;
import org.wildfly.security.auth.util.RegexNameValidatingRewriter;

class NameRewriterDefinitions {
    static final SimpleAttributeDefinition REPLACEMENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("replacement", ModelType.STRING, false).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(0))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition REPLACE_ALL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("replace-all", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CONSTANT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("constant", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    private static final AggregateComponentDefinition<NameRewriter> AGGREGATE_NAME_REWRITER = AggregateComponentDefinition.create(NameRewriter.class, "aggregate-name-rewriter", "name-rewriters", Capabilities.NAME_REWRITER_RUNTIME_CAPABILITY, n -> NameRewriter.aggregate((NameRewriter[])n));
    private static final AggregateComponentDefinition<NameRewriter> CHAINED_NAME_REWRITER = AggregateComponentDefinition.create(NameRewriter.class, "chained-name-rewriter", "name-rewriters", Capabilities.NAME_REWRITER_RUNTIME_CAPABILITY, n -> NameRewriter.chain((NameRewriter[])n));

    NameRewriterDefinitions() {
    }

    static AggregateComponentDefinition<NameRewriter> getAggregateNameRewriterDefinition() {
        return AGGREGATE_NAME_REWRITER;
    }

    static AggregateComponentDefinition<NameRewriter> getChainedNameRewriterDefinition() {
        return CHAINED_NAME_REWRITER;
    }

    static ResourceDefinition getRegexNameRewriterDefinition() {
        return new RegexNameRewriterDefinition();
    }

    static ResourceDefinition getRegexNameValidatingRewriterDefinition() {
        return new RegexNameValidatingRewriterDefinition();
    }

    static ResourceDefinition getConstantNameRewriterDefinition() {
        return new ConstantNameRewriterDefinition();
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler(String parentName, AttributeDefinition ... attributes) {
            super(parentName, attributes);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.NAME_REWRITER_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(NameRewriter.class);
        }
    }

    private static abstract class NameRewriterAddHandler
    extends BaseAddHandler {
        private NameRewriterAddHandler(AttributeDefinition[] attributes) {
            super(Capabilities.NAME_REWRITER_RUNTIME_CAPABILITY, attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.NAME_REWRITER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmName = runtimeCapability.getCapabilityServiceName(NameRewriter.class);
            TrivialService<NameRewriter> nameRewriterService = new TrivialService<NameRewriter>(this.getNameRewriterSupplier(context, operation, model));
            ElytronDefinition.commonDependencies(serviceTarget.addService(realmName, nameRewriterService)).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        protected abstract TrivialService.ValueSupplier<NameRewriter> getNameRewriterSupplier(OperationContext var1, ModelNode var2, ModelNode var3) throws OperationFailedException;
    }

    private static class ConstantNameRewriterDefinition
    extends SimpleResourceDefinition {
        private static final AbstractAddStepHandler ADD = new NameRewriterAddHandler(new AttributeDefinition[]{CONSTANT}){

            @Override
            protected TrivialService.ValueSupplier<NameRewriter> getNameRewriterSupplier(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                String constant = CONSTANT.resolveModelAttribute(context, model).asString();
                return () -> NameRewriter.constant((String)constant);
            }
        };
        private static final AbstractRemoveStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.NAME_REWRITER_RUNTIME_CAPABILITY);

        private ConstantNameRewriterDefinition() {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"constant-name-rewriter"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("constant-name-rewriter")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler((OperationStepHandler)REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.NAME_REWRITER_RUNTIME_CAPABILITY}));
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CONSTANT, null, (OperationStepHandler)new WriteAttributeHandler("constant-name-rewriter", new AttributeDefinition[]{CONSTANT}));
        }
    }

    private static class RegexNameValidatingRewriterDefinition
    extends SimpleResourceDefinition {
        private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{RegexAttributeDefinitions.PATTERN, MATCH};
        private static final AbstractAddStepHandler ADD = new NameRewriterAddHandler(ATTRIBUTES){

            @Override
            protected TrivialService.ValueSupplier<NameRewriter> getNameRewriterSupplier(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                Pattern pattern = Pattern.compile(RegexAttributeDefinitions.PATTERN.resolveModelAttribute(context, model).asString());
                boolean match = MATCH.resolveModelAttribute(context, model).asBoolean();
                return () -> new RegexNameValidatingRewriter(pattern, match);
            }
        };
        private static final AbstractRemoveStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.NAME_REWRITER_RUNTIME_CAPABILITY);

        private RegexNameValidatingRewriterDefinition() {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"regex-name-validating-rewriter"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("regex-name-validating-rewriter")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler((OperationStepHandler)REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.NAME_REWRITER_RUNTIME_CAPABILITY}));
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            WriteAttributeHandler write = new WriteAttributeHandler("regex-name-validating-rewriter", ATTRIBUTES);
            for (AttributeDefinition current : ATTRIBUTES) {
                resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
            }
        }
    }

    private static class RegexNameRewriterDefinition
    extends SimpleResourceDefinition {
        private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{RegexAttributeDefinitions.PATTERN, REPLACEMENT, REPLACE_ALL};
        private static final AbstractAddStepHandler ADD = new NameRewriterAddHandler(ATTRIBUTES){

            @Override
            protected TrivialService.ValueSupplier<NameRewriter> getNameRewriterSupplier(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                Pattern pattern = Pattern.compile(RegexAttributeDefinitions.PATTERN.resolveModelAttribute(context, model).asString());
                String replacement = REPLACEMENT.resolveModelAttribute(context, model).asString();
                boolean replaceAll = REPLACE_ALL.resolveModelAttribute(context, model).asBoolean();
                return () -> new RegexNameRewriter(pattern, replacement, replaceAll);
            }
        };
        private static final AbstractRemoveStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.NAME_REWRITER_RUNTIME_CAPABILITY);

        private RegexNameRewriterDefinition() {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"regex-name-rewriter"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("regex-name-rewriter")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler((OperationStepHandler)REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.NAME_REWRITER_RUNTIME_CAPABILITY}));
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            WriteAttributeHandler write = new WriteAttributeHandler("regex-name-rewriter", ATTRIBUTES);
            for (AttributeDefinition current : ATTRIBUTES) {
                resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
            }
        }
    }
}

