/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.ProviderAttributeDefinition;
import org.wildfly.extension.elytron.ProviderLoaderDefinition;

class ProviderLoaderParser {
    ProviderLoaderParser() {
    }

    void readProviderLoader(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "register": {
                    ProviderLoaderDefinition.REGISTER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        operation.get("address").set(parentAddress).add("provider-loader", name);
        operations.add(operation);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("provider".equals(localName)) {
                this.readProvider(operation, reader);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readProvider(ModelNode providerLoaderAdd, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode provider = new ModelNode();
        int count = reader.getAttributeCount();
        block18: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "module": {
                    ClassLoadingAttributeDefinitions.MODULE.parseAndSetParameter(value, provider, (XMLStreamReader)reader);
                    continue block18;
                }
                case "load-services": {
                    ProviderAttributeDefinition.LOAD_SERVICES.parseAndSetParameter(value, provider, (XMLStreamReader)reader);
                    continue block18;
                }
                case "class-names": {
                    for (String className : reader.getListAttributeValue(i)) {
                        ClassLoadingAttributeDefinitions.CLASS_NAMES.parseAndAddParameterElement(className, provider, (XMLStreamReader)reader);
                    }
                    continue block18;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean configured = false;
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (configured) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (localName) {
                case "configuration-file": {
                    this.readFileAttributes(provider, reader);
                    break;
                }
                case "configuration-properties": {
                    this.readProperties(provider, reader);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            configured = true;
        }
        providerLoaderAdd.get("providers").add(provider);
    }

    private void readFileAttributes(ModelNode provider, XMLExtendedStreamReader reader) throws XMLStreamException {
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("path"));
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "path": {
                    FileAttributeDefinitions.PATH.parseAndSetParameter(value, provider, (XMLStreamReader)reader);
                    continue block8;
                }
                case "relative-to": {
                    FileAttributeDefinitions.RELATIVE_TO.parseAndSetParameter(value, provider, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readProperties(ModelNode provider, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode propertyList = provider.get("property-list");
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("property".equals(localName)) {
                HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("key", "value"));
                ModelNode property = new ModelNode();
                int count = reader.getAttributeCount();
                block9: for (int i = 0; i < count; ++i) {
                    String value = reader.getAttributeValue(i);
                    if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    String attribute = reader.getAttributeLocalName(i);
                    requiredAttributes.remove(attribute);
                    switch (attribute) {
                        case "key": {
                            ProviderAttributeDefinition.KEY.parseAndSetParameter(value, property, (XMLStreamReader)reader);
                            continue block9;
                        }
                        case "value": {
                            ProviderAttributeDefinition.VALUE.parseAndSetParameter(value, property, (XMLStreamReader)reader);
                            continue block9;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                if (!requiredAttributes.isEmpty()) {
                    throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
                }
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                propertyList.add(property);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void writeProviderLoader(String name, ModelNode providerLoader, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("provider-loader");
        writer.writeAttribute("name", name);
        ProviderLoaderDefinition.REGISTER.marshallAsAttribute(providerLoader, (XMLStreamWriter)writer);
        ModelNode providers = providerLoader.get("providers");
        if (providers.isDefined()) {
            List providersList = providers.asList();
            for (ModelNode currentProvider : providersList) {
                writer.writeStartElement("provider");
                ClassLoadingAttributeDefinitions.MODULE.marshallAsAttribute(currentProvider, (XMLStreamWriter)writer);
                ProviderAttributeDefinition.LOAD_SERVICES.marshallAsAttribute(currentProvider, (XMLStreamWriter)writer);
                ClassLoadingAttributeDefinitions.CLASS_NAMES.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)ClassLoadingAttributeDefinitions.CLASS_NAMES, currentProvider, false, (XMLStreamWriter)writer);
                if (currentProvider.hasDefined("path")) {
                    writer.writeStartElement("configuration-file");
                    FileAttributeDefinitions.PATH.marshallAsAttribute(currentProvider, (XMLStreamWriter)writer);
                    FileAttributeDefinitions.RELATIVE_TO.marshallAsAttribute(currentProvider, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                if (currentProvider.hasDefined("property-list")) {
                    writer.writeStartElement("configuration-properties");
                    for (ModelNode currentProperty : currentProvider.require("property-list").asList()) {
                        writer.writeStartElement("property");
                        ProviderAttributeDefinition.KEY.marshallAsAttribute(currentProperty, (XMLStreamWriter)writer);
                        ProviderAttributeDefinition.VALUE.marshallAsAttribute(currentProperty, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }
}

