/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.AggregateRealmDefinition;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.FileSystemRealmDefinition;
import org.wildfly.extension.elytron.JdbcRealmDefinition;
import org.wildfly.extension.elytron.KeyStoreRealmDefinition;
import org.wildfly.extension.elytron.LdapRealmDefinition;
import org.wildfly.extension.elytron.PropertiesRealmDefinition;
import org.wildfly.extension.elytron.TokenRealmDefinition;

class RealmParser {
    RealmParser() {
    }

    void readRealms(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block22: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "aggregate-realm": {
                    this.readAggregateRealm(parentAddress, reader, operations);
                    continue block22;
                }
                case "custom-realm": {
                    ElytronSubsystemParser.readCustomComponent("custom-realm", parentAddress, reader, operations);
                    continue block22;
                }
                case "custom-modifiable-realm": {
                    ElytronSubsystemParser.readCustomComponent("custom-modifiable-realm", parentAddress, reader, operations);
                    continue block22;
                }
                case "jdbc-realm": {
                    this.readJdbcRealm(parentAddress, reader, operations);
                    continue block22;
                }
                case "key-store-realm": {
                    this.readKeyStoreRealm(parentAddress, reader, operations);
                    continue block22;
                }
                case "properties-realm": {
                    this.readPropertiesRealm(parentAddress, reader, operations);
                    continue block22;
                }
                case "ldap-realm": {
                    this.readLdapRealm(parentAddress, reader, operations);
                    continue block22;
                }
                case "filesystem-realm": {
                    this.readFileSystemRealm(parentAddress, reader, operations);
                    continue block22;
                }
                case "token-realm": {
                    this.readTokenRealm(parentAddress, reader, operations);
                    continue block22;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readAggregateRealm(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRealm = new ModelNode();
        addRealm.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "authentication-realm", "authorization-realm"));
        String name = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block10;
                }
                case "authentication-realm": {
                    AggregateRealmDefinition.AUTHENTICATION_REALM.parseAndSetParameter(value, addRealm, (XMLStreamReader)reader);
                    continue block10;
                }
                case "authorization-realm": {
                    AggregateRealmDefinition.AUTHORIZATION_REALM.parseAndSetParameter(value, addRealm, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addRealm.get("address").set(parentAddress).add("aggregate-realm", name);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(addRealm);
    }

    private void readJdbcRealm(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRealm = new ModelNode();
        addRealm.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addRealm.get("address").set(parentAddress).add("jdbc-realm", name);
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "principal-query": {
                    ModelNode principalQueryNode = this.readModelNode(JdbcRealmDefinition.PrincipalQueryAttributes.ATTRIBUTES, reader, (parentNode, reader1) -> {
                        if (reader1.getLocalName().equals("attribute-mapping")) {
                            ModelNode attributeMappingNode = this.readModelNode(null, reader, (parentNode1, reader2) -> {
                                if (!reader2.getLocalName().equals("attribute")) {
                                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader2);
                                }
                                parentNode1.add(this.readModelNode((AttributeDefinition[])JdbcRealmDefinition.AttributeMappingObjectDefinition.ATTRIBUTES, reader2, null));
                                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader2);
                            });
                            parentNode.get("attribute-mapping").set(attributeMappingNode);
                        } else if (JdbcRealmDefinition.PrincipalQueryAttributes.SUPPORTED_PASSWORD_MAPPERS.containsKey(reader1.getLocalName())) {
                            JdbcRealmDefinition.PasswordMapperObjectDefinition passwordMapperObjectDefinition = JdbcRealmDefinition.PrincipalQueryAttributes.SUPPORTED_PASSWORD_MAPPERS.get(reader1.getLocalName());
                            ModelNode passwordMapperNode = this.readModelNode((AttributeDefinition[])passwordMapperObjectDefinition.getAttributes(), reader1, null);
                            parentNode.get(reader1.getLocalName()).set(passwordMapperNode);
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader1);
                        } else {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader1);
                        }
                    });
                    addRealm.get("principal-query").add(principalQueryNode);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!addRealm.hasDefined("principal-query")) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton("principal-query"));
        }
        operations.add(addRealm);
    }

    private void readKeyStoreRealm(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRealm = new ModelNode();
        addRealm.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "key-store"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "key-store": {
                    KeyStoreRealmDefinition.KEYSTORE.parseAndSetParameter(value, addRealm, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addRealm.get("address").set(parentAddress).add("key-store-realm", name);
        operations.add(addRealm);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readPropertiesRealm(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRealm = new ModelNode();
        addRealm.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block18: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block18;
                }
                case "plain-text": {
                    PropertiesRealmDefinition.PLAIN_TEXT.parseAndSetParameter(value, addRealm, (XMLStreamReader)reader);
                    continue block18;
                }
                case "groups-attribute": {
                    PropertiesRealmDefinition.GROUPS_ATTRIBUTE.parseAndSetParameter(value, addRealm, (XMLStreamReader)reader);
                    continue block18;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addRealm.get("address").set(parentAddress).add("properties-realm", name);
        boolean usersPropertiesFound = false;
        block19: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "users-properties": {
                    ModelNode usersProperties = new ModelNode();
                    this.readFileAttributes(usersProperties, reader);
                    addRealm.get("users-properties").set(usersProperties);
                    usersPropertiesFound = true;
                    continue block19;
                }
                case "groups-properties": {
                    ModelNode groupsProperties = new ModelNode();
                    this.readFileAttributes(groupsProperties, reader);
                    addRealm.get("groups-properties").set(groupsProperties);
                    continue block19;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!usersPropertiesFound) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton("users-properties"));
        }
        operations.add(addRealm);
    }

    private void readFileSystemRealm(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRealm = new ModelNode();
        addRealm.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block16;
                }
                case "levels": {
                    FileSystemRealmDefinition.LEVELS.parseAndSetParameter(value, addRealm, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        addRealm.get("address").set(parentAddress).add("filesystem-realm", name);
        operations.add(addRealm);
        boolean hasFile = false;
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "file": {
                    this.readFileAttributes(addRealm, reader);
                    hasFile = true;
                    continue block17;
                }
                case "name-rewriter": {
                    this.readNameRewriterReference(addRealm, reader);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!hasFile) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton("file"));
        }
    }

    private void readTokenRealm(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRealm = new ModelNode();
        addRealm.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block16;
                }
                case "principal-claim": {
                    TokenRealmDefinition.PRINCIPAL_CLAIM.parseAndSetParameter(value, addRealm, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addRealm.get("address").set(parentAddress).add("token-realm", name);
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "jwt": {
                    ModelNode jwtValidator = this.readModelNode(TokenRealmDefinition.JwtValidatorAttributes.ATTRIBUTES, reader, (parentNode, reader1) -> {});
                    if (!jwtValidator.isDefined()) {
                        jwtValidator.setEmptyObject();
                    }
                    addRealm.get("jwt").set(jwtValidator);
                    continue block17;
                }
                case "oauth2-introspection": {
                    addRealm.get("oauth2-introspection").set(this.readModelNode(TokenRealmDefinition.OAuth2IntrospectionValidatorAttributes.ATTRIBUTES, reader, (parentNode, reader1) -> {}));
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!addRealm.hasDefined("jwt") && !addRealm.hasDefined("oauth2-introspection")) {
            HashSet<String> required = new HashSet<String>();
            required.add("jwt");
            required.add("oauth2-introspection");
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
        }
        operations.add(addRealm);
    }

    private void readNameRewriterReference(ModelNode addRealm, XMLExtendedStreamReader reader) throws XMLStreamException {
        boolean found = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    FileSystemRealmDefinition.NAME_REWRITER.parseAndSetParameter(value, addRealm, (XMLStreamReader)reader);
                    found = true;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!found) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readFileAttributes(ModelNode file, XMLExtendedStreamReader reader) throws XMLStreamException {
        boolean pathFound = false;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "path": {
                    FileAttributeDefinitions.PATH.parseAndSetParameter(value, file, (XMLStreamReader)reader);
                    pathFound = true;
                    continue block8;
                }
                case "relative-to": {
                    FileAttributeDefinitions.RELATIVE_TO.parseAndSetParameter(value, file, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!pathFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"path"});
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readLdapRealm(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRealm = new ModelNode();
        addRealm.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block16;
                }
                case "direct-verification": {
                    LdapRealmDefinition.DIRECT_VERIFICATION.parseAndSetParameter(value, addRealm, (XMLStreamReader)reader);
                    continue block16;
                }
                case "dir-context": {
                    LdapRealmDefinition.DIR_CONTEXT.parseAndSetParameter(value, addRealm, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addRealm.get("address").set(parentAddress).add("ldap-realm", name);
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "identity-mapping": {
                    ModelNode principalMappingNode = this.readModelNode(LdapRealmDefinition.IdentityMappingObjectDefinition.ATTRIBUTES, reader, (parentNode, reader1) -> {
                        if (reader1.getLocalName().equals("attribute-mapping")) {
                            ModelNode attributeMappingNode = this.readModelNode(null, reader, (parentNode1, reader2) -> {
                                if (!reader1.getLocalName().equals("attribute")) {
                                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader1);
                                }
                                parentNode1.add(this.readModelNode((AttributeDefinition[])LdapRealmDefinition.AttributeMappingObjectDefinition.ATTRIBUTES, reader1, null));
                                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader1);
                            });
                            parentNode.get("attribute-mapping").set(attributeMappingNode);
                        } else if (reader1.getLocalName().equals("new-identity-attributes")) {
                            ModelNode newIdentityAttributesNode = this.readModelNode(null, reader, (parentNode1, reader2) -> {
                                if (!reader1.getLocalName().equals("attribute")) {
                                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader1);
                                }
                                parentNode1.add(this.readModelNode(LdapRealmDefinition.NewIdentityAttributeObjectDefinition.ATTRIBUTES, reader1, null));
                                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader1);
                            });
                            parentNode.get("new-identity-attributes").set(newIdentityAttributesNode);
                        } else if (LdapRealmDefinition.SUPPORTED_CREDENTIAL_MAPPERS.containsKey(reader1.getLocalName())) {
                            LdapRealmDefinition.CredentialMappingObjectDefinition credentialMapperObjectDefinition = LdapRealmDefinition.SUPPORTED_CREDENTIAL_MAPPERS.get(reader1.getLocalName());
                            ModelNode credentialMapperNode = this.readModelNode((AttributeDefinition[])credentialMapperObjectDefinition.getAttributes(), reader1, null);
                            parentNode.get(reader1.getLocalName()).set(credentialMapperNode);
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader1);
                        } else {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader1);
                        }
                    });
                    addRealm.get("identity-mapping").set(principalMappingNode);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(addRealm);
    }

    private ModelNode readModelNode(AttributeDefinition[] attributes, XMLExtendedStreamReader reader, ChildModelNodeReader childReader) throws XMLStreamException {
        ModelNode newModelNode = new ModelNode();
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            AttributeDefinition attributeDefinition = null;
            for (AttributeDefinition current : attributes) {
                if (!attribute.equals(current.getName())) continue;
                attributeDefinition = current;
                break;
            }
            if (attributeDefinition == null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            if (SimpleAttributeDefinition.class.isInstance(attributeDefinition)) {
                SimpleAttributeDefinition simpleAttributeDefinition = (SimpleAttributeDefinition)attributeDefinition;
                simpleAttributeDefinition.parseAndSetParameter(value, newModelNode, (XMLStreamReader)reader);
            }
            if (!(attributeDefinition instanceof StringListAttributeDefinition)) continue;
            StringListAttributeDefinition stringListAttributeDefinition = (StringListAttributeDefinition)attributeDefinition;
            for (String val : reader.getListAttributeValue(i)) {
                stringListAttributeDefinition.parseAndAddParameterElement(val, newModelNode, (XMLStreamReader)reader);
            }
        }
        if (childReader != null) {
            while (reader.hasNext() && reader.nextTag() != 2) {
                ElytronSubsystemParser.verifyNamespace(reader);
                childReader.read(newModelNode, reader);
            }
        }
        return newModelNode;
    }

    private void startRealms(boolean started, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!started) {
            writer.writeStartElement("security-realms");
        }
    }

    private boolean writeAggregateRealms(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-realm")) {
            this.startRealms(started, writer);
            ModelNode realms = subsystem.require("aggregate-realm");
            for (String name : realms.keys()) {
                ModelNode realm = realms.require(name);
                writer.writeStartElement("aggregate-realm");
                writer.writeAttribute("name", name);
                AggregateRealmDefinition.AUTHENTICATION_REALM.marshallAsAttribute(realm, (XMLStreamWriter)writer);
                AggregateRealmDefinition.AUTHORIZATION_REALM.marshallAsAttribute(realm, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomRealms(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-realm")) {
            this.startRealms(started, writer);
            ModelNode realms = subsystem.require("custom-realm");
            for (String name : realms.keys()) {
                ModelNode realm = realms.require(name);
                ElytronSubsystemParser.writeCustomComponent("custom-realm", name, realm, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomModifiableRealms(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-modifiable-realm")) {
            this.startRealms(started, writer);
            ModelNode realms = subsystem.require("custom-modifiable-realm");
            for (String name : realms.keys()) {
                ModelNode realm = realms.require(name);
                ElytronSubsystemParser.writeCustomComponent("custom-modifiable-realm", name, realm, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeJdbcRealms(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("jdbc-realm")) {
            this.startRealms(started, writer);
            ModelNode realms = subsystem.require("jdbc-realm");
            for (String name : realms.keys()) {
                writer.writeStartElement("jdbc-realm");
                writer.writeAttribute("name", name);
                ModelNode jdbcRealmNode = realms.require(name);
                for (ModelNode principalQueryNode : jdbcRealmNode.get("principal-query").asList()) {
                    this.writeObjectTypeAttribute("principal-query", JdbcRealmDefinition.PrincipalQueryAttributes.ATTRIBUTES, principalQueryNode, writer, new ChildModelNodeWriter(){

                        @Override
                        public void write(ModelNode modelNode, XMLExtendedStreamWriter writer) throws XMLStreamException {
                            for (JdbcRealmDefinition.PasswordMapperObjectDefinition mapperDefinition : JdbcRealmDefinition.PrincipalQueryAttributes.SUPPORTED_PASSWORD_MAPPERS.values()) {
                                ObjectTypeAttributeDefinition objectDefinition = mapperDefinition.getObjectDefinition();
                                RealmParser.this.writeObjectTypeAttribute(objectDefinition.getName(), (AttributeDefinition[])mapperDefinition.getAttributes(), modelNode.get(objectDefinition.getName()), writer, null);
                            }
                            ModelNode attributeMappingNode = modelNode.get("attribute-mapping");
                            if (attributeMappingNode.isDefined()) {
                                writer.writeStartElement("attribute-mapping");
                                for (ModelNode elementNode : attributeMappingNode.asList()) {
                                    RealmParser.this.writeObjectTypeAttribute("attribute", (AttributeDefinition[])JdbcRealmDefinition.AttributeMappingObjectDefinition.ATTRIBUTES, elementNode, writer, null);
                                }
                                writer.writeEndElement();
                            }
                        }
                    });
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeTokenRealms(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("token-realm")) {
            this.startRealms(started, writer);
            ModelNode realms = subsystem.require("token-realm");
            for (String name : realms.keys()) {
                writer.writeStartElement("token-realm");
                writer.writeAttribute("name", name);
                ModelNode tokenRealm = realms.require(name);
                TokenRealmDefinition.PRINCIPAL_CLAIM.marshallAsAttribute(tokenRealm, (XMLStreamWriter)writer);
                if (tokenRealm.hasDefined("jwt")) {
                    ModelNode jwtValidator = tokenRealm.get("jwt");
                    this.writeObjectTypeAttribute("jwt", TokenRealmDefinition.JwtValidatorAttributes.ATTRIBUTES, jwtValidator, writer, null);
                } else if (tokenRealm.hasDefined("oauth2-introspection")) {
                    ModelNode oauth2Validator = tokenRealm.get("oauth2-introspection");
                    this.writeObjectTypeAttribute("oauth2-introspection", TokenRealmDefinition.OAuth2IntrospectionValidatorAttributes.ATTRIBUTES, oauth2Validator, writer, null);
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeKeyStoreRealms(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("key-store-realm")) {
            this.startRealms(started, writer);
            ModelNode realms = subsystem.require("key-store-realm");
            for (String name : realms.keys()) {
                writer.writeStartElement("key-store-realm");
                writer.writeAttribute("name", name);
                KeyStoreRealmDefinition.KEYSTORE.marshallAsAttribute(realms.require(name), (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writePropertiesRealms(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("properties-realm")) {
            this.startRealms(started, writer);
            ModelNode realms = subsystem.require("properties-realm");
            for (String name : realms.keys()) {
                writer.writeStartElement("properties-realm");
                writer.writeAttribute("name", name);
                ModelNode model = realms.require(name);
                PropertiesRealmDefinition.PLAIN_TEXT.marshallAsAttribute(model, (XMLStreamWriter)writer);
                PropertiesRealmDefinition.GROUPS_ATTRIBUTE.marshallAsAttribute(model, (XMLStreamWriter)writer);
                this.writeFile("users-properties", model.get("users-properties"), writer);
                this.writeFile("groups-properties", model.get("groups-properties"), writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private void writeFile(String elementName, ModelNode fileAttribute, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (fileAttribute.isDefined()) {
            writer.writeStartElement(elementName);
            FileAttributeDefinitions.PATH.marshallAsAttribute(fileAttribute, (XMLStreamWriter)writer);
            FileAttributeDefinitions.RELATIVE_TO.marshallAsAttribute(fileAttribute, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private boolean writeLdapRealms(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("ldap-realm")) {
            this.startRealms(started, writer);
            ModelNode realms = subsystem.require("ldap-realm");
            for (String name : realms.keys()) {
                writer.writeStartElement("ldap-realm");
                writer.writeAttribute("name", name);
                ModelNode ldapRealmNode = realms.require(name);
                LdapRealmDefinition.DIR_CONTEXT.marshallAsAttribute(ldapRealmNode, false, (XMLStreamWriter)writer);
                LdapRealmDefinition.DIRECT_VERIFICATION.marshallAsAttribute(ldapRealmNode, false, (XMLStreamWriter)writer);
                this.writeObjectTypeAttribute("identity-mapping", LdapRealmDefinition.IdentityMappingObjectDefinition.ATTRIBUTES, ldapRealmNode.get("identity-mapping"), writer, (modelNode, writer1) -> {
                    ModelNode attributeMappingNode = modelNode.get("attribute-mapping");
                    if (attributeMappingNode.isDefined()) {
                        writer1.writeStartElement("attribute-mapping");
                        for (ModelNode elementNode : attributeMappingNode.asList()) {
                            this.writeObjectTypeAttribute("attribute", (AttributeDefinition[])LdapRealmDefinition.AttributeMappingObjectDefinition.ATTRIBUTES, elementNode, writer1, null);
                        }
                        writer1.writeEndElement();
                    }
                    for (LdapRealmDefinition.CredentialMappingObjectDefinition mapperDefinition : LdapRealmDefinition.SUPPORTED_CREDENTIAL_MAPPERS.values()) {
                        ObjectTypeAttributeDefinition objectDefinition = mapperDefinition.getObjectDefinition();
                        this.writeObjectTypeAttribute(objectDefinition.getName(), (AttributeDefinition[])mapperDefinition.getAttributes(), modelNode.get(objectDefinition.getName()), writer, null);
                    }
                    ModelNode newIdentityAttributesNode = modelNode.get("new-identity-attributes");
                    if (newIdentityAttributesNode.isDefined()) {
                        writer1.writeStartElement("new-identity-attributes");
                        for (ModelNode elementNode : newIdentityAttributesNode.asList()) {
                            this.writeObjectTypeAttribute("attribute", LdapRealmDefinition.NewIdentityAttributeObjectDefinition.ATTRIBUTES, elementNode, writer1, null);
                        }
                        writer1.writeEndElement();
                    }
                });
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeFileSystemRealms(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("filesystem-realm")) {
            this.startRealms(started, writer);
            ModelNode realms = subsystem.require("filesystem-realm");
            for (String name : realms.keys()) {
                ModelNode model = realms.require(name);
                writer.writeStartElement("filesystem-realm");
                writer.writeAttribute("name", name);
                FileSystemRealmDefinition.LEVELS.marshallAsAttribute(model, (XMLStreamWriter)writer);
                writer.writeStartElement("file");
                FileSystemRealmDefinition.PATH.marshallAsAttribute(model, (XMLStreamWriter)writer);
                FileSystemRealmDefinition.RELATIVE_TO.marshallAsAttribute(model, (XMLStreamWriter)writer);
                writer.writeEndElement();
                if (model.hasDefined("name-rewriter")) {
                    writer.writeStartElement("name-rewriter");
                    FileSystemRealmDefinition.NAME_REWRITER.marshallAsAttribute(model, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private void writeObjectTypeAttribute(String name, AttributeDefinition[] attributes, ModelNode attributeNode, XMLExtendedStreamWriter writer, ChildModelNodeWriter childModelNodeWriter) throws XMLStreamException {
        if (attributeNode.isDefined()) {
            writer.writeStartElement(name);
            for (AttributeDefinition attributeDefinition : attributes) {
                if (SimpleAttributeDefinition.class.isInstance(attributeDefinition)) {
                    ((SimpleAttributeDefinition)attributeDefinition).marshallAsAttribute(attributeNode, (XMLStreamWriter)writer);
                }
                if (!(attributeDefinition instanceof StringListAttributeDefinition)) continue;
                attributeDefinition.getAttributeMarshaller().marshallAsAttribute(attributeDefinition, attributeNode, false, (XMLStreamWriter)writer);
            }
            if (childModelNodeWriter != null) {
                childModelNodeWriter.write(attributeNode, writer);
            }
            writer.writeEndElement();
        }
    }

    void writeRealms(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        boolean realmsStarted = false;
        realmsStarted |= this.writeAggregateRealms(realmsStarted, subsystem, writer);
        realmsStarted |= this.writeCustomRealms(realmsStarted, subsystem, writer);
        realmsStarted |= this.writeCustomModifiableRealms(realmsStarted, subsystem, writer);
        realmsStarted |= this.writeJdbcRealms(realmsStarted, subsystem, writer);
        realmsStarted |= this.writeKeyStoreRealms(realmsStarted, subsystem, writer);
        realmsStarted |= this.writePropertiesRealms(realmsStarted, subsystem, writer);
        realmsStarted |= this.writeLdapRealms(realmsStarted, subsystem, writer);
        realmsStarted |= this.writeFileSystemRealms(realmsStarted, subsystem, writer);
        if (realmsStarted |= this.writeTokenRealms(realmsStarted, subsystem, writer)) {
            writer.writeEndElement();
        }
    }

    private static interface ChildModelNodeWriter {
        public void write(ModelNode var1, XMLExtendedStreamWriter var2) throws XMLStreamException;
    }

    private static interface ChildModelNodeReader {
        public void read(ModelNode var1, XMLExtendedStreamReader var2) throws XMLStreamException;
    }
}

