/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.DirContextDefinition;
import org.wildfly.extension.elytron.ElytronSubsystemParser;

public class DirContextParser {
    void readDirContexts(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("dir-context".equals(localName)) {
                this.readDirContext(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void readDirContext(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addDirContext = new ModelNode();
        addDirContext.get("operation").set("add");
        HashSet<String> requiredXmlAttributes = new HashSet<String>(Arrays.asList("name", "url"));
        String name = null;
        int count = reader.getAttributeCount();
        block20: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredXmlAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block20;
                }
                case "url": {
                    DirContextDefinition.URL.parseAndSetParameter(value, addDirContext, (XMLStreamReader)reader);
                    continue block20;
                }
                case "authentication-level": {
                    DirContextDefinition.AUTHENTICATION_LEVEL.parseAndSetParameter(value, addDirContext, (XMLStreamReader)reader);
                    continue block20;
                }
                case "principal": {
                    DirContextDefinition.PRINCIPAL.parseAndSetParameter(value, addDirContext, (XMLStreamReader)reader);
                    continue block20;
                }
                case "credential": {
                    DirContextDefinition.CREDENTIAL.parseAndSetParameter(value, addDirContext, (XMLStreamReader)reader);
                    continue block20;
                }
                case "enable-connection-pooling": {
                    DirContextDefinition.ENABLE_CONNECTION_POOLING.parseAndSetParameter(value, addDirContext, (XMLStreamReader)reader);
                    continue block20;
                }
                case "referral-mode": {
                    DirContextDefinition.REFERRAL_MODE.parseAndSetParameter(value, addDirContext, (XMLStreamReader)reader);
                    continue block20;
                }
                case "ssl-context": {
                    DirContextDefinition.SSL_CONTEXT.parseAndSetParameter(value, addDirContext, (XMLStreamReader)reader);
                    continue block20;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredXmlAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredXmlAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addDirContext.get("address").set(parentAddress).add("dir-context", name);
        operations.add(addDirContext);
    }

    void writeDirContexts(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("dir-context")) {
            writer.writeStartElement("dir-contexts");
            ModelNode dirContexts = subsystem.require("dir-context");
            for (String name : dirContexts.keys()) {
                ModelNode dirContext = dirContexts.require(name);
                writer.writeStartElement("dir-context");
                writer.writeAttribute("name", name);
                DirContextDefinition.URL.marshallAsAttribute(dirContext, (XMLStreamWriter)writer);
                DirContextDefinition.AUTHENTICATION_LEVEL.marshallAsAttribute(dirContext, (XMLStreamWriter)writer);
                DirContextDefinition.PRINCIPAL.marshallAsAttribute(dirContext, (XMLStreamWriter)writer);
                DirContextDefinition.CREDENTIAL.marshallAsAttribute(dirContext, (XMLStreamWriter)writer);
                DirContextDefinition.ENABLE_CONNECTION_POOLING.marshallAsAttribute(dirContext, (XMLStreamWriter)writer);
                DirContextDefinition.REFERRAL_MODE.marshallAsAttribute(dirContext, (XMLStreamWriter)writer);
                DirContextDefinition.SSL_CONTEXT.marshallAsAttribute(dirContext, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }
}

