/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.security.CredentialStoreClient;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.KeyStoreAliasDefinition;
import org.wildfly.extension.elytron.KeyStoreResource;
import org.wildfly.extension.elytron.KeyStoreService;
import org.wildfly.extension.elytron.ProviderAttributeDefinition;
import org.wildfly.extension.elytron.ProviderLoaderDefinition;
import org.wildfly.extension.elytron.ServiceStateDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

final class KeyStoreDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<KeyStore> KEY_STORE_UTIL = ServiceUtil.newInstance(Capabilities.KEY_STORE_RUNTIME_CAPABILITY, "key-store", KeyStore.class);
    static final ServiceUtil<CredentialStoreClient> CREDENTIAL_STORE_CLIENT_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.CREDENTIAL_STORE_CLIENT_RUNTIME_CAPABILITY, "credential-store", CredentialStoreClient.class);
    static final SimpleAttributeDefinition TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, false).setAttributeGroup("implementation")).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PROVIDER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PROVIDER_LOADER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-loader", ModelType.STRING, true).setAttributeGroup("implementation")).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.key-store", true)).build();
    static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = CredentialReference.getAttributeDefinition();
    static final SimpleAttributeDefinition REQUIRED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("required", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setAttributeGroup("file")).setRequires(new String[]{"path"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition ALIAS_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias-filter", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("key-store");
    static final SimpleAttributeDefinition SIZE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("size", ModelType.INT).setStorageRuntime()).build();
    static final SimpleAttributeDefinition SYNCHRONIZED = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("synchronized", ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition MODIFIED = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("modified", ModelType.BOOLEAN).setStorageRuntime()).build();
    static final SimpleOperationDefinition LOAD = new SimpleOperationDefinitionBuilder("load", (ResourceDescriptionResolver)RESOURCE_RESOLVER).build();
    static final SimpleOperationDefinition STORE = new SimpleOperationDefinitionBuilder("store", (ResourceDescriptionResolver)RESOURCE_RESOLVER).build();
    private static final AttributeDefinition[] CONFIG_ATTRIBUTES = new AttributeDefinition[]{TYPE, PROVIDER, PROVIDER_LOADER, CREDENTIAL_REFERENCE, FileAttributeDefinitions.PATH, FileAttributeDefinitions.RELATIVE_TO, REQUIRED, ALIAS_FILTER};
    private static final KeyStoreAddHandler ADD = new KeyStoreAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.KEY_STORE_RUNTIME_CAPABILITY);
    private static final WriteAttributeHandler WRITE = new WriteAttributeHandler();

    KeyStoreDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"key-store"), (ResourceDescriptionResolver)RESOURCE_RESOLVER).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.KEY_STORE_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : CONFIG_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)WRITE);
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ServiceStateDefinition.STATE, (OperationStepHandler)new AbstractRuntimeOnlyHandler(){

            protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceName keyStoreName = KEY_STORE_UTIL.serviceName(operation);
                ServiceController serviceController = context.getServiceRegistry(false).getRequiredService(keyStoreName);
                ServiceStateDefinition.populateResponse(context.getResult(), serviceController);
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)SIZE, (OperationStepHandler)new KeyStoreRuntimeOnlyHandler(false){

            @Override
            protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
                try {
                    result.set(keyStoreService.getValue().size());
                }
                catch (KeyStoreException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToAccessKeyStore(e);
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)SYNCHRONIZED, (OperationStepHandler)new KeyStoreRuntimeOnlyHandler(false){

            @Override
            protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                result.set(sdf.format(new Date(keyStoreService.timeSynched())));
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)MODIFIED, (OperationStepHandler)new KeyStoreRuntimeOnlyHandler(false){

            @Override
            protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
                result.set(keyStoreService.isModified());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ProviderAttributeDefinition.LOADED_PROVIDER, (OperationStepHandler)new KeyStoreRuntimeOnlyHandler(false){

            @Override
            protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
                ProviderAttributeDefinition.populateProvider(result, keyStoreService.getValue().getProvider(), false);
            }
        });
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)LOAD, (OperationStepHandler)PersistanceHandler.INSTANCE);
        resourceRegistration.registerOperationHandler((OperationDefinition)STORE, (OperationStepHandler)PersistanceHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new KeyStoreAliasDefinition(KEY_STORE_UTIL));
    }

    private static class PersistanceHandler
    extends KeyStoreRuntimeOnlyHandler {
        private static final PersistanceHandler INSTANCE = new PersistanceHandler();

        private PersistanceHandler() {
            super(true, true);
        }

        @Override
        protected void performRuntime(ModelNode result, OperationContext context, ModelNode operation, final KeyStoreService keyStoreService) throws OperationFailedException {
            String operationName;
            switch (operationName = operation.require("operation").asString()) {
                case "load": {
                    final KeyStoreService.LoadKey loadKey = keyStoreService.load();
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            keyStoreService.revertLoad(loadKey);
                        }
                    });
                    break;
                }
                case "store": {
                    keyStoreService.save();
                    break;
                }
                default: {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.invalidOperationName(operationName, "load", "store");
                }
            }
        }
    }

    static abstract class KeyStoreRuntimeOnlyHandler
    extends AbstractRuntimeOnlyHandler {
        private final boolean serviceMustBeUp;
        private final boolean writeAccess;

        KeyStoreRuntimeOnlyHandler(boolean serviceMustBeUp, boolean writeAccess) {
            this.serviceMustBeUp = serviceMustBeUp;
            this.writeAccess = writeAccess;
        }

        KeyStoreRuntimeOnlyHandler(boolean serviceMustBeUp) {
            this(serviceMustBeUp, false);
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName keyStoreName = KEY_STORE_UTIL.serviceName(operation);
            ServiceController<KeyStore> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(this.writeAccess), keyStoreName, KeyStore.class);
            ServiceController.State serviceState = serviceContainer.getState();
            if (serviceState != ServiceController.State.UP) {
                if (this.serviceMustBeUp) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(keyStoreName, serviceState);
                }
                return;
            }
            this.performRuntime(context.getResult(), context, operation, (KeyStoreService)serviceContainer.getService());
        }

        protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
        }

        protected void performRuntime(ModelNode result, OperationContext context, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
            this.performRuntime(result, operation, keyStoreService);
        }
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler() {
            super("key-store", CONFIG_ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.KEY_STORE_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(KeyStore.class);
        }
    }

    private static class KeyStoreAddHandler
    extends BaseAddHandler {
        private KeyStoreAddHandler() {
            super(Capabilities.KEY_STORE_RUNTIME_CAPABILITY, CONFIG_ATTRIBUTES);
        }

        private void injectCredentialStoreClient(ServiceBuilder<?> serviceBuilder, OperationContext context, CredentialReference credentialReference, Injector<CredentialStoreClient> injector) throws OperationFailedException {
            if (credentialReference.getSecret() == null) {
                String credentialStoreClientCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.credential-store-client", (String)credentialReference.getCredentialStoreName());
                ServiceName credentialStoreClientServiceName = context.getCapabilityServiceName(credentialStoreClientCapabilityName, CredentialStoreClient.class);
                CREDENTIAL_STORE_CLIENT_SERVICE_UTIL.addInjection(serviceBuilder, injector, credentialStoreClientServiceName);
            }
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            KeyStoreService keyStoreService;
            ModelNode model = resource.getModel();
            String providerLoader = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PROVIDER_LOADER, model);
            String provider = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PROVIDER, model);
            String type = TYPE.resolveModelAttribute(context, model).asString();
            String path = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.PATH, model);
            String relativeTo = null;
            String aliasFilter = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ALIAS_FILTER, model);
            String credentialStoreName = CredentialReference.credentialReferencePartAsStringIfDefined((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)model, (String)"store");
            String credentialAlias = CredentialReference.credentialReferencePartAsStringIfDefined((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)model, (String)"alias");
            String credentialType = CredentialReference.credentialReferencePartAsStringIfDefined((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)model, (String)"type");
            String secret = CredentialReference.credentialReferencePartAsStringIfDefined((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)model, (String)"clear-text");
            CredentialReference credentialReference = null;
            credentialReference = credentialStoreName != null && !credentialStoreName.isEmpty() ? CredentialReference.createCredentialReference((String)credentialStoreName, (String)credentialAlias, (String)credentialType) : CredentialReference.createCredentialReference((char[])(secret != null ? secret.toCharArray() : null));
            if (path != null) {
                relativeTo = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.RELATIVE_TO, model);
                boolean required = REQUIRED.resolveModelAttribute(context, model).asBoolean();
                keyStoreService = KeyStoreService.createFileBasedKeyStoreService(provider, type, relativeTo, path, required, aliasFilter, credentialReference);
            } else {
                keyStoreService = KeyStoreService.createFileLessKeyStoreService(provider, type, aliasFilter, credentialReference);
            }
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.KEY_STORE_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName serviceName = runtimeCapability.getCapabilityServiceName(KeyStore.class);
            ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)keyStoreService).setInitialMode(ServiceController.Mode.ACTIVE);
            if (relativeTo != null) {
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, keyStoreService.getPathManagerInjector());
                serviceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
            }
            if (providerLoader != null) {
                String providersCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providerLoader);
                ServiceName providerLoaderServiceName = context.getCapabilityServiceName(providersCapabilityName, Provider[].class);
                ProviderLoaderDefinition.PROVIDER_LOADER_SERVICE_UTIL.addInjection(serviceBuilder, keyStoreService.getProvidersInjector(), providerLoaderServiceName);
            }
            this.injectCredentialStoreClient(serviceBuilder, context, credentialReference, keyStoreService.getCredentialStoreClientInjector());
            ElytronDefinition.commonDependencies(serviceBuilder);
            ServiceController serviceController = serviceBuilder.install();
            assert (resource instanceof KeyStoreResource);
            ((KeyStoreResource)resource).setKeyStoreServiceController((ServiceController<KeyStore>)serviceController);
        }

        protected Resource createResource(OperationContext context) {
            KeyStoreResource resource = new KeyStoreResource(Resource.Factory.create());
            context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
            return resource;
        }
    }
}

