/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.Configurable;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

class CustomComponentDefinition<T>
extends SimpleResourceDefinition {
    static final SimpleMapAttributeDefinition CONFIGURATION = new SimpleMapAttributeDefinition.Builder("configuration", ModelType.STRING, true).build();
    private final Class<T> serviceType;
    private final RuntimeCapability<?>[] runtimeCapabilities;
    private final String pathKey;
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ClassLoadingAttributeDefinitions.MODULE, ClassLoadingAttributeDefinitions.CLASS_NAME, CONFIGURATION};

    CustomComponentDefinition(Class<T> serviceType, String pathKey, RuntimeCapability ... runtimeCapabilities) {
        super(CustomComponentDefinition.addAddRemoveHandlers(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey)).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(runtimeCapabilities), serviceType, runtimeCapabilities));
        this.serviceType = serviceType;
        this.runtimeCapabilities = runtimeCapabilities;
        this.pathKey = pathKey;
    }

    private static <T> SimpleResourceDefinition.Parameters addAddRemoveHandlers(SimpleResourceDefinition.Parameters parameters, Class<T> serviceType, RuntimeCapability<?> ... runtimeCapabilities) {
        ComponentAddHandler add = new ComponentAddHandler((Class)serviceType, (RuntimeCapability[])runtimeCapabilities);
        TrivialCapabilityServiceRemoveHandler remove = new TrivialCapabilityServiceRemoveHandler(add, runtimeCapabilities);
        parameters.setAddHandler(add);
        parameters.setRemoveHandler((OperationStepHandler)remove);
        return parameters;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteAttributeHandler<T> writeHandler = new WriteAttributeHandler<T>(this.serviceType, this.runtimeCapabilities[0], this.pathKey);
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, writeHandler);
        }
    }

    private static class WriteAttributeHandler<T>
    extends RestartParentWriteAttributeHandler {
        private final RuntimeCapability<?> runtimeCapability;
        private final Class<T> serviceType;

        WriteAttributeHandler(Class<T> serviceType, RuntimeCapability<?> runtimeCapability, String pathKey) {
            super(pathKey, ATTRIBUTES);
            this.serviceType = serviceType;
            this.runtimeCapability = runtimeCapability;
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return this.runtimeCapability.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(this.serviceType);
        }
    }

    private static class ComponentAddHandler<T>
    extends BaseAddHandler {
        private final RuntimeCapability<?>[] runtimeCapabilities;
        private final Class<T> serviceType;

        private ComponentAddHandler(Class<T> serviceType, RuntimeCapability<?> ... runtimeCapabilities) {
            super(new HashSet<RuntimeCapability>(Arrays.asList(runtimeCapabilities)), ATTRIBUTES);
            this.runtimeCapabilities = runtimeCapabilities;
            this.serviceType = serviceType;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            HashMap configurationMap;
            ServiceTarget serviceTarget = context.getServiceTarget();
            String address = context.getCurrentAddressValue();
            RuntimeCapability<?> primaryCapability = this.runtimeCapabilities[0];
            ServiceName primaryServiceName = this.toServiceName(primaryCapability, address);
            String module = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ClassLoadingAttributeDefinitions.MODULE, model);
            String className = ClassLoadingAttributeDefinitions.CLASS_NAME.resolveModelAttribute(context, model).asString();
            ModelNode configuration = CONFIGURATION.resolveModelAttribute(context, model);
            if (configuration.isDefined()) {
                configurationMap = new HashMap();
                configuration.keys().forEach(s -> configurationMap.put(s, configuration.require(s).asString()));
            } else {
                configurationMap = null;
            }
            TrivialService<Object> customComponentService = new TrivialService<Object>(() -> this.createValue(module, className, configurationMap));
            ServiceBuilder serviceBuilder = serviceTarget.addService(primaryServiceName, customComponentService);
            for (int i = 1; i < this.runtimeCapabilities.length; ++i) {
                serviceBuilder.addAliases(new ServiceName[]{this.toServiceName(this.runtimeCapabilities[i], address)});
            }
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private ServiceName toServiceName(RuntimeCapability<?> runtimeCapability, String addressValue) {
            return runtimeCapability.fromBaseCapability(addressValue).getCapabilityServiceName();
        }

        private T createValue(String module, String className, Map<String, String> configuration) throws StartException {
            try {
                ClassLoader classLoader = SecurityActions.doPrivileged(() -> ClassLoadingAttributeDefinitions.resolveClassLoader(module));
                Class<T> typeClazz = classLoader.loadClass(className).asSubclass(this.serviceType);
                T component = typeClazz.newInstance();
                if (configuration != null) {
                    if (!(component instanceof Configurable)) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.componentNotConfigurable(component.getClass().getName());
                    }
                    Configurable configurableComponent = (Configurable)component;
                    configurableComponent.initialize(configuration);
                }
                return component;
            }
            catch (PrivilegedActionException e) {
                throw new StartException(e.getCause());
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new StartException((Throwable)e);
            }
        }
    }
}

