/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.Provider;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.ProviderAttributeDefinition;
import org.wildfly.extension.elytron.ProviderLoaderService;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;

class ProviderLoaderDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<Provider[]> PROVIDER_LOADER_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.PROVIDERS_RUNTIME_CAPABILITY, "provider-loader", Provider[].class);
    static final SimpleAttributeDefinition REGISTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("register", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    private static final AbstractAddStepHandler ADD = new ProviderAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.PROVIDERS_RUNTIME_CAPABILITY);
    private static final OperationStepHandler WRITE = new WriteAttributeHandler();
    private static final StandardResourceDescriptionResolver RESOLVER = ElytronExtension.getResourceDescriptionResolver("provider-loader");
    private static final SimpleOperationDefinition ADD_DEFINITION = new SimpleOperationDefinitionBuilder("add", (ResourceDescriptionResolver)RESOLVER).setParameters(new AttributeDefinition[]{REGISTER, ProviderAttributeDefinition.PROVIDERS}).build();

    ProviderLoaderDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"provider-loader"), (ResourceDescriptionResolver)RESOLVER).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.PROVIDERS_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)REGISTER, null, WRITE);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ProviderAttributeDefinition.INDEXED_PROVIDERS, (OperationStepHandler)new ProvidersAttributeHandler());
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ProviderAttributeDefinition.LOADED_PROVIDERS, (OperationStepHandler)new LoadedProvidersAttributeHandler());
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)ADD_DEFINITION, (OperationStepHandler)ADD);
    }

    private static String[] asStringArrayIfDefined(OperationContext context, StringListAttributeDefinition attributeDefinition, ModelNode model) throws OperationFailedException {
        ModelNode resolved = attributeDefinition.resolveModelAttribute(context, model);
        if (resolved.isDefined()) {
            List values = resolved.asList();
            String[] response = new String[values.size()];
            for (int i = 0; i < response.length; ++i) {
                response[i] = ((ModelNode)values.get(i)).asString();
            }
            return response;
        }
        return null;
    }

    private static class LoadedProvidersAttributeHandler
    extends AbstractRuntimeOnlyHandler {
        private LoadedProvidersAttributeHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName providerLoaderName = PROVIDER_LOADER_SERVICE_UTIL.serviceName(operation);
            ServiceController<Provider[]> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(false), providerLoaderName, Provider[].class);
            if (serviceContainer.getState() != ServiceController.State.UP) {
                return;
            }
            ProviderAttributeDefinition.populateProviders(context.getResult(), (Provider[])serviceContainer.getValue());
        }
    }

    private static class ProvidersAttributeHandler
    implements OperationStepHandler {
        private ProvidersAttributeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            ModelNode result = context.getResult();
            if (model.hasDefined("providers")) {
                int index = 0;
                model.require("providers").asList().iterator().forEachRemaining(m -> result.add(m));
                for (ModelNode currentProvider : result.asList()) {
                    currentProvider.get("index").set(index++);
                }
            }
        }
    }

    private static class ProviderAddHandler
    extends BaseAddHandler {
        ProviderAddHandler() {
            super(Capabilities.PROVIDERS_RUNTIME_CAPABILITY, new AttributeDefinition[]{REGISTER, ProviderAttributeDefinition.PROVIDERS});
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            ModelNode model = resource.getModel();
            ProviderLoaderService.ProviderLoaderServiceBuilder builder = ProviderLoaderService.builder();
            builder.setRegister(REGISTER.resolveModelAttribute(context, model).asBoolean());
            HashSet<String> relativeToSet = new HashSet<String>();
            if (model.hasDefined("providers")) {
                List nodes = model.require("providers").asList();
                for (ModelNode current : nodes) {
                    ProviderLoaderService.ProviderConfigBuilder providerBuilder = builder.addProviderConfig().setModule(ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ClassLoadingAttributeDefinitions.MODULE, current)).setLoadServices(ProviderAttributeDefinition.LOAD_SERVICES.resolveModelAttribute(context, current).asBoolean()).setClassNames(ProviderLoaderDefinition.asStringArrayIfDefined(context, ClassLoadingAttributeDefinitions.CLASS_NAMES, current)).setPath(ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.PATH, current));
                    String relativeTo = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.RELATIVE_TO, current);
                    if (relativeTo != null) {
                        providerBuilder.setRelativeTo(relativeTo);
                        relativeToSet.add(relativeTo);
                    }
                    if (current.hasDefined("property-list")) {
                        ProviderLoaderService.PropertyListBuilder propertyBuilder = providerBuilder.addPropertyList();
                        for (ModelNode currentProp : current.require("property-list").asList()) {
                            propertyBuilder.add(ProviderAttributeDefinition.PROPERTY_NAME.resolveModelAttribute(context, currentProp).asString(), ProviderAttributeDefinition.VALUE.resolveModelAttribute(context, currentProp).asString());
                        }
                        providerBuilder = propertyBuilder.build();
                    }
                    providerBuilder.build();
                }
            }
            ProviderLoaderService providerLoaderService = builder.build();
            RuntimeCapability runtimeCapability = Capabilities.PROVIDERS_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName serviceName = runtimeCapability.getCapabilityServiceName(Provider[].class);
            ServiceTarget serviceTarget = context.getServiceTarget();
            ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)providerLoaderService).setInitialMode(ServiceController.Mode.ACTIVE);
            if (!relativeToSet.isEmpty()) {
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, providerLoaderService.getPathManagerInjector());
                for (String relativeTo : relativeToSet) {
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
                }
            }
            ElytronDefinition.commonDependencies(serviceBuilder);
            serviceBuilder.install();
        }
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler() {
            super("provider-loader", new AttributeDefinition[]{REGISTER});
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.PROVIDERS_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(Provider[].class);
        }
    }
}

