/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.KeyStore;
import java.util.function.Predicate;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.ModifiableKeyStoreService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.keystore.AliasFilter;
import org.wildfly.security.keystore.FilteringKeyStore;

public class FilteringKeyStoreService
implements ModifiableKeyStoreService {
    final InjectedValue<ModifiableKeyStoreService> serviceInjector;
    final String aliasFilter;
    KeyStore filteringKeyStore;
    KeyStore modifiableFilteringKeyStore;

    FilteringKeyStoreService(InjectedValue<ModifiableKeyStoreService> serviceInjector, String aliasFilter) {
        this.serviceInjector = serviceInjector;
        this.aliasFilter = aliasFilter;
    }

    public void start(StartContext startContext) throws StartException {
        try {
            ModifiableKeyStoreService keyStoreService = (ModifiableKeyStoreService)this.serviceInjector.getValue();
            AliasFilter filter = AliasFilter.fromString((String)this.aliasFilter);
            KeyStore unmodifiable = (KeyStore)keyStoreService.getValue();
            KeyStore modifiable = keyStoreService.getModifiableValue();
            ElytronSubsystemMessages.ROOT_LOGGER.tracef("starting:  aliasFilter = %s  filter = %s  unmodifiable = %s  modifiable = %s", new Object[]{this.aliasFilter, filter, unmodifiable, modifiable});
            this.filteringKeyStore = FilteringKeyStore.filteringKeyStore((KeyStore)unmodifiable, (Predicate)filter);
            if (this.modifiableFilteringKeyStore != null) {
                this.modifiableFilteringKeyStore = FilteringKeyStore.filteringKeyStore((KeyStore)modifiable, (Predicate)filter);
            }
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext stopContext) {
        ElytronSubsystemMessages.ROOT_LOGGER.tracef("stopping:  filteringKeyStore = %s  modifiableFilteringKeyStore = %s", this.filteringKeyStore, this.modifiableFilteringKeyStore);
        this.filteringKeyStore = null;
        this.modifiableFilteringKeyStore = null;
    }

    public KeyStore getValue() throws IllegalStateException, IllegalArgumentException {
        return this.filteringKeyStore;
    }

    @Override
    public KeyStore getModifiableValue() {
        if (this.modifiableFilteringKeyStore == null) {
            throw new UnsupportedOperationException();
        }
        return this.modifiableFilteringKeyStore;
    }
}

