/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.Assert;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.TrivialService;

abstract class TrivialAddHandler<T>
extends BaseAddHandler {
    private final RuntimeCapability<?>[] runtimeCapabilities;
    private final ServiceController.Mode initialMode;

    TrivialAddHandler(Class<T> serviceType, AttributeDefinition[] attributes, RuntimeCapability<?> ... runtimeCapabilities) {
        this(serviceType, ServiceController.Mode.ACTIVE, attributes, runtimeCapabilities);
    }

    TrivialAddHandler(Class<T> serviceType, ServiceController.Mode initialMode, AttributeDefinition[] attributes, RuntimeCapability<?> ... runtimeCapabilities) {
        super(new HashSet<Object>(Arrays.asList((Object[])Assert.checkNotNullParam((String)"runtimeCapabilities", runtimeCapabilities))), attributes);
        this.runtimeCapabilities = runtimeCapabilities;
        Assert.checkNotNullParam((String)"serviceType", serviceType);
        this.initialMode = (ServiceController.Mode)Assert.checkNotNullParam((String)"initialMode", (Object)initialMode);
    }

    protected final void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        String address = context.getCurrentAddressValue();
        ServiceName mainName = this.runtimeCapabilities[0].fromBaseCapability(address).getCapabilityServiceName();
        ServiceTarget serviceTarget = context.getServiceTarget();
        TrivialService<T> trivialService = new TrivialService<T>();
        ServiceBuilder serviceBuilder = serviceTarget.addService(mainName, trivialService);
        for (int i = 1; i < this.runtimeCapabilities.length; ++i) {
            serviceBuilder.addAliases(new ServiceName[]{this.runtimeCapabilities[i].fromBaseCapability(address).getCapabilityServiceName()});
        }
        trivialService.setValueSupplier(this.getValueSupplier(serviceBuilder, context, resource.getModel()));
        this.installedForResource(ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(this.initialMode).install(), resource);
    }

    protected void installedForResource(ServiceController<T> serviceController, Resource resource) {
    }

    protected abstract TrivialService.ValueSupplier<T> getValueSupplier(ServiceBuilder<T> var1, OperationContext var2, ModelNode var3) throws OperationFailedException;
}

