/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.realm.ldap.DelegatingLdapContext;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.auth.realm.ldap.SimpleDirContextFactoryBuilder;

public class DirContextDefinition
extends SimpleResourceDefinition {
    public static final String CONNECTION_POOLING_PROPERTY = "com.sun.jndi.ldap.connect.pool";
    static final SimpleAttributeDefinition URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("url", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition AUTHENTICATION_LEVEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-level", ModelType.STRING, true).setDefaultValue(new ModelNode("simple"))).setAllowedValues(new String[]{"none", "simple", "strong"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PRINCIPAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CREDENTIAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("credential", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition ENABLE_CONNECTION_POOLING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-connection-pooling", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition REFERRAL_MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("referral-mode", ModelType.STRING, true).setDefaultValue(new ModelNode(DirContextFactory.ReferralMode.IGNORE.name()))).setAllowedValues(new String[]{DirContextFactory.ReferralMode.FOLLOW.name(), DirContextFactory.ReferralMode.IGNORE.name(), DirContextFactory.ReferralMode.THROW.name()})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{URL, AUTHENTICATION_LEVEL, PRINCIPAL, CREDENTIAL, ENABLE_CONNECTION_POOLING, REFERRAL_MODE};
    private static final AbstractAddStepHandler ADD = new AbstractAddStepHandler(Capabilities.DIR_CONTEXT_RUNTIME_CAPABILITY, (AttributeDefinition[])ATTRIBUTES){

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            RuntimeCapability runtimeCapability = Capabilities.DIR_CONTEXT_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName serviceName = runtimeCapability.getCapabilityServiceName(ExceptionSupplier.class);
            TrivialService service = new TrivialService(DirContextDefinition.obtainDirContextSupplier(context, model));
            ServiceBuilder serviceBuilder = context.getServiceTarget().addService(serviceName, service);
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    };
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.DIR_CONTEXT_RUNTIME_CAPABILITY);

    DirContextDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"dir-context"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("dir-context")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.DIR_CONTEXT_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (SimpleAttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)current, null);
        }
    }

    private static TrivialService.ValueSupplier<ExceptionSupplier<DirContext, NamingException>> obtainDirContextSupplier(OperationContext context, ModelNode model) throws OperationFailedException {
        Properties connectionProperties = new Properties();
        ModelNode enableConnectionPoolingNode = ENABLE_CONNECTION_POOLING.resolveModelAttribute(context, model);
        connectionProperties.put(CONNECTION_POOLING_PROPERTY, (Object)enableConnectionPoolingNode.asBoolean());
        DirContextFactory.ReferralMode referralMode = DirContextFactory.ReferralMode.valueOf((String)REFERRAL_MODE.resolveModelAttribute(context, model).asString());
        DirContextFactory dirContextFactory = SimpleDirContextFactoryBuilder.builder().setProviderUrl(URL.resolveModelAttribute(context, model).asString()).setSecurityAuthentication(AUTHENTICATION_LEVEL.resolveModelAttribute(context, model).asString()).setSecurityPrincipal(PRINCIPAL.resolveModelAttribute(context, model).asString()).setSecurityCredential(CREDENTIAL.resolveModelAttribute(context, model).asString()).setConnectionProperties(connectionProperties).build();
        return () -> () -> new DelegatingLdapContext(dirContextFactory, referralMode);
    }
}

