/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities.SecurityEventListener;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.AuditLogger;
import org.wildfly.security.audit.EventPriority;
import org.wildfly.security.audit.FileAuditEndpoint;
import org.wildfly.security.audit.JsonSecurityEventFormatter;
import org.wildfly.security.audit.SimpleSecurityEventFormatter;
import org.wildfly.security.audit.SyslogAuditEndpoint;
import org.wildfly.security.auth.server.event.SecurityEventVisitor;

class AuditResourceDefinitions {
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(FileAttributeDefinitions.PATH).setRequired(true)).build();
    static final SimpleAttributeDefinition SYNCHRONIZED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("synchronized", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition FORMAT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("format", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode(Format.SIMPLE.toString()))).setAllowedValues(new String[]{Format.SIMPLE.toString(), Format.JSON.toString()})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition SERVER_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-address", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("port", ModelType.INT, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition TRANSPORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("transport", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode(Transport.TCP.toString()))).setAllowedValues(new String[]{Transport.TCP.toString(), Transport.UDP.toString()})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition HOST_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host-name", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    private static final AggregateComponentDefinition<SecurityEventListener> AGGREGATE_SECURITY_EVENT_LISTENER = AggregateComponentDefinition.create(SecurityEventListener.class, "aggregate-security-event-listener", "security-event-listeners", Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY, SecurityEventListener::aggregate, false);
    static final ListAttributeDefinition REFERENCES = AGGREGATE_SECURITY_EVENT_LISTENER.getReferencesAttribute();

    AuditResourceDefinitions() {
    }

    static AggregateComponentDefinition<SecurityEventListener> getAggregateSecurityEventListenerDefinition() {
        return AGGREGATE_SECURITY_EVENT_LISTENER;
    }

    static ResourceDefinition getFileAuditLogResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{PATH, FileAttributeDefinitions.RELATIVE_TO, SYNCHRONIZED, FORMAT};
        TrivialAddHandler<SecurityEventListener> add = new TrivialAddHandler<SecurityEventListener>(SecurityEventListener.class, attributes, new RuntimeCapability[]{Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<SecurityEventListener> getValueSupplier(ServiceBuilder<SecurityEventListener> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                boolean synv = SYNCHRONIZED.resolveModelAttribute(context, model).asBoolean();
                Format format = Format.valueOf(FORMAT.resolveModelAttribute(context, model).asString());
                InjectedValue pathManager = new InjectedValue();
                String path = PATH.resolveModelAttribute(context, model).asString();
                String relativeTo = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.RELATIVE_TO, model);
                if (relativeTo != null) {
                    serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManager);
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
                }
                return () -> {
                    AuditEndpoint endpoint;
                    FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
                    pathResolver.path(path);
                    if (relativeTo != null) {
                        pathResolver.relativeTo(relativeTo, (PathManager)pathManager.getValue());
                    }
                    File resolvedPath = pathResolver.resolve();
                    SecurityEventVisitor formatter = Format.JSON == format ? JsonSecurityEventFormatter.builder().build() : SimpleSecurityEventFormatter.builder().build();
                    try {
                        endpoint = FileAuditEndpoint.builder().setLocation(resolvedPath.toPath()).setSyncOnAccept(synv).build();
                    }
                    catch (IOException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
                    }
                    return SecurityEventListener.from(AuditLogger.builder().setPriorityMapper(m -> EventPriority.WARNING).setMessageFormatter(m -> (String)m.accept(formatter, null)).setAuditEndpoint((ExceptionBiConsumer)endpoint).build());
                };
            }
        };
        return new TrivialResourceDefinition("file-audit-log", add, attributes, Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getSyslogAuditLogResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{SERVER_ADDRESS, PORT, TRANSPORT, HOST_NAME, FORMAT};
        TrivialAddHandler<SecurityEventListener> add = new TrivialAddHandler<SecurityEventListener>(SecurityEventListener.class, attributes, new RuntimeCapability[]{Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<SecurityEventListener> getValueSupplier(ServiceBuilder<SecurityEventListener> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InetAddress serverAddress;
                String address = SERVER_ADDRESS.resolveModelAttribute(context, model).asString();
                try {
                    serverAddress = InetAddress.getByName(address);
                }
                catch (UnknownHostException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.serverNotKnown(address, e);
                }
                int port = PORT.resolveModelAttribute(context, model).asInt();
                Transport transport = Transport.valueOf(TRANSPORT.resolveModelAttribute(context, model).asString());
                String hostName = HOST_NAME.resolveModelAttribute(context, model).asString();
                Format format = Format.valueOf(FORMAT.resolveModelAttribute(context, model).asString());
                return () -> {
                    AuditEndpoint endpoint;
                    SecurityEventVisitor formatter = Format.JSON == format ? JsonSecurityEventFormatter.builder().build() : SimpleSecurityEventFormatter.builder().build();
                    try {
                        endpoint = SyslogAuditEndpoint.builder().setServerAddress(serverAddress).setPort(port).setTcp(Transport.TCP == transport).setHostName(hostName).build();
                    }
                    catch (IOException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
                    }
                    return SecurityEventListener.from(AuditLogger.builder().setPriorityMapper(m -> EventPriority.WARNING).setMessageFormatter(m -> (String)m.accept(formatter, null)).setAuditEndpoint((ExceptionBiConsumer)endpoint).build());
                };
            }
        };
        return new TrivialResourceDefinition("syslog-audit-log", add, attributes, Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY);
    }

    private static enum Transport {
        TCP,
        UDP;

    }

    private static enum Format {
        SIMPLE,
        JSON;

    }
}

