package org.wildfly.extension.elytron._private;

import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import java.net.UnknownHostException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.lang.RuntimeException;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceController.State;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.jboss.msc.service.StartException;
import java.lang.Class;
import java.util.Arrays;
import java.security.NoSuchProviderException;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-02-16T19:12:37+0000")
public class ElytronSubsystemMessages_$logger extends DelegatingBasicLogger implements ElytronSubsystemMessages,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronSubsystemMessages_$logger.class.getName();
    public ElytronSubsystemMessages_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void activatingElytronSubsystem(final String elytronVersion, final String subsystemVersion) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, activatingElytronSubsystem$str(), elytronVersion, subsystemVersion);
    }
    private static final String activatingElytronSubsystem = "WFLYELY00001: Activating Elytron Subsystem Elytron Version=%s, Subsystem Version=%s";
    protected String activatingElytronSubsystem$str() {
        return activatingElytronSubsystem;
    }
    private static final String duplicateRealmInjection = "WFLYELY00002: Can not inject the same realm '%s' in a single security domain.";
    protected String duplicateRealmInjection$str() {
        return duplicateRealmInjection;
    }
    @Override
    public final OperationFailedException duplicateRealmInjection(final String realmName) {
        final OperationFailedException result = new OperationFailedException(String.format(duplicateRealmInjection$str(), realmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationAddressMissingKey = "WFLYELY00003: The operation did not contain an address with a value for '%s'.";
    protected String operationAddressMissingKey$str() {
        return operationAddressMissingKey;
    }
    @Override
    public final IllegalArgumentException operationAddressMissingKey(final String key) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(operationAddressMissingKey$str(), key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToStartService = "WFLYELY00004: Unable to start the service.";
    protected String unableToStartService$str() {
        return unableToStartService;
    }
    @Override
    public final StartException unableToStartService(final Exception cause) {
        final StartException result = new StartException(String.format(unableToStartService$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToAccessKeyStore = "WFLYELY00005: Unable to access KeyStore to complete the requested operation.";
    protected String unableToAccessKeyStore$str() {
        return unableToAccessKeyStore;
    }
    @Override
    public final OperationFailedException unableToAccessKeyStore(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(unableToAccessKeyStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToPopulateResult = "WFLYELY00006: Unable to populate result.";
    protected String unableToPopulateResult$str() {
        return unableToPopulateResult;
    }
    @Override
    public final OperationFailedException unableToPopulateResult(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(unableToPopulateResult$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredServiceNotUp = "WFLYELY00007: The required service '%s' is not UP, it is currently '%s'.";
    protected String requiredServiceNotUp$str() {
        return requiredServiceNotUp;
    }
    @Override
    public final OperationFailedException requiredServiceNotUp(final ServiceName serviceName, final State state) {
        final OperationFailedException result = new OperationFailedException(String.format(requiredServiceNotUp$str(), serviceName, state));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidOperationName = "WFLYELY00008: Invalid operation name '%s', expected one of '%s'";
    protected String invalidOperationName$str() {
        return invalidOperationName;
    }
    @Override
    public final OperationFailedException invalidOperationName(final String actualName, final String... expectedNames) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidOperationName$str(), actualName, Arrays.toString(expectedNames)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCompleteOperation = "WFLYELY00009: Unable to complete operation. '%s'";
    protected String unableToCompleteOperation$str() {
        return unableToCompleteOperation;
    }
    @Override
    public final OperationFailedException unableToCompleteOperation(final Throwable cause, final String causeMessage) {
        final OperationFailedException result = new OperationFailedException(String.format(unableToCompleteOperation$str(), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cantSaveWithoutFile = "WFLYELY00010: Unable to complete operation.";
    protected String cantSaveWithoutFile$str() {
        return cantSaveWithoutFile;
    }
    @Override
    public final OperationFailedException cantSaveWithoutFile() {
        final OperationFailedException result = new OperationFailedException(String.format(cantSaveWithoutFile$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String providerAlreadyRegistered = "WFLYELY00011: A Provider is already registered for '%s'";
    protected String providerAlreadyRegistered$str() {
        return providerAlreadyRegistered;
    }
    @Override
    public final StartException providerAlreadyRegistered(final String name) {
        final StartException result = new StartException(String.format(providerAlreadyRegistered$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuitableProvider = "WFLYELY00012: No suitable provider found for type '%s'";
    protected String noSuitableProvider$str() {
        return noSuitableProvider;
    }
    @Override
    public final StartException noSuitableProvider(final String type) {
        final StartException result = new StartException(String.format(noSuitableProvider$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String defaultRealmNotReferenced = "WFLYELY00013: The default-realm '%s' is not in the list of realms [%s] referenced by this domain.";
    protected String defaultRealmNotReferenced$str() {
        return defaultRealmNotReferenced;
    }
    @Override
    public final OperationFailedException defaultRealmNotReferenced(final String defaultRealm, final String realms) {
        final OperationFailedException result = new OperationFailedException(String.format(defaultRealmNotReferenced$str(), defaultRealm, realms));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadPropertiesFiles = "WFLYELY00014: Unable to load the properties files required to start the properties file backed realm: Users file: '%s' Groups file: '%s'";
    protected String unableToLoadPropertiesFiles$str() {
        return unableToLoadPropertiesFiles;
    }
    @Override
    public final StartException unableToLoadPropertiesFiles(final Exception cause, final String usersFile, final String groupsFile) {
        final StartException result = new StartException(String.format(unableToLoadPropertiesFiles$str(), usersFile, groupsFile), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentNotConfigurable = "WFLYELY00015: The custom component implementation '%s' doe not implement 'org.wildfly.extension.elytron.Configurable' however configuration has been supplied.";
    protected String componentNotConfigurable$str() {
        return componentNotConfigurable;
    }
    @Override
    public final StartException componentNotConfigurable(final String className) {
        final StartException result = new StartException(String.format(componentNotConfigurable$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRegularExpression = "WFLYELY00016: The supplied regular expression '%s' is invalid.";
    protected String invalidRegularExpression$str() {
        return invalidRegularExpression;
    }
    @Override
    public final OperationFailedException invalidRegularExpression(final String pattern, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidRegularExpression$str(), pattern), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String propertyFilesDoesNotExist = "WFLYELY00017: Property file referenced in properties-realm does not exist: %s";
    protected String propertyFilesDoesNotExist$str() {
        return propertyFilesDoesNotExist;
    }
    @Override
    public final StartException propertyFilesDoesNotExist(final String file) {
        final StartException result = new StartException(String.format(propertyFilesDoesNotExist$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateManagerFactory = "WFLYELY00018: Unable to create %s for algorithm '%s'.";
    protected String unableToCreateManagerFactory$str() {
        return unableToCreateManagerFactory;
    }
    @Override
    public final StartException unableToCreateManagerFactory(final String type, final String algorithm) {
        final StartException result = new StartException(String.format(unableToCreateManagerFactory$str(), type, algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTypeFound = "WFLYELY00019: No '%s' found in injected value.";
    protected String noTypeFound$str() {
        return noTypeFound;
    }
    @Override
    public final StartException noTypeFound(final String type) {
        final StartException result = new StartException(String.format(noTypeFound$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToReLoadPropertiesFiles = "WFLYELY00020: Unable to reload the properties files required to by the properties file backed realm.";
    protected String unableToReLoadPropertiesFiles$str() {
        return unableToReLoadPropertiesFiles;
    }
    @Override
    public final OperationFailedException unableToReLoadPropertiesFiles(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(unableToReLoadPropertiesFiles$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String exceptionWhileCreatingPermission = "WFLYELY00021: Exception while creating the permission object for the permission mapping. Please check [class-name], [target-name] (name of permission) and [action] of [%s].";
    protected String exceptionWhileCreatingPermission$str() {
        return exceptionWhileCreatingPermission;
    }
    @Override
    public final StartException exceptionWhileCreatingPermission(final String permissionClassName, final Throwable cause) {
        final StartException result = new StartException(String.format(exceptionWhileCreatingPermission$str(), permissionClassName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreFileNotExists = "WFLYELY00022: KeyStore file '%s' does not exists and required.";
    protected String keyStoreFileNotExists$str() {
        return keyStoreFileNotExists;
    }
    @Override
    public final StartException keyStoreFileNotExists(final String file) {
        final StartException result = new StartException(String.format(keyStoreFileNotExists$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void keyStoreFileNotExistsButIgnored(final String file) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, keyStoreFileNotExistsButIgnored$str(), file);
    }
    private static final String keyStoreFileNotExistsButIgnored = "WFLYELY00023: KeyStore file '%s' does not exists. Used blank.";
    protected String keyStoreFileNotExistsButIgnored$str() {
        return keyStoreFileNotExistsButIgnored;
    }
    @Override
    public final void certificateNotValid(final String alias, final Exception cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, certificateNotValid$str(), alias);
    }
    private static final String certificateNotValid = "WFLYELY00024: Certificate [%s] in KeyStore is not valid";
    protected String certificateNotValid$str() {
        return certificateNotValid;
    }
    private static final String propertyFileIsInvalid = "WFLYELY00025: Referenced property file is invalid: %s";
    protected String propertyFileIsInvalid$str() {
        return propertyFileIsInvalid;
    }
    @Override
    public final StartException propertyFileIsInvalid(final String message, final Throwable cause) {
        final StartException result = new StartException(String.format(propertyFileIsInvalid$str(), message), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainOidForX500Attribute = "WFLYELY00027: Unable to obtain OID for X.500 attribute '%s'";
    protected String unableToObtainOidForX500Attribute$str() {
        return unableToObtainOidForX500Attribute;
    }
    @Override
    public final OperationFailedException unableToObtainOidForX500Attribute(final String attribute) {
        final OperationFailedException result = new OperationFailedException(String.format(unableToObtainOidForX500Attribute$str(), attribute));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String x500AttributeMustBeDefined = "WFLYELY00028: The X.500 attribute must be defined by name or by OID";
    protected String x500AttributeMustBeDefined$str() {
        return x500AttributeMustBeDefined;
    }
    @Override
    public final OperationFailedException x500AttributeMustBeDefined() {
        final OperationFailedException result = new OperationFailedException(String.format(x500AttributeMustBeDefined$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidURL = "WFLYELY00029: Failed to parse URL '%s'";
    protected String invalidURL$str() {
        return invalidURL;
    }
    @Override
    public final OperationFailedException invalidURL(final String url, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidURL$str(), url), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String realmDoesNotSupportCache = "WFLYELY00030: Realm '%s' does not support cache";
    protected String realmDoesNotSupportCache$str() {
        return realmDoesNotSupportCache;
    }
    @Override
    public final StartException realmDoesNotSupportCache(final String realmName) {
        final StartException result = new StartException(String.format(realmDoesNotSupportCache$str(), realmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToAccessCRL = "WFLYELY00031: Unable to access CRL file.";
    protected String unableToAccessCRL$str() {
        return unableToAccessCRL;
    }
    @Override
    public final StartException unableToAccessCRL(final Exception cause) {
        final StartException result = new StartException(String.format(unableToAccessCRL$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToReloadCRL = "WFLYELY00032: Unable to reload CRL file.";
    protected String unableToReloadCRL$str() {
        return unableToReloadCRL;
    }
    @Override
    public final RuntimeException unableToReloadCRL(final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(unableToReloadCRL$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialStoreEntryTypeNotSupported = "WFLYELY00909: Credential store '%s' does not support given credential store entry type '%s'";
    protected String credentialStoreEntryTypeNotSupported$str() {
        return credentialStoreEntryTypeNotSupported;
    }
    @Override
    public final IllegalArgumentException credentialStoreEntryTypeNotSupported(final String credentialStoreName, final String entryType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(credentialStoreEntryTypeNotSupported$str(), credentialStoreName, entryType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStorePasswordCannotBeResolved = "WFLYELY00910: Password cannot be resolved for key-store \"%s\"";
    protected String keyStorePasswordCannotBeResolved$str() {
        return keyStorePasswordCannotBeResolved;
    }
    @Override
    public final IOException keyStorePasswordCannotBeResolved(final String path) {
        final IOException result = new IOException(String.format(keyStorePasswordCannotBeResolved$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialStoreProtectionParameterCannotBeResolved = "WFLYELY00911: Credential store \"%s\" protection parameter cannot be resolved";
    protected String credentialStoreProtectionParameterCannotBeResolved$str() {
        return credentialStoreProtectionParameterCannotBeResolved;
    }
    @Override
    public final IOException credentialStoreProtectionParameterCannotBeResolved(final String name) {
        final IOException result = new IOException(String.format(credentialStoreProtectionParameterCannotBeResolved$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialStoreIssueEncountered = "WFLYELY00912: Credential store issue encountered";
    protected String credentialStoreIssueEncountered$str() {
        return credentialStoreIssueEncountered;
    }
    @Override
    public final OperationFailedException credentialStoreIssueEncountered(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(credentialStoreIssueEncountered$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialAlreadyExists = "WFLYELY00913: Credential alias \"%s\" of credential type \"%s\" already exists in the store";
    protected String credentialAlreadyExists$str() {
        return credentialAlreadyExists;
    }
    @Override
    public final OperationFailedException credentialAlreadyExists(final String alias, final String credentialType) {
        final OperationFailedException result = new OperationFailedException(String.format(credentialAlreadyExists$str(), alias, credentialType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String providerLoaderCannotSupplyProvider = "WFLYELY00914: Provider loader \"%s\" cannot supply Credential Store provider of type \"%s\"";
    protected String providerLoaderCannotSupplyProvider$str() {
        return providerLoaderCannotSupplyProvider;
    }
    @Override
    public final NoSuchProviderException providerLoaderCannotSupplyProvider(final String providerLoader, final String type) {
        final NoSuchProviderException result = new NoSuchProviderException(String.format(providerLoaderCannotSupplyProvider$str(), providerLoader, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nameOfCredentialStoreHasToBeSpecified = "WFLYELY00915: Name of the credential store has to be specified in this credential-reference";
    protected String nameOfCredentialStoreHasToBeSpecified$str() {
        return nameOfCredentialStoreHasToBeSpecified;
    }
    @Override
    public final IllegalStateException nameOfCredentialStoreHasToBeSpecified() {
        final IllegalStateException result = new IllegalStateException(String.format(nameOfCredentialStoreHasToBeSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialCannotBeResolved = "WFLYELY00916: Credential cannot be resolved";
    protected String credentialCannotBeResolved$str() {
        return credentialCannotBeResolved;
    }
    @Override
    public final IllegalStateException credentialCannotBeResolved() {
        final IllegalStateException result = new IllegalStateException(String.format(credentialCannotBeResolved$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String dirContextPasswordCannotBeResolved = "WFLYELY00917: Password cannot be resolved for dir-context";
    protected String dirContextPasswordCannotBeResolved$str() {
        return dirContextPasswordCannotBeResolved;
    }
    @Override
    public final StartException dirContextPasswordCannotBeResolved(final Exception cause) {
        final StartException result = new StartException(String.format(dirContextPasswordCannotBeResolved$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String identityAlreadyExists = "WFLYELY01000: Identity with name [%s] already exists.";
    protected String identityAlreadyExists$str() {
        return identityAlreadyExists;
    }
    @Override
    public final OperationFailedException identityAlreadyExists(final String principalName) {
        final OperationFailedException result = new OperationFailedException(String.format(identityAlreadyExists$str(), principalName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateIdentity = "WFLYELY01001: Could not create identity with name [%s].";
    protected String couldNotCreateIdentity$str() {
        return couldNotCreateIdentity;
    }
    @Override
    public final OperationFailedException couldNotCreateIdentity(final String principalName, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotCreateIdentity$str(), principalName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String identityNotFound = "WFLYELY01002: Identity with name [%s] not found.";
    protected String identityNotFound$str() {
        return identityNotFound;
    }
    @Override
    public final String identityNotFound(final String principalName) {
        return String.format(identityNotFound$str(), principalName);
    }
    private static final String couldNotDeleteIdentity = "WFLYELY01003: Could not delete identity with name [%s].";
    protected String couldNotDeleteIdentity$str() {
        return couldNotDeleteIdentity;
    }
    @Override
    public final OperationFailedException couldNotDeleteIdentity(final String principalName, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotDeleteIdentity$str(), principalName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String identityNotAuthorized = "WFLYELY01004: Identity with name [%s] not authorized.";
    protected String identityNotAuthorized$str() {
        return identityNotAuthorized;
    }
    @Override
    public final String identityNotAuthorized(final String principalName) {
        return String.format(identityNotAuthorized$str(), principalName);
    }
    private static final String couldNotReadIdentity2 = "WFLYELY01005: Could not read identity [%s] from security domain [%s].";
    protected String couldNotReadIdentity2$str() {
        return couldNotReadIdentity2;
    }
    @Override
    public final OperationFailedException couldNotReadIdentity(final String principalName, final ServiceName domainServiceName, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotReadIdentity2$str(), principalName, domainServiceName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedPasswordType = "WFLYELY01006: Unsupported password type [%s].";
    protected String unsupportedPasswordType$str() {
        return unsupportedPasswordType;
    }
    @Override
    public final RuntimeException unsupportedPasswordType(final Class passwordType) {
        final RuntimeException result = new RuntimeException(String.format(unsupportedPasswordType$str(), passwordType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotReadIdentity1 = "WFLYELY01007: Could not read identity with name [%s].";
    protected String couldNotReadIdentity1$str() {
        return couldNotReadIdentity1;
    }
    @Override
    public final OperationFailedException couldNotReadIdentity(final String principalName, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotReadIdentity1$str(), principalName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotObtainAuthorizationIdentity = "WFLYELY01008: Failed to obtain the authorization identity.";
    protected String couldNotObtainAuthorizationIdentity$str() {
        return couldNotObtainAuthorizationIdentity;
    }
    @Override
    public final OperationFailedException couldNotObtainAuthorizationIdentity(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotObtainAuthorizationIdentity$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotAddAttribute = "WFLYELY01009: Failed to add attribute.";
    protected String couldNotAddAttribute$str() {
        return couldNotAddAttribute;
    }
    @Override
    public final OperationFailedException couldNotAddAttribute(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotAddAttribute$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotRemoveAttribute = "WFLYELY01010: Failed to remove attribute.";
    protected String couldNotRemoveAttribute$str() {
        return couldNotRemoveAttribute;
    }
    @Override
    public final OperationFailedException couldNotRemoveAttribute(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotRemoveAttribute$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreatePassword = "WFLYELY01011: Could not create password.";
    protected String couldNotCreatePassword$str() {
        return couldNotCreatePassword;
    }
    @Override
    public final OperationFailedException couldNotCreatePassword(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotCreatePassword$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedPasswordType = "WFLYELY01012: Unexpected password type [%s].";
    protected String unexpectedPasswordType$str() {
        return unexpectedPasswordType;
    }
    @Override
    public final OperationFailedException unexpectedPasswordType(final String passwordType) {
        final OperationFailedException result = new OperationFailedException(String.format(unexpectedPasswordType$str(), passwordType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patternRequiresCaptureGroup = "WFLYELY01013: Pattern [%s] requires a capture group";
    protected String patternRequiresCaptureGroup$str() {
        return patternRequiresCaptureGroup;
    }
    @Override
    public final OperationFailedException patternRequiresCaptureGroup(final String pattern) {
        final OperationFailedException result = new OperationFailedException(String.format(patternRequiresCaptureGroup$str(), pattern));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDefinition = "WFLYELY01014: Invalid [%s] definition.";
    protected String invalidDefinition$str() {
        return invalidDefinition;
    }
    @Override
    public final OperationFailedException invalidDefinition(final String property) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidDefinition$str(), property));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToPerformOutflow = "WFLYELY01015: Unable to perform automatic outflow for '%s'";
    protected String unableToPerformOutflow$str() {
        return unableToPerformOutflow;
    }
    @Override
    public final IllegalStateException unableToPerformOutflow(final String identityName, final Exception cause) {
        final IllegalStateException result = new IllegalStateException(String.format(unableToPerformOutflow$str(), identityName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverNotKnown = "WFLYELY01016: Server '%s' not known";
    protected String serverNotKnown$str() {
        return serverNotKnown;
    }
    @Override
    public final OperationFailedException serverNotKnown(final String serverAddedd, final UnknownHostException e) {
        final OperationFailedException result = new OperationFailedException(String.format(serverNotKnown$str(), serverAddedd), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
