/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.KerberosSecurityFactoryDefinition;

class CredentialSecurityFactoryParser {
    CredentialSecurityFactoryParser() {
    }

    void readCredentialSecurityFactories(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "custom-credential-security-factory": {
                    ElytronSubsystemParser.readCustomComponent("custom-credential-security-factory", parentAddress, reader, operations);
                    continue block8;
                }
                case "kerberos-security-factory": {
                    this.readKerberosSecurityFactory(parentAddress, reader, operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readKerberosSecurityFactory(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "principal", "path", "mechanism-oids"));
        String name = null;
        int count = reader.getAttributeCount();
        block24: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block24;
                }
                case "principal": {
                    KerberosSecurityFactoryDefinition.PRINCIPAL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block24;
                }
                case "path": {
                    KerberosSecurityFactoryDefinition.PATH.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block24;
                }
                case "relative-to": {
                    FileAttributeDefinitions.RELATIVE_TO.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block24;
                }
                case "server": {
                    KerberosSecurityFactoryDefinition.SERVER.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block24;
                }
                case "obtain-kerberos-ticket": {
                    KerberosSecurityFactoryDefinition.OBTAIN_KERBEROS_TICKET.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block24;
                }
                case "minimum-remaining-lifetime": {
                    KerberosSecurityFactoryDefinition.MINIMUM_REMAINING_LIFETIME.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block24;
                }
                case "request-lifetime": {
                    KerberosSecurityFactoryDefinition.REQUEST_LIFETIME.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block24;
                }
                case "debug": {
                    KerberosSecurityFactoryDefinition.DEBUG.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block24;
                }
                case "mechanism-oids": {
                    for (String mechanismOid : reader.getListAttributeValue(i)) {
                        KerberosSecurityFactoryDefinition.MECHANISM_OIDS.parseAndAddParameterElement(mechanismOid, add, (XMLStreamReader)reader);
                    }
                    continue block24;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        add.get("address").set(parentAddress).add("kerberos-security-factory", name);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(add);
    }

    private void startCredentialSecurityFactories(boolean started, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!started) {
            writer.writeStartElement("credential-security-factories");
        }
    }

    private boolean writeCustomCredenitalSecurityFactories(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-credential-security-factory")) {
            this.startCredentialSecurityFactories(started, writer);
            ModelNode securityFactories = subsystem.require("custom-credential-security-factory");
            for (String name : securityFactories.keys()) {
                ModelNode factory = securityFactories.require(name);
                ElytronSubsystemParser.writeCustomComponent("custom-credential-security-factory", name, factory, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeKerberosSecurityFactories(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("kerberos-security-factory")) {
            this.startCredentialSecurityFactories(started, writer);
            ModelNode securityFactories = subsystem.require("kerberos-security-factory");
            for (String name : securityFactories.keys()) {
                writer.writeStartElement("kerberos-security-factory");
                writer.writeAttribute("name", name);
                ModelNode factory = securityFactories.require(name);
                KerberosSecurityFactoryDefinition.PRINCIPAL.marshallAsAttribute(factory, false, (XMLStreamWriter)writer);
                KerberosSecurityFactoryDefinition.PATH.marshallAsAttribute(factory, false, (XMLStreamWriter)writer);
                FileAttributeDefinitions.RELATIVE_TO.marshallAsAttribute(factory, false, (XMLStreamWriter)writer);
                KerberosSecurityFactoryDefinition.MINIMUM_REMAINING_LIFETIME.marshallAsAttribute(factory, false, (XMLStreamWriter)writer);
                KerberosSecurityFactoryDefinition.REQUEST_LIFETIME.marshallAsAttribute(factory, false, (XMLStreamWriter)writer);
                KerberosSecurityFactoryDefinition.SERVER.marshallAsAttribute(factory, false, (XMLStreamWriter)writer);
                KerberosSecurityFactoryDefinition.OBTAIN_KERBEROS_TICKET.marshallAsAttribute(factory, false, (XMLStreamWriter)writer);
                KerberosSecurityFactoryDefinition.DEBUG.marshallAsAttribute(factory, false, (XMLStreamWriter)writer);
                KerberosSecurityFactoryDefinition.MECHANISM_OIDS.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)KerberosSecurityFactoryDefinition.MECHANISM_OIDS, factory, false, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    void writeCredentialSecurityFactories(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        boolean credentialSecurityFactoriesStarted = false;
        credentialSecurityFactoriesStarted |= this.writeCustomCredenitalSecurityFactories(credentialSecurityFactoriesStarted, subsystem, writer);
        if (credentialSecurityFactoriesStarted |= this.writeKerberosSecurityFactories(credentialSecurityFactoriesStarted, subsystem, writer)) {
            writer.writeEndElement();
        }
    }
}

