/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.DomainService;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRestartParentWriteAttributeHandler;
import org.wildfly.extension.elytron.IdentityResourceDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities.PrincipalTransformer;
import org.wildfly.extension.elytron.capabilities.SecurityEventListener;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.manager.WildFlySecurityManager;

class DomainDefinition
extends SimpleResourceDefinition {
    private static final ServiceUtil<SecurityRealm> REALM_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, null, SecurityRealm.class);
    static final SimpleAttributeDefinition DEFAULT_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-realm", ModelType.STRING, false).setAllowExpression(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PRE_REALM_PRINCIPAL_TRANSFORMER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pre-realm-principal-transformer", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.principal-transformer", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition POST_REALM_PRINCIPAL_TRANSFORMER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("post-realm-principal-transformer", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.principal-transformer", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition PRINCIPAL_DECODER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal-decoder", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.principal-decoder", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition PERMISSION_MAPPER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("permission-mapper", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.permission-mapper", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition REALM_MAPPER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm-mapper", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.realm-mapper", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition ROLE_MAPPER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("role-mapper", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.role-mapper", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition REALM_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm", ModelType.STRING, false).setXmlName("name")).setMinSize(1)).setCapabilityReference("org.wildfly.security.security-realm", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition REALM_PRINCIPAL_TRANSFORMER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal-transformer", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.principal-transformer", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition REALM_ROLE_DECODER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("role-decoder", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.role-decoder", "org.wildfly.security.security-domain", true)).build();
    static final ObjectTypeAttributeDefinition REALM = new ObjectTypeAttributeDefinition.Builder("realm", new AttributeDefinition[]{REALM_NAME, REALM_PRINCIPAL_TRANSFORMER, REALM_ROLE_DECODER, ROLE_MAPPER}).setAllowNull(false).build();
    static final ObjectListAttributeDefinition REALMS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("realms", REALM).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final StringListAttributeDefinition TRUSTED_SECURITY_DOMAINS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("trusted-security-domains").setRequired(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition OUTFLOW_ANONYMOUS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("outflow-anonymous", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRequires(new String[]{"outflow-security-domains"})).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final StringListAttributeDefinition OUTFLOW_SECURITY_DOMAINS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("outflow-security-domains").setRequired(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.security.security-domain", true)).build();
    static final SimpleAttributeDefinition SECURITY_EVENT_LISTENER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-event-listener", ModelType.STRING, true).setAllowExpression(false)).setCapabilityReference("org.wildfly.security.security-event-listener", "org.wildfly.security.security-domain", true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PRE_REALM_PRINCIPAL_TRANSFORMER, POST_REALM_PRINCIPAL_TRANSFORMER, PRINCIPAL_DECODER, REALM_MAPPER, ROLE_MAPPER, PERMISSION_MAPPER, DEFAULT_REALM, REALMS, TRUSTED_SECURITY_DOMAINS, OUTFLOW_ANONYMOUS, OUTFLOW_SECURITY_DOMAINS, SECURITY_EVENT_LISTENER};
    private static final DomainAddHandler ADD = new DomainAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY);
    private static final WriteAttributeHandler WRITE = new WriteAttributeHandler("security-domain");

    DomainDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"security-domain"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("security-domain")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)WRITE);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        this.registerIdentityManagementOperations(resourceRegistration);
    }

    private void registerIdentityManagementOperations(ManagementResourceRegistration resourceRegistration) {
        IdentityResourceDefinition.ReadSecurityDomainIdentityHandler.register(resourceRegistration, this.getResourceDescriptionResolver());
        IdentityResourceDefinition.AuthenticatorOperationHandler.register(resourceRegistration, this.getResourceDescriptionResolver());
    }

    private static ServiceController<SecurityDomain> installInitialService(OperationContext context, ServiceName initialName, ModelNode model, Predicate<SecurityDomain> trustedSecurityDomain, UnaryOperator<SecurityIdentity> identityOperator) throws OperationFailedException {
        String runtimeCapability;
        ServiceTarget serviceTarget = context.getServiceTarget();
        String defaultRealm = DEFAULT_REALM.resolveModelAttribute(context, model).asString();
        List realms = REALMS.resolveModelAttribute(context, model).asList();
        String preRealmPrincipalTransformer = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PRE_REALM_PRINCIPAL_TRANSFORMER, model);
        String postRealmPrincipalTransformer = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)POST_REALM_PRINCIPAL_TRANSFORMER, model);
        String principalDecoder = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PRINCIPAL_DECODER, model);
        String permissionMapper = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PERMISSION_MAPPER, model);
        String realmMapper = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)REALM_MAPPER, model);
        String roleMapper = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ROLE_MAPPER, model);
        String securityEventListener = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)SECURITY_EVENT_LISTENER, model);
        DomainService domain = new DomainService(defaultRealm, trustedSecurityDomain, identityOperator);
        ServiceBuilder domainBuilder = serviceTarget.addService(initialName, (Service)domain).setInitialMode(ServiceController.Mode.ACTIVE);
        if (preRealmPrincipalTransformer != null) {
            DomainDefinition.injectPrincipalTransformer(preRealmPrincipalTransformer, context, (ServiceBuilder<SecurityDomain>)domainBuilder, domain.createPreRealmPrincipalTransformerInjector(preRealmPrincipalTransformer));
        }
        if (postRealmPrincipalTransformer != null) {
            DomainDefinition.injectPrincipalTransformer(postRealmPrincipalTransformer, context, (ServiceBuilder<SecurityDomain>)domainBuilder, domain.createPostRealmPrincipalTransformerInjector(postRealmPrincipalTransformer));
        }
        if (principalDecoder != null) {
            runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.principal-decoder", (String)principalDecoder);
            ServiceName principalDecoderServiceName = context.getCapabilityServiceName(runtimeCapability, PrincipalDecoder.class);
            domainBuilder.addDependency(principalDecoderServiceName, PrincipalDecoder.class, domain.getPrincipalDecoderInjector());
        }
        if (permissionMapper != null) {
            runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.permission-mapper", (String)permissionMapper);
            ServiceName permissionMapperServiceName = context.getCapabilityServiceName(runtimeCapability, PermissionMapper.class);
            domainBuilder.addDependency(permissionMapperServiceName, PermissionMapper.class, domain.getPermissionMapperInjector());
        }
        if (realmMapper != null) {
            runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.realm-mapper", (String)realmMapper);
            ServiceName realmMapperServiceName = context.getCapabilityServiceName(runtimeCapability, RealmMapper.class);
            domainBuilder.addDependency(realmMapperServiceName, RealmMapper.class, domain.getRealmMapperInjector());
        }
        if (roleMapper != null) {
            DomainDefinition.injectRoleMapper(roleMapper, context, (ServiceBuilder<SecurityDomain>)domainBuilder, domain.createDomainRoleMapperInjector(roleMapper));
        }
        if (securityEventListener != null) {
            domainBuilder.addDependency(context.getCapabilityServiceName("org.wildfly.security.security-event-listener", securityEventListener, SecurityEventListener.class), SecurityEventListener.class, domain.getSecurityEventListenerInjector());
        }
        for (ModelNode current : realms) {
            String realmRoleDecoder;
            String realmRoleMapper;
            String realmName = REALM_NAME.resolveModelAttribute(context, current).asString();
            String runtimeCapability2 = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.security-realm", (String)realmName);
            ServiceName realmServiceName = context.getCapabilityServiceName(runtimeCapability2, SecurityRealm.class);
            DomainService.RealmDependency realmDependency = domain.createRealmDependency(realmName);
            REALM_SERVICE_UTIL.addInjection(domainBuilder, realmDependency.getSecurityRealmInjector(), realmServiceName);
            String principalStranformer = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)REALM_PRINCIPAL_TRANSFORMER, current);
            if (principalStranformer != null) {
                Injector<PrincipalTransformer> principalTransformerInjector = realmDependency.getPrincipalTransformerInjector(principalStranformer);
                DomainDefinition.injectPrincipalTransformer(principalStranformer, context, (ServiceBuilder<SecurityDomain>)domainBuilder, principalTransformerInjector);
            }
            if ((realmRoleMapper = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ROLE_MAPPER, current)) != null) {
                DomainDefinition.injectRoleMapper(realmRoleMapper, context, (ServiceBuilder<SecurityDomain>)domainBuilder, realmDependency.getRoleMapperInjector(realmRoleMapper));
            }
            if ((realmRoleDecoder = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)REALM_ROLE_DECODER, current)) == null) continue;
            DomainDefinition.injectRoleDecoder(realmRoleDecoder, context, (ServiceBuilder<SecurityDomain>)domainBuilder, realmDependency.getRoleDecoderInjector(realmRoleDecoder));
        }
        ElytronDefinition.commonDependencies(domainBuilder);
        return domainBuilder.install();
    }

    private static ServiceController<SecurityDomain> installService(OperationContext context, ServiceName domainName, ModelNode model) throws OperationFailedException {
        ServiceName initialName = domainName.append(new String[]{"initial"});
        final InjectedValue securityDomain = new InjectedValue();
        List trustedSecurityDomainNames = TRUSTED_SECURITY_DOMAINS.unwrap((ExpressionResolver)context, model);
        final ArrayList<InjectedValue> trustedSecurityDomainInjectors = new ArrayList<InjectedValue>(trustedSecurityDomainNames.size());
        final HashSet trustedSecurityDomains = new HashSet();
        List outflowSecurityDomainNames = OUTFLOW_SECURITY_DOMAINS.unwrap((ExpressionResolver)context, model);
        boolean outflowAnonymous = OUTFLOW_ANONYMOUS.resolveModelAttribute(context, model).asBoolean();
        final ArrayList<InjectedValue> outflowSecurityDomainInjectors = new ArrayList<InjectedValue>(outflowSecurityDomainNames.size());
        final HashSet outflowSecurityDomains = new HashSet();
        DomainDefinition.installInitialService(context, initialName, model, trustedSecurityDomains::contains, outflowSecurityDomainNames.size() > 0 ? i -> DomainDefinition.outflow(i, outflowAnonymous, outflowSecurityDomains) : UnaryOperator.identity());
        TrivialService<SecurityDomain> finalDomainService = new TrivialService<SecurityDomain>();
        finalDomainService.setValueSupplier(new TrivialService.ValueSupplier<SecurityDomain>(){

            @Override
            public SecurityDomain get() throws StartException {
                trustedSecurityDomainInjectors.forEach(i -> trustedSecurityDomains.add(i.getValue()));
                outflowSecurityDomainInjectors.forEach(i -> outflowSecurityDomains.add(i.getValue()));
                return (SecurityDomain)securityDomain.getValue();
            }

            @Override
            public void dispose() {
                trustedSecurityDomains.clear();
            }
        });
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceBuilder domainBuilder = serviceTarget.addService(domainName, finalDomainService).setInitialMode(ServiceController.Mode.ACTIVE);
        domainBuilder.addDependency(initialName, SecurityDomain.class, (Injector)securityDomain);
        for (String trustedDomainName : trustedSecurityDomainNames) {
            InjectedValue trustedDomainInjector = new InjectedValue();
            domainBuilder.addDependency(context.getCapabilityServiceName("org.wildfly.security.security-domain", trustedDomainName, SecurityDomain.class).append(new String[]{"initial"}), SecurityDomain.class, (Injector)trustedDomainInjector);
            trustedSecurityDomainInjectors.add(trustedDomainInjector);
        }
        for (String outflowDomainName : outflowSecurityDomainNames) {
            InjectedValue outflowDomainInjector = new InjectedValue();
            domainBuilder.addDependency(context.getCapabilityServiceName("org.wildfly.security.security-domain", outflowDomainName, SecurityDomain.class).append(new String[]{"initial"}), SecurityDomain.class, (Injector)outflowDomainInjector);
            outflowSecurityDomainInjectors.add(outflowDomainInjector);
        }
        return domainBuilder.install();
    }

    private static SecurityIdentity outflow(final SecurityIdentity identity, final boolean outflowAnonymous, final Set<SecurityDomain> outflowDomains) {
        return identity.withSecurityIdentitySupplier((Supplier)new Supplier<SecurityIdentity[]>(){
            private volatile SecurityIdentity[] outflowIdentities = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SecurityIdentity[] get() {
                SecurityIdentity[] outflowIdentities = this.outflowIdentities;
                if (outflowIdentities != null) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        outflowIdentities = this.outflowIdentities;
                        if (outflowIdentities == null) {
                            outflowIdentities = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(() -> DomainDefinition.performOutflow(identity, outflowAnonymous, outflowDomains)) : DomainDefinition.performOutflow(identity, outflowAnonymous, outflowDomains);
                            this.outflowIdentities = outflowIdentities;
                        }
                    }
                }
                return outflowIdentities;
            }
        });
    }

    private static SecurityIdentity[] performOutflow(SecurityIdentity identity, boolean outflowAnonymous, Set<SecurityDomain> outflowDomains) {
        ArrayList outflowIdentities = new ArrayList(outflowDomains.size());
        outflowDomains.forEach(d -> {
            ServerAuthenticationContext sac = d.createNewAuthenticationContext();
            try {
                if (sac.importIdentity(identity)) {
                    outflowIdentities.add(sac.getAuthorizedIdentity());
                } else if (outflowAnonymous) {
                    outflowIdentities.add(d.getAnonymousSecurityIdentity());
                }
            }
            catch (RealmUnavailableException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToPerformOutflow(identity.getPrincipal().getName(), (Exception)((Object)e));
            }
        });
        return outflowIdentities.toArray(new SecurityIdentity[outflowIdentities.size()]);
    }

    private static void injectPrincipalTransformer(String principalTransformer, OperationContext context, ServiceBuilder<SecurityDomain> domainBuilder, Injector<PrincipalTransformer> injector) {
        if (principalTransformer == null) {
            return;
        }
        if (injector == null) {
            return;
        }
        String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.principal-transformer", (String)principalTransformer);
        ServiceName principalTransformerServiceName = context.getCapabilityServiceName(runtimeCapability, PrincipalTransformer.class);
        domainBuilder.addDependency(principalTransformerServiceName, PrincipalTransformer.class, injector);
    }

    private static void injectRoleMapper(String roleMapper, OperationContext context, ServiceBuilder<SecurityDomain> domainBuilder, Injector<RoleMapper> injector) {
        if (roleMapper == null) {
            return;
        }
        if (injector == null) {
            return;
        }
        String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.role-mapper", (String)roleMapper);
        ServiceName roleMapperServiceName = context.getCapabilityServiceName(runtimeCapability, RoleMapper.class);
        domainBuilder.addDependency(roleMapperServiceName, RoleMapper.class, injector);
    }

    private static void injectRoleDecoder(String roleDecoder, OperationContext context, ServiceBuilder<SecurityDomain> domainBuilder, Injector<RoleDecoder> injector) {
        if (roleDecoder == null) {
            return;
        }
        if (injector == null) {
            return;
        }
        String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.role-decoder", (String)roleDecoder);
        ServiceName roleDecoderServiceName = context.getCapabilityServiceName(runtimeCapability, RoleDecoder.class);
        domainBuilder.addDependency(roleDecoderServiceName, RoleDecoder.class, injector);
    }

    private static void validateDefaultRealmInRealms(OperationContext context, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        String defaultRealm = DEFAULT_REALM.resolveModelAttribute(context, model).asString();
        List realms = REALMS.resolveModelAttribute(context, model).asList();
        for (ModelNode realm : realms) {
            String realmName = REALM_NAME.resolveModelAttribute(context, realm).asString();
            if (!defaultRealm.equals(realmName)) continue;
            return;
        }
        StringBuilder realmsStringBuilder = new StringBuilder();
        for (ModelNode realm : realms) {
            if (realmsStringBuilder.length() != 0) {
                realmsStringBuilder.append(", ");
            }
            realmsStringBuilder.append(REALM_NAME.resolveModelAttribute(context, realm).asString());
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.defaultRealmNotReferenced(defaultRealm, realmsStringBuilder.toString());
    }

    private static class WriteAttributeHandler
    extends ElytronRestartParentWriteAttributeHandler {
        WriteAttributeHandler(String parentKeyName) {
            super(parentKeyName, ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(SecurityDomain.class);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            DomainDefinition.installService(context, this.getParentServiceName(parentAddress), parentModel);
        }

        protected void validateUpdatedModel(OperationContext context, Resource resource) throws OperationFailedException {
            DomainDefinition.validateDefaultRealmInRealms(context, resource);
        }
    }

    private static class DomainAddHandler
    extends BaseAddHandler {
        private DomainAddHandler() {
            super(Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            DomainDefinition.validateDefaultRealmInRealms(context, resource);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName domainName = runtimeCapability.getCapabilityServiceName(SecurityDomain.class);
            DomainDefinition.installService(context, domainName, model);
        }
    }
}

