/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities.PrincipalTransformer;
import org.wildfly.extension.elytron.capabilities.SecurityEventListener;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.RoleMapper;

class DomainService
implements Service<SecurityDomain> {
    private volatile SecurityDomain securityDomain;
    private final String defaultRealm;
    private final Predicate<SecurityDomain> trustedSecurityDomain;
    private final UnaryOperator<SecurityIdentity> identityOperator;
    private String preRealmPrincipalTransformer;
    private String postRealmPrincipalTransformer;
    private String roleMapper;
    private final Map<String, RealmDependency> realms = new HashMap<String, RealmDependency>();
    private final Map<String, InjectedValue<PrincipalTransformer>> principalTransformers = new HashMap<String, InjectedValue<PrincipalTransformer>>();
    private final Map<String, InjectedValue<RoleMapper>> roleMappers = new HashMap<String, InjectedValue<RoleMapper>>();
    private final Map<String, InjectedValue<RoleDecoder>> roleDecoders = new HashMap<String, InjectedValue<RoleDecoder>>();
    private final InjectedValue<PrincipalDecoder> principalDecoderInjector = new InjectedValue();
    private final InjectedValue<RealmMapper> realmMapperInjector = new InjectedValue();
    private final InjectedValue<PermissionMapper> permissionMapperInjector = new InjectedValue();
    private final InjectedValue<SecurityEventListener> securityEventListenerInjector = new InjectedValue();

    DomainService(String defaultRealm, Predicate<SecurityDomain> trustedSecurityDomain, UnaryOperator<SecurityIdentity> identityOperator) {
        this.defaultRealm = defaultRealm;
        this.trustedSecurityDomain = trustedSecurityDomain;
        this.identityOperator = identityOperator;
    }

    RealmDependency createRealmDependency(String realmName) throws OperationFailedException {
        if (this.realms.containsKey(realmName)) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.duplicateRealmInjection(realmName);
        }
        RealmDependency realmDependency = new RealmDependency();
        this.realms.put(realmName, realmDependency);
        return realmDependency;
    }

    private Injector<PrincipalTransformer> createPrincipalTransformerInjector(String principalTransformerName) {
        if (this.principalTransformers.containsKey(principalTransformerName)) {
            return null;
        }
        InjectedValue principalTransformerInjector = new InjectedValue();
        this.principalTransformers.put(principalTransformerName, (InjectedValue<PrincipalTransformer>)principalTransformerInjector);
        return principalTransformerInjector;
    }

    private Injector<RoleMapper> createRoleMapperInjector(String roleMapperName) {
        if (this.roleMappers.containsKey(roleMapperName)) {
            return null;
        }
        InjectedValue roleMapperInjector = new InjectedValue();
        this.roleMappers.put(roleMapperName, (InjectedValue<RoleMapper>)roleMapperInjector);
        return roleMapperInjector;
    }

    private Injector<RoleDecoder> createRoleDecoderInjector(String roleDecoderName) {
        if (this.roleDecoders.containsKey(roleDecoderName)) {
            return null;
        }
        InjectedValue roleDecoderInjector = new InjectedValue();
        this.roleDecoders.put(roleDecoderName, (InjectedValue<RoleDecoder>)roleDecoderInjector);
        return roleDecoderInjector;
    }

    Injector<PrincipalDecoder> getPrincipalDecoderInjector() {
        return this.principalDecoderInjector;
    }

    Injector<RealmMapper> getRealmMapperInjector() {
        return this.realmMapperInjector;
    }

    Injector<PermissionMapper> getPermissionMapperInjector() {
        return this.permissionMapperInjector;
    }

    Injector<PrincipalTransformer> createPreRealmPrincipalTransformerInjector(String name) {
        this.preRealmPrincipalTransformer = name;
        return this.createPrincipalTransformerInjector(name);
    }

    Injector<PrincipalTransformer> createPostRealmPrincipalTransformerInjector(String name) {
        this.postRealmPrincipalTransformer = name;
        return this.createPrincipalTransformerInjector(name);
    }

    Injector<RoleMapper> createDomainRoleMapperInjector(String name) {
        this.roleMapper = name;
        return this.createRoleMapperInjector(name);
    }

    Injector<SecurityEventListener> getSecurityEventListenerInjector() {
        return this.securityEventListenerInjector;
    }

    public void start(StartContext context) throws StartException {
        PermissionMapper permissionMapper;
        RealmMapper realmMapper;
        PrincipalDecoder principalDecoder;
        SecurityDomain.Builder builder = SecurityDomain.builder();
        if (this.preRealmPrincipalTransformer != null) {
            builder.setPreRealmRewriter((Function)this.principalTransformers.get(this.preRealmPrincipalTransformer).getValue());
        }
        if (this.postRealmPrincipalTransformer != null) {
            builder.setPostRealmRewriter((Function)this.principalTransformers.get(this.postRealmPrincipalTransformer).getValue());
        }
        if ((principalDecoder = (PrincipalDecoder)this.principalDecoderInjector.getOptionalValue()) != null) {
            builder.setPrincipalDecoder(PrincipalDecoder.aggregate((PrincipalDecoder[])new PrincipalDecoder[]{principalDecoder, PrincipalDecoder.DEFAULT}));
        }
        if ((realmMapper = (RealmMapper)this.realmMapperInjector.getOptionalValue()) != null) {
            builder.setRealmMapper(realmMapper);
        }
        if ((permissionMapper = (PermissionMapper)this.permissionMapperInjector.getOptionalValue()) != null) {
            builder.setPermissionMapper(permissionMapper);
        }
        if (this.roleMapper != null) {
            builder.setRoleMapper((RoleMapper)this.roleMappers.get(this.roleMapper).getValue());
        }
        builder.setDefaultRealmName(this.defaultRealm);
        for (Map.Entry<String, RealmDependency> entry : this.realms.entrySet()) {
            RoleDecoder roleDecoder;
            String realmName = entry.getKey();
            RealmDependency realmDependency = entry.getValue();
            SecurityDomain.RealmBuilder realmBuilder = builder.addRealm(realmName, (SecurityRealm)realmDependency.securityRealmInjector.getValue());
            if (realmDependency.principalTransformer != null) {
                realmBuilder.setPrincipalRewriter((Function)this.principalTransformers.get(realmDependency.principalTransformer).getValue());
            }
            if (realmDependency.roleDecoder != null && (roleDecoder = (RoleDecoder)this.roleDecoders.get(realmDependency.roleDecoder).getOptionalValue()) != null) {
                realmBuilder.setRoleDecoder(roleDecoder);
            }
            if (realmDependency.roleMapper != null) {
                realmBuilder.setRoleMapper((RoleMapper)this.roleMappers.get(realmDependency.roleMapper).getValue());
            }
            realmBuilder.build();
        }
        builder.setTrustedSecurityDomainPredicate(this.trustedSecurityDomain);
        builder.setSecurityIdentityTransformer(this.identityOperator);
        SecurityEventListener securityEventListener = (SecurityEventListener)this.securityEventListenerInjector.getOptionalValue();
        if (securityEventListener != null) {
            builder.setSecurityEventListener((Consumer)securityEventListener);
        }
        this.securityDomain = builder.build();
    }

    public void stop(StopContext context) {
        this.securityDomain = null;
    }

    public SecurityDomain getValue() throws IllegalStateException, IllegalArgumentException {
        return this.securityDomain;
    }

    class RealmDependency {
        private InjectedValue<SecurityRealm> securityRealmInjector = new InjectedValue();
        private String principalTransformer;
        private String roleMapper;
        private String roleDecoder;

        RealmDependency() {
        }

        Injector<SecurityRealm> getSecurityRealmInjector() {
            return this.securityRealmInjector;
        }

        Injector<PrincipalTransformer> getPrincipalTransformerInjector(String name) {
            this.principalTransformer = name;
            return DomainService.this.createPrincipalTransformerInjector(name);
        }

        Injector<RoleDecoder> getRoleDecoderInjector(String name) {
            this.roleDecoder = name;
            return DomainService.this.createRoleDecoderInjector(name);
        }

        Injector<RoleMapper> getRoleMapperInjector(String name) {
            this.roleMapper = name;
            return DomainService.this.createRoleMapperInjector(name);
        }
    }
}

