/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.SSLContextResource;
import org.wildfly.extension.elytron.SSLSessionDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.keystore.AliasFilter;
import org.wildfly.security.keystore.FilteringKeyStore;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.Protocol;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.ssl.X509CRLExtendedTrustManager;

class SSLDefinitions {
    static final ServiceUtil<SSLContext> SERVER_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY, "server-ssl-context", SSLContext.class);
    static final ServiceUtil<SSLContext> CLIENT_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY, "client-ssl-context", SSLContext.class);
    static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PROVIDER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-name", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("providers", ModelType.STRING, true).setAllowExpression(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition KEYSTORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-store", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition ALIAS_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias-filter", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.security.ssl-context", true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CIPHER_SUITE_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cipher-suite-filter", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final String[] ALLOWED_PROTOCOLS = new String[]{"SSLv2", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
    static final StringListAttributeDefinition PROTOCOLS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("protocols").setAllowExpression(true)).setMinSize(1)).setRequired(false)).setAllowedValues(ALLOWED_PROTOCOLS)).setValidator((ParameterValidator)new StringValuesValidator(ALLOWED_PROTOCOLS))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition WANT_CLIENT_AUTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("want-client-auth", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition NEED_CLIENT_AUTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("need-client-auth", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition AUTHENTICATION_OPTIONAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-optional", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition USE_CIPHER_SUITES_ORDER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-cipher-suites-order", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MAXIMUM_SESSION_CACHE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("maximum-session-cache-size", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(0))).setValidator((ParameterValidator)new IntRangeValidator(0))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition SESSION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-timeout", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(0))).setValidator((ParameterValidator)new IntRangeValidator(0))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition KEY_MANAGERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-managers", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.key-managers", "org.wildfly.security.ssl-context", true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAllowExpression(false)).build();
    static final SimpleAttributeDefinition TRUST_MANAGERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("trust-managers", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.trust-managers", "org.wildfly.security.ssl-context", true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAllowExpression(false)).build();
    static final SimpleAttributeDefinition MAXIMUM_CERT_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("maximum-cert-path", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(5))).setValidator((ParameterValidator)new IntRangeValidator(1))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final ObjectTypeAttributeDefinition CERTIFICATE_REVOCATION_LIST = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("certificate-revocation-list", new AttributeDefinition[]{FileAttributeDefinitions.PATH, FileAttributeDefinitions.RELATIVE_TO, MAXIMUM_CERT_PATH}).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    private static SimpleAttributeDefinition ACTIVE_SESSION_COUNT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("active-session-count", ModelType.INT).setStorageRuntime()).build();

    SSLDefinitions() {
    }

    static ResourceDefinition getKeyManagerDefinition() {
        final SimpleAttributeDefinition providersDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDERS).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.key-managers", true)).setAllowExpression(false)).build();
        final SimpleAttributeDefinition keystoreDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(KEYSTORE).setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.key-managers", true)).setAllowExpression(false)).build();
        final ObjectTypeAttributeDefinition credentialReferenceDefinition = ((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder((String)"credential-reference", (String)"credential-reference", (boolean)false).setCapabilityReference("org.wildfly.security.credential-store")).build();
        AttributeDefinition[] attributes = new AttributeDefinition[]{ALGORITHM, providersDefinition, PROVIDER_NAME, keystoreDefinition, ALIAS_FILTER, credentialReferenceDefinition};
        TrivialAddHandler<KeyManager[]> add = new TrivialAddHandler<KeyManager[]>(KeyManager[].class, attributes, new RuntimeCapability[]{Capabilities.KEY_MANAGERS_RUNTIME_CAPABILITY, Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<KeyManager[]> getValueSupplier(ServiceBuilder<KeyManager[]> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String algorithm = ALGORITHM.resolveModelAttribute(context, model).asString();
                String providerName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PROVIDER_NAME, model);
                String providersName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)providersDefinition, model);
                InjectedValue providersInjector = new InjectedValue();
                if (providersName != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providersName), Provider[].class), Provider[].class, (Injector)providersInjector);
                }
                String keyStoreName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)keystoreDefinition, model);
                InjectedValue keyStoreInjector = new InjectedValue();
                if (keyStoreName != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)keyStoreName), KeyStore.class), KeyStore.class, (Injector)keyStoreInjector);
                }
                String aliasFilter = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ALIAS_FILTER, model);
                ExceptionSupplier credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)credentialReferenceDefinition, (ModelNode)model, serviceBuilder);
                return () -> {
                    Object[] providers = (Provider[])providersInjector.getOptionalValue();
                    KeyManagerFactory keyManagerFactory = null;
                    if (providers != null) {
                        for (Provider provider : providers) {
                            if (providerName != null && !providerName.equals(provider.getName())) continue;
                            try {
                                keyManagerFactory = KeyManagerFactory.getInstance(algorithm, provider);
                                break;
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                // empty catch block
                            }
                        }
                        if (keyManagerFactory == null) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCreateManagerFactory(KeyManagerFactory.class.getSimpleName(), algorithm);
                        }
                    } else {
                        try {
                            keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new StartException((Throwable)e);
                        }
                    }
                    try {
                        CredentialSource cs = (CredentialSource)credentialSourceSupplier.get();
                        if (cs == null) {
                            throw new StartException((Throwable)ElytronSubsystemMessages.ROOT_LOGGER.keyStorePasswordCannotBeResolved(keyStoreName));
                        }
                        char[] password = ((ClearPassword)((PasswordCredential)cs.getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword();
                        KeyStore keyStore = (KeyStore)keyStoreInjector.getOptionalValue();
                        if (aliasFilter != null) {
                            keyStore = FilteringKeyStore.filteringKeyStore((KeyStore)keyStore, (Predicate)AliasFilter.fromString((String)aliasFilter));
                        }
                        if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                            ElytronSubsystemMessages.ROOT_LOGGER.tracef("KeyManager supplying:  providers = %s  provider = %s  algorithm = %s  keyManagerFactory = %s  keyStoreName = %s  aliasFilter = %s  keyStore = %s  keyStoreSize = %d  password (of item) = %b", new Object[]{Arrays.toString(providers), providerName, algorithm, keyManagerFactory, keyStoreName, aliasFilter, keyStore, keyStore.size(), password != null});
                        }
                        keyManagerFactory.init(keyStore, password);
                    }
                    catch (StartException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new StartException((Throwable)e);
                    }
                    return keyManagerFactory.getKeyManagers();
                };
            }
        };
        return new TrivialResourceDefinition("key-managers", add, attributes, Capabilities.KEY_MANAGERS_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getTrustManagerDefinition() {
        final SimpleAttributeDefinition providersDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDERS).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.trust-managers", true)).setAllowExpression(false)).build();
        final SimpleAttributeDefinition keystoreDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(KEYSTORE).setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.trust-managers", true)).setAllowExpression(false)).build();
        AttributeDefinition[] attributes = new AttributeDefinition[]{ALGORITHM, providersDefinition, PROVIDER_NAME, keystoreDefinition, ALIAS_FILTER, CERTIFICATE_REVOCATION_LIST};
        final AtomicBoolean reloadCrl = new AtomicBoolean(false);
        TrivialAddHandler<TrustManager[]> add = new TrivialAddHandler<TrustManager[]>(TrustManager[].class, attributes, new RuntimeCapability[]{Capabilities.TRUST_MANAGERS_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<TrustManager[]> getValueSupplier(ServiceBuilder<TrustManager[]> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String algorithm = ALGORITHM.resolveModelAttribute(context, model).asString();
                String providerName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PROVIDER_NAME, model);
                String providerLoader = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)providersDefinition, model);
                InjectedValue providersInjector = new InjectedValue();
                if (providerLoader != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providerLoader), Provider[].class), Provider[].class, (Injector)providersInjector);
                }
                String keyStoreName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)keystoreDefinition, model);
                InjectedValue keyStoreInjector = new InjectedValue();
                if (keyStoreName != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)keyStoreName), KeyStore.class), KeyStore.class, (Injector)keyStoreInjector);
                }
                String aliasFilter = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ALIAS_FILTER, model);
                ModelNode crlNode = CERTIFICATE_REVOCATION_LIST.resolveModelAttribute(context, model);
                if (crlNode.isDefined()) {
                    return this.createX509CRLExtendedTrustManager(serviceBuilder, context, algorithm, providerName, (InjectedValue<Provider[]>)providersInjector, (InjectedValue<KeyStore>)keyStoreInjector, crlNode, reloadCrl);
                }
                return () -> {
                    Object[] providers = (Provider[])providersInjector.getOptionalValue();
                    TrustManagerFactory trustManagerFactory = this.createTrustManagerFactory((Provider[])providers, providerName, algorithm);
                    KeyStore keyStore = (KeyStore)keyStoreInjector.getOptionalValue();
                    try {
                        if (aliasFilter != null) {
                            keyStore = FilteringKeyStore.filteringKeyStore((KeyStore)keyStore, (Predicate)AliasFilter.fromString((String)aliasFilter));
                        }
                        if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                            ElytronSubsystemMessages.ROOT_LOGGER.tracef("TrustManager supplying:  providers = %s  provider = %s  algorithm = %s  trustManagerFactory = %s  keyStoreName = %s  keyStore = %s  aliasFilter = %s  keyStoreSize = %d", new Object[]{Arrays.toString(providers), providerName, algorithm, trustManagerFactory, keyStoreName, keyStore, aliasFilter, keyStore.size()});
                        }
                        trustManagerFactory.init((KeyStore)keyStoreInjector.getOptionalValue());
                    }
                    catch (Exception e) {
                        throw new StartException((Throwable)e);
                    }
                    return trustManagerFactory.getTrustManagers();
                };
            }

            private TrivialService.ValueSupplier<TrustManager[]> createX509CRLExtendedTrustManager(ServiceBuilder<TrustManager[]> serviceBuilder, OperationContext context, String algorithm, String providerName, InjectedValue<Provider[]> providersInjector, InjectedValue<KeyStore> keyStoreInjector, ModelNode crlNode, AtomicBoolean reloadCrl2) throws OperationFailedException {
                String crlPath = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.PATH, crlNode);
                String crlRelativeTo = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.RELATIVE_TO, crlNode);
                int certPath = ElytronExtension.asIntIfDefined(context, MAXIMUM_CERT_PATH, crlNode);
                InjectedValue pathManagerInjector = new InjectedValue();
                if (crlPath != null && crlRelativeTo != null) {
                    serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManagerInjector);
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(crlRelativeTo));
                }
                return () -> {
                    TrustManagerFactory trustManagerFactory = this.createTrustManagerFactory((Provider[])providersInjector.getOptionalValue(), providerName, algorithm);
                    KeyStore keyStore = (KeyStore)keyStoreInjector.getOptionalValue();
                    if (crlPath != null) {
                        try {
                            X509CRLExtendedTrustManager trustManager = new X509CRLExtendedTrustManager(keyStore, trustManagerFactory, (InputStream)new FileInputStream(this.resolveFileLocation(crlPath, crlRelativeTo, (InjectedValue<PathManager>)pathManagerInjector)), certPath, null);
                            return this.createReloadableX509CRLTrustManager(reloadCrl2, crlPath, crlRelativeTo, certPath, (InjectedValue<PathManager>)pathManagerInjector, trustManagerFactory, keyStore, trustManager);
                        }
                        catch (FileNotFoundException e) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToAccessCRL(e);
                        }
                    }
                    return new TrustManager[]{new X509CRLExtendedTrustManager(keyStore, trustManagerFactory, null, certPath, null)};
                };
            }

            private TrustManager[] createReloadableX509CRLTrustManager(final AtomicBoolean reloadCrl2, final String crlPath, final String crlRelativeTo, final int certPath, final InjectedValue<PathManager> pathManagerInjector, final TrustManagerFactory trustManagerFactory, final KeyStore keyStore, final X509CRLExtendedTrustManager trustManager) {
                return new TrustManager[]{new X509ExtendedTrustManager(){
                    private volatile X509ExtendedTrustManager delegate;
                    private AtomicBoolean reloading;
                    {
                        this.delegate = trustManager;
                        this.reloading = new AtomicBoolean();
                    }

                    private X509ExtendedTrustManager getDelegate() {
                        if (reloadCrl2.get() && this.reloading.compareAndSet(false, true)) {
                            X509CRLExtendedTrustManager reloaded = null;
                            try {
                                reloaded = new X509CRLExtendedTrustManager(keyStore, trustManagerFactory, (InputStream)new FileInputStream(this.resolveFileLocation(crlPath, crlRelativeTo, (InjectedValue<PathManager>)pathManagerInjector)), certPath, null);
                            }
                            catch (FileNotFoundException cause) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToReloadCRL(cause);
                            }
                            finally {
                                if (reloaded != null) {
                                    this.delegate = reloaded;
                                }
                                reloadCrl2.lazySet(false);
                                this.reloading.lazySet(false);
                            }
                        }
                        return this.delegate;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
                        this.getDelegate().checkClientTrusted(x509Certificates, s, socket);
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
                        this.getDelegate().checkServerTrusted(x509Certificates, s, socket);
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
                        this.getDelegate().checkClientTrusted(x509Certificates, s, sslEngine);
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
                        this.getDelegate().checkServerTrusted(x509Certificates, s, sslEngine);
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        this.getDelegate().checkClientTrusted(x509Certificates, s);
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        this.getDelegate().checkServerTrusted(x509Certificates, s);
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return this.getDelegate().getAcceptedIssuers();
                    }
                }};
            }

            private File resolveFileLocation(String path, String relativeTo, InjectedValue<PathManager> pathManagerInjector) {
                File resolvedPath;
                if (relativeTo != null) {
                    PathManager pathManager = (PathManager)pathManagerInjector.getValue();
                    resolvedPath = new File(pathManager.resolveRelativePathEntry(path, relativeTo));
                } else {
                    resolvedPath = new File(path);
                }
                return resolvedPath;
            }

            private TrustManagerFactory createTrustManagerFactory(Provider[] providers, String providerName, String algorithm) throws StartException {
                Object trustManagerFactory = null;
                if (providers != null) {
                    for (Provider current : providers) {
                        if (providerName != null && !providerName.equals(current.getName())) continue;
                        try {
                            return TrustManagerFactory.getInstance(algorithm, current);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            // empty catch block
                        }
                    }
                    if (trustManagerFactory == null) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCreateManagerFactory(TrustManagerFactory.class.getSimpleName(), algorithm);
                    }
                }
                try {
                    return TrustManagerFactory.getInstance(algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new StartException((Throwable)e);
                }
            }
        };
        return new TrivialResourceDefinition("trust-managers", (AbstractAddStepHandler)add, attributes, new RuntimeCapability[]{Capabilities.TRUST_MANAGERS_RUNTIME_CAPABILITY, Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY}){

            public void registerOperations(ManagementResourceRegistration resourceRegistration) {
                super.registerOperations(resourceRegistration);
                resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition("reload-certificate-revocation-list", this.getResourceDescriptionResolver()), (OperationStepHandler)new ReloadCertificateRevocationList());
            }

            class ReloadCertificateRevocationList
            implements OperationStepHandler {
                ReloadCertificateRevocationList() {
                }

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.addStep(operation, (parentContext, parentOperation) -> reloadCrl.compareAndSet(false, true), OperationContext.Stage.RUNTIME);
                }
            }
        };
    }

    private static <T> InjectedValue<T> addDependency(String baseName, SimpleAttributeDefinition attribute, Class<T> type, ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
        String dynamicNameElement = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)attribute, model);
        InjectedValue injectedValue = new InjectedValue();
        if (dynamicNameElement != null) {
            serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)baseName, (String)dynamicNameElement), type), type, (Injector)injectedValue);
        }
        return injectedValue;
    }

    static ResourceDefinition getServerSSLContextDefinition() {
        final SimpleAttributeDefinition providersDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDERS).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.ssl-context", true)).setAllowExpression(false)).build();
        AttributeDefinition[] attributes = new AttributeDefinition[]{SECURITY_DOMAIN, CIPHER_SUITE_FILTER, PROTOCOLS, WANT_CLIENT_AUTH, NEED_CLIENT_AUTH, AUTHENTICATION_OPTIONAL, USE_CIPHER_SUITES_ORDER, MAXIMUM_SESSION_CACHE_SIZE, SESSION_TIMEOUT, KEY_MANAGERS, TRUST_MANAGERS, providersDefinition, PROVIDER_NAME};
        return new SSLContextDefinition("server-ssl-context", true, (AbstractAddStepHandler)new TrivialAddHandler<SSLContext>(SSLContext.class, attributes, new RuntimeCapability[]{Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<SSLContext> getValueSupplier(ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InjectedValue securityDomainInjector = SSLDefinitions.addDependency("org.wildfly.security.security-domain", SECURITY_DOMAIN, SecurityDomain.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue keyManagersInjector = SSLDefinitions.addDependency("org.wildfly.security.key-managers", KEY_MANAGERS, KeyManager[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue trustManagersInjector = SSLDefinitions.addDependency("org.wildfly.security.trust-managers", TRUST_MANAGERS, TrustManager[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue providersInjector = SSLDefinitions.addDependency("org.wildfly.security.providers", providersDefinition, Provider[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                String providerName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PROVIDER_NAME, model);
                List protocols = PROTOCOLS.unwrap((ExpressionResolver)context, model);
                String cipherSuiteFilter = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)CIPHER_SUITE_FILTER, model);
                boolean wantClientAuth = WANT_CLIENT_AUTH.resolveModelAttribute(context, model).asBoolean();
                boolean needClientAuth = NEED_CLIENT_AUTH.resolveModelAttribute(context, model).asBoolean();
                boolean authenticationOptional = AUTHENTICATION_OPTIONAL.resolveModelAttribute(context, model).asBoolean();
                boolean useCipherSuitesOrder = USE_CIPHER_SUITES_ORDER.resolveModelAttribute(context, model).asBoolean();
                int maximumSessionCacheSize = MAXIMUM_SESSION_CACHE_SIZE.resolveModelAttribute(context, model).asInt();
                int sessionTimeout = SESSION_TIMEOUT.resolveModelAttribute(context, model).asInt();
                return () -> {
                    SecurityDomain securityDomain = (SecurityDomain)securityDomainInjector.getOptionalValue();
                    X509ExtendedKeyManager keyManager = SSLDefinitions.getX509KeyManager((KeyManager[])keyManagersInjector.getOptionalValue());
                    X509ExtendedTrustManager trustManager = SSLDefinitions.getX509TrustManager((TrustManager[])trustManagersInjector.getOptionalValue());
                    Object[] providers = SSLDefinitions.filterProviders((Provider[])providersInjector.getOptionalValue(), providerName);
                    SSLContextBuilder builder = new SSLContextBuilder();
                    if (securityDomain != null) {
                        builder.setSecurityDomain(securityDomain);
                    }
                    if (keyManager != null) {
                        builder.setKeyManager(keyManager);
                    }
                    if (trustManager != null) {
                        builder.setTrustManager((X509TrustManager)trustManager);
                    }
                    if (providers != null) {
                        builder.setProviderSupplier(() -> 4.lambda$null$0((Provider[])providers));
                    }
                    if (cipherSuiteFilter != null) {
                        builder.setCipherSuiteSelector(CipherSuiteSelector.fromString((String)cipherSuiteFilter));
                    }
                    if (!protocols.isEmpty()) {
                        builder.setProtocolSelector(ProtocolSelector.empty().add(EnumSet.copyOf(protocols.stream().map(Protocol::forName).collect(Collectors.toList()))));
                    }
                    builder.setWantClientAuth(wantClientAuth).setNeedClientAuth(needClientAuth).setAuthenticationOptional(authenticationOptional).setUseCipherSuitesOrder(useCipherSuitesOrder).setSessionCacheSize(maximumSessionCacheSize).setSessionTimeout(sessionTimeout);
                    if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                        ElytronSubsystemMessages.ROOT_LOGGER.tracef("ServerSSLContext supplying:  securityDomain = %s  keyManager = %s  trustManager = %s  providers = %s  cipherSuiteFilter = %s  protocols = %s  wantClientAuth = %s  needClientAuth = %s  authenticationOptional = %s  maximumSessionCacheSize = %s  sessionTimeout = %s", new Object[]{securityDomain, keyManager, trustManager, Arrays.toString(providers), cipherSuiteFilter, Arrays.toString(protocols.toArray()), wantClientAuth, needClientAuth, authenticationOptional, maximumSessionCacheSize, sessionTimeout});
                    }
                    try {
                        return (SSLContext)builder.build().create();
                    }
                    catch (GeneralSecurityException e) {
                        throw new StartException((Throwable)e);
                    }
                };
            }

            protected Resource createResource(OperationContext context) {
                SSLContextResource resource = new SSLContextResource(Resource.Factory.create(), true);
                context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
                return resource;
            }

            @Override
            protected void installedForResource(ServiceController<SSLContext> serviceController, Resource resource) {
                ((SSLContextResource)resource).setSSLContextServiceController(serviceController);
            }

            private static /* synthetic */ Provider[] lambda$null$0(Provider[] providers) {
                return providers;
            }
        }, attributes);
    }

    static ResourceDefinition getClientSSLContextDefinition() {
        final SimpleAttributeDefinition providersDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDERS).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.ssl-context", true)).setAllowExpression(false)).build();
        AttributeDefinition[] attributes = new AttributeDefinition[]{CIPHER_SUITE_FILTER, PROTOCOLS, USE_CIPHER_SUITES_ORDER, MAXIMUM_SESSION_CACHE_SIZE, SESSION_TIMEOUT, KEY_MANAGERS, TRUST_MANAGERS, providersDefinition, PROVIDER_NAME};
        return new SSLContextDefinition("client-ssl-context", false, (AbstractAddStepHandler)new TrivialAddHandler<SSLContext>(SSLContext.class, attributes, new RuntimeCapability[]{Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<SSLContext> getValueSupplier(ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InjectedValue keyManagersInjector = SSLDefinitions.addDependency("org.wildfly.security.key-managers", KEY_MANAGERS, KeyManager[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue trustManagersInjector = SSLDefinitions.addDependency("org.wildfly.security.trust-managers", TRUST_MANAGERS, TrustManager[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue providersInjector = SSLDefinitions.addDependency("org.wildfly.security.providers", providersDefinition, Provider[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                String providerName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PROVIDER_NAME, model);
                List protocols = PROTOCOLS.unwrap((ExpressionResolver)context, model);
                String cipherSuiteFilter = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)CIPHER_SUITE_FILTER, model);
                boolean useCipherSuitesOrder = USE_CIPHER_SUITES_ORDER.resolveModelAttribute(context, model).asBoolean();
                int maximumSessionCacheSize = MAXIMUM_SESSION_CACHE_SIZE.resolveModelAttribute(context, model).asInt();
                int sessionTimeout = SESSION_TIMEOUT.resolveModelAttribute(context, model).asInt();
                return () -> {
                    X509ExtendedKeyManager keyManager = SSLDefinitions.getX509KeyManager((KeyManager[])keyManagersInjector.getOptionalValue());
                    X509ExtendedTrustManager trustManager = SSLDefinitions.getX509TrustManager((TrustManager[])trustManagersInjector.getOptionalValue());
                    Object[] providers = SSLDefinitions.filterProviders((Provider[])providersInjector.getOptionalValue(), providerName);
                    SSLContextBuilder builder = new SSLContextBuilder();
                    if (keyManager != null) {
                        builder.setKeyManager(keyManager);
                    }
                    if (trustManager != null) {
                        builder.setTrustManager((X509TrustManager)trustManager);
                    }
                    if (providers != null) {
                        builder.setProviderSupplier(() -> 5.lambda$null$0((Provider[])providers));
                    }
                    if (cipherSuiteFilter != null) {
                        builder.setCipherSuiteSelector(CipherSuiteSelector.fromString((String)cipherSuiteFilter));
                    }
                    if (!protocols.isEmpty()) {
                        builder.setProtocolSelector(ProtocolSelector.empty().add(EnumSet.copyOf(protocols.stream().map(Protocol::forName).collect(Collectors.toList()))));
                    }
                    builder.setClientMode(true).setUseCipherSuitesOrder(useCipherSuitesOrder).setSessionCacheSize(maximumSessionCacheSize).setSessionTimeout(sessionTimeout);
                    if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                        ElytronSubsystemMessages.ROOT_LOGGER.tracef("ClientSSLContext supplying:  keyManager = %s  trustManager = %s  providers = %s  cipherSuiteFilter = %s  protocols = %s  maximumSessionCacheSize = %s  sessionTimeout = %s", new Object[]{keyManager, trustManager, Arrays.toString(providers), cipherSuiteFilter, Arrays.toString(protocols.toArray()), maximumSessionCacheSize, sessionTimeout});
                    }
                    try {
                        return (SSLContext)builder.build().create();
                    }
                    catch (GeneralSecurityException e) {
                        throw new StartException((Throwable)e);
                    }
                };
            }

            protected Resource createResource(OperationContext context) {
                SSLContextResource resource = new SSLContextResource(Resource.Factory.create(), false);
                context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
                return resource;
            }

            @Override
            protected void installedForResource(ServiceController<SSLContext> serviceController, Resource resource) {
                ((SSLContextResource)resource).setSSLContextServiceController(serviceController);
            }

            private static /* synthetic */ Provider[] lambda$null$0(Provider[] providers) {
                return providers;
            }
        }, attributes);
    }

    private static Provider[] filterProviders(Provider[] all, String provider) {
        if (provider == null || all == null) {
            return all;
        }
        return (Provider[])Arrays.stream(all).filter(current -> provider.equals(current.getName())).toArray(Provider[]::new);
    }

    private static X509ExtendedKeyManager getX509KeyManager(KeyManager[] keyManagers) throws StartException {
        if (keyManagers == null) {
            return null;
        }
        for (KeyManager current : keyManagers) {
            if (!(current instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)current;
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.noTypeFound(X509ExtendedKeyManager.class.getSimpleName());
    }

    private static X509ExtendedTrustManager getX509TrustManager(TrustManager[] trustManagers) throws StartException {
        if (trustManagers == null) {
            return null;
        }
        for (TrustManager current : trustManagers) {
            if (!(current instanceof X509ExtendedTrustManager)) continue;
            return (X509ExtendedTrustManager)current;
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.noTypeFound(X509ExtendedTrustManager.class.getSimpleName());
    }

    static abstract class SSLContextRuntimeHandler
    extends ElytronRuntimeOnlyHandler {
        SSLContextRuntimeHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName serviceName = this.getSSLContextServiceUtil().serviceName(operation);
            ServiceController<SSLContext> serviceController = ElytronExtension.getRequiredService(context.getServiceRegistry(false), serviceName, SSLContext.class);
            ServiceController.State serviceState = serviceController.getState();
            if (serviceState != ServiceController.State.UP) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(serviceName, serviceState);
            }
            this.performRuntime(context.getResult(), operation, (SSLContext)serviceController.getService().getValue());
        }

        protected abstract void performRuntime(ModelNode var1, ModelNode var2, SSLContext var3) throws OperationFailedException;

        protected abstract ServiceUtil<SSLContext> getSSLContextServiceUtil();
    }

    private static class SSLContextDefinition
    extends TrivialResourceDefinition {
        final boolean server;

        private SSLContextDefinition(String pathKey, boolean server, AbstractAddStepHandler addHandler, AttributeDefinition[] attributes) {
            super(pathKey, addHandler, attributes, Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY);
            this.server = server;
        }

        @Override
        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            super.registerAttributes(resourceRegistration);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ACTIVE_SESSION_COUNT, (OperationStepHandler)new SSLContextRuntimeHandler(){

                @Override
                protected void performRuntime(ModelNode result, ModelNode operation, SSLContext sslContext) throws OperationFailedException {
                    SSLSessionContext sessionContext = server ? sslContext.getServerSessionContext() : sslContext.getClientSessionContext();
                    result.set(Collections.list(sessionContext.getIds()).stream().mapToInt(b -> 1).sum());
                }

                @Override
                protected ServiceUtil<SSLContext> getSSLContextServiceUtil() {
                    return server ? SERVER_SERVICE_UTIL : CLIENT_SERVICE_UTIL;
                }
            });
        }

        public void registerChildren(ManagementResourceRegistration resourceRegistration) {
            super.registerChildren(resourceRegistration);
            resourceRegistration.registerSubModel((ResourceDefinition)new SSLSessionDefinition(this.server));
        }
    }

    static class StringValuesValidator
    extends ModelTypeValidator
    implements AllowedValuesValidator {
        private List<ModelNode> allowedValues = new ArrayList<ModelNode>();

        StringValuesValidator(String ... values) {
            super(ModelType.STRING);
            for (String value : values) {
                this.allowedValues.add(new ModelNode().set(value));
            }
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.isDefined() && !this.allowedValues.contains(value)) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidValue(value.asString(), parameterName, this.allowedValues));
            }
        }

        public List<ModelNode> getAllowedValues() {
            return this.allowedValues;
        }
    }
}

