/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRestartParentWriteAttributeHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.realm.token.TokenSecurityRealm;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.realm.token.validator.JwtValidator;
import org.wildfly.security.auth.realm.token.validator.OAuth2IntrospectValidator;
import org.wildfly.security.auth.server.SecurityRealm;

class TokenRealmDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition PRINCIPAL_CLAIM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal-claim", ModelType.STRING, true).setDefaultValue(new ModelNode("username"))).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PRINCIPAL_CLAIM, JwtValidatorAttributes.JWT_VALIDATOR, OAuth2IntrospectionValidatorAttributes.OAUTH2_INTROSPECTION_VALIDATOR};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);

    TokenRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"token-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("token-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteAttributeHandler handler = new WriteAttributeHandler();
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }

    private static class URLValidator
    extends StringLengthValidator {
        private URLValidator() {
            super(1, false, false);
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            String url = value.asString();
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.invalidURL(url, e);
            }
        }
    }

    private static class WriteAttributeHandler
    extends ElytronRestartParentWriteAttributeHandler {
        WriteAttributeHandler() {
            super("token-realm", ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            String name = parentAddress.getLastElement().getValue();
            return Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(name).getCapabilityServiceName();
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(new HashSet<RuntimeCapability>(Arrays.asList(Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY)), ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            String address = context.getCurrentAddressValue();
            ServiceName mainServiceName = Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            ServiceName aliasServiceName = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            final ModelNode principalClaimNode = PRINCIPAL_CLAIM.resolveModelAttribute(context, operation);
            if (operation.hasDefined("jwt")) {
                ModelNode jwtValidatorNode = JwtValidatorAttributes.JWT_VALIDATOR.resolveModelAttribute(context, operation);
                final String[] issuer = this.asStringArrayIfDefined(context, JwtValidatorAttributes.ISSUER, jwtValidatorNode);
                final String[] audience = this.asStringArrayIfDefined(context, JwtValidatorAttributes.AUDIENCE, jwtValidatorNode);
                final String publicKey = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)JwtValidatorAttributes.PUBLIC_KEY, jwtValidatorNode);
                TrivialService<SecurityRealm> service = new TrivialService<SecurityRealm>(new TrivialService.ValueSupplier<SecurityRealm>(){

                    @Override
                    public SecurityRealm get() throws StartException {
                        JwtValidator.Builder jwtValidatorBuilder = JwtValidator.builder();
                        if (issuer != null) {
                            jwtValidatorBuilder.issuer(issuer);
                        }
                        if (audience != null) {
                            jwtValidatorBuilder.audience(audience);
                        }
                        if (publicKey != null) {
                            jwtValidatorBuilder.publicKey(publicKey.getBytes(StandardCharsets.UTF_8));
                        }
                        return TokenSecurityRealm.builder().principalClaimName(principalClaimNode.asString()).validator((TokenValidator)jwtValidatorBuilder.build()).build();
                    }

                    @Override
                    public void dispose() {
                    }
                });
                serviceTarget.addService(mainServiceName, service).addAliases(new ServiceName[]{aliasServiceName}).install();
            } else if (operation.hasDefined("oauth2-introspection")) {
                ModelNode oAuth2IntrospectionNode = OAuth2IntrospectionValidatorAttributes.OAUTH2_INTROSPECTION_VALIDATOR.resolveModelAttribute(context, operation);
                final String clientId = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)OAuth2IntrospectionValidatorAttributes.CLIENT_ID, oAuth2IntrospectionNode);
                final String clientSecret = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)OAuth2IntrospectionValidatorAttributes.CLIENT_SECRET, oAuth2IntrospectionNode);
                final String introspectionUrl = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)OAuth2IntrospectionValidatorAttributes.INTROSPECTION_URL, oAuth2IntrospectionNode);
                String sslContextRef = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)OAuth2IntrospectionValidatorAttributes.SSL_CONTEXT, oAuth2IntrospectionNode);
                final String hostNameVerificationPolicy = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)OAuth2IntrospectionValidatorAttributes.HOSTNAME_VERIFICATION_POLICY, oAuth2IntrospectionNode);
                final InjectedValue sslContextInjector = new InjectedValue();
                TrivialService<SecurityRealm> service = new TrivialService<SecurityRealm>(new TrivialService.ValueSupplier<SecurityRealm>(){

                    @Override
                    public SecurityRealm get() throws StartException {
                        try {
                            HostnameVerifier verifier = null;
                            if (hostNameVerificationPolicy != null) {
                                verifier = OAuth2IntrospectionValidatorAttributes.HostnameVerificationPolicy.valueOf(hostNameVerificationPolicy).getVerifier();
                            }
                            OAuth2IntrospectValidator.Builder builder = OAuth2IntrospectValidator.builder().clientId(clientId).clientSecret(clientSecret).tokenIntrospectionUrl(new URL(introspectionUrl)).useSslContext((SSLContext)sslContextInjector.getOptionalValue()).useSslHostnameVerifier(verifier);
                            return TokenSecurityRealm.builder().principalClaimName(principalClaimNode.asString()).validator((TokenValidator)builder.build()).build();
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException("Failed to parse token introspection URL.", e);
                        }
                    }

                    @Override
                    public void dispose() {
                    }
                });
                ServiceBuilder serviceBuilder = serviceTarget.addService(mainServiceName, service).addAliases(new ServiceName[]{aliasServiceName});
                if (sslContextRef != null) {
                    String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.ssl-context", (String)sslContextRef);
                    serviceBuilder.addDependency(context.getCapabilityServiceName(runtimeCapability, SSLContext.class), SSLContext.class, (Injector)sslContextInjector);
                }
                serviceBuilder.install();
            }
        }

        private String[] asStringArrayIfDefined(OperationContext context, StringListAttributeDefinition attributeDefinition, ModelNode model) throws OperationFailedException {
            ModelNode resolved = attributeDefinition.resolveModelAttribute(context, model);
            if (resolved.isDefined()) {
                List values = resolved.asList();
                String[] response = new String[values.size()];
                for (int i = 0; i < response.length; ++i) {
                    response[i] = ((ModelNode)values.get(i)).asString();
                }
                return response;
            }
            return null;
        }
    }

    static class OAuth2IntrospectionValidatorAttributes {
        static final SimpleAttributeDefinition CLIENT_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-id", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition CLIENT_SECRET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-secret", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition INTROSPECTION_URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("introspection-url", ModelType.STRING, false).setAllowExpression(true)).setValidator((ParameterValidator)new URLValidator())).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        protected static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-ssl-context", ModelType.STRING, true).setCapabilityReference("org.wildfly.security.ssl-context", "org.wildfly.security.security-realm", true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).build();
        static final SimpleAttributeDefinition HOSTNAME_VERIFICATION_POLICY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host-name-verification-policy", ModelType.STRING, true).setValidator((ParameterValidator)new EnumValidator(HostnameVerificationPolicy.class, true, true))).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CLIENT_ID, CLIENT_SECRET, INTROSPECTION_URL, SSL_CONTEXT, HOSTNAME_VERIFICATION_POLICY};
        static final ObjectTypeAttributeDefinition OAUTH2_INTROSPECTION_VALIDATOR = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("oauth2-introspection", new AttributeDefinition[]{CLIENT_ID, CLIENT_SECRET, INTROSPECTION_URL, SSL_CONTEXT, HOSTNAME_VERIFICATION_POLICY}).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        OAuth2IntrospectionValidatorAttributes() {
        }

        static enum HostnameVerificationPolicy {
            ANY((s, sslSession) -> true);

            private final HostnameVerifier verifier;

            private HostnameVerificationPolicy(HostnameVerifier verifier) {
                this.verifier = verifier;
            }

            HostnameVerifier getVerifier() {
                return this.verifier;
            }
        }
    }

    static class JwtValidatorAttributes {
        static final StringListAttributeDefinition ISSUER = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("issuer").setAllowExpression(true)).setRequired(false)).setMinSize(1)).build();
        static final StringListAttributeDefinition AUDIENCE = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("audience").setAllowExpression(true)).setRequired(false)).setMinSize(1)).build();
        static final SimpleAttributeDefinition PUBLIC_KEY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("public-key", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ISSUER, AUDIENCE, PUBLIC_KEY};
        static final ObjectTypeAttributeDefinition JWT_VALIDATOR = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("jwt", new AttributeDefinition[]{ISSUER, AUDIENCE, PUBLIC_KEY}).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        JwtValidatorAttributes() {
        }
    }
}

